/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.core;

import com.sas.contentserver.core.SASNodeImpl;
import java.util.Map;
import org.apache.jackrabbit.core.AbstractNodeData;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.version.VersionHistoryImpl;
import org.apache.jackrabbit.core.version.VersionImpl;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SASItemManager
extends ItemManager {
    private final Logger log = LoggerFactory.getLogger(SASItemManager.class);

    public SASItemManager(SessionContext sessionContext) {
        super(sessionContext);
    }

    protected NodeImpl createNodeInstance(AbstractNodeData data) {
        NodeState state = data.getNodeState();
        if (state.getNodeTypeName().equals((Object)NameConstants.NT_VERSION)) {
            return new VersionImpl((ItemManager)this, this.sessionContext, data);
        }
        if (state.getNodeTypeName().equals((Object)NameConstants.NT_VERSIONHISTORY)) {
            return new VersionHistoryImpl((ItemManager)this, this.sessionContext, data);
        }
        return new SASNodeImpl(this, this.sessionContext, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictItem(ItemId id) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("removing items " + id + " from cache");
        }
        Map map = this.itemCache;
        synchronized (map) {
            this.itemCache.remove(id);
            if (id.denotesNode()) {
                this.shareableNodesCache.evictAll((NodeId)id);
            }
        }
    }
}

