/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.core.BatchedItemOperations;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.security.authorization.AccessControlConstants;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.state.UpdatableItemStateManager;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;

public class SASBatchedItemOperations
extends BatchedItemOperations {
    public SASBatchedItemOperations(UpdatableItemStateManager stateMgr, SessionContext sessionContext) throws RepositoryException {
        super(stateMgr, sessionContext);
    }

    public NodeId copy(Path srcPath, ItemStateManager srcStateMgr, HierarchyManager srcHierMgr, AccessManager srcAccessMgr, Path destPath, int flag) throws ConstraintViolationException, AccessDeniedException, VersionException, PathNotFoundException, ItemExistsException, LockException, RepositoryException, IllegalStateException {
        NodeId ret = super.copy(srcPath, srcStateMgr, srcHierMgr, srcAccessMgr, destPath, flag);
        this.setJcrRemoveChildNodes(ret);
        return ret;
    }

    public NodeId move(Path srcPath, Path destPath) throws ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException, IllegalStateException {
        NodeId ret = super.move(srcPath, destPath);
        this.setJcrRemoveChildNodes(ret);
        return ret;
    }

    private void setJcrRemoveChildNodes(NodeId targetId) throws ItemExistsException, ConstraintViolationException, IllegalStateException, RepositoryException {
        NodeState target = this.getNodeState(targetId);
        List<ChildNodeEntry> aceEntries = this.getAces(target);
        ArrayList<NodeState> aceStates = new ArrayList<NodeState>();
        ArrayList<String> principals = new ArrayList<String>();
        for (ChildNodeEntry entry : aceEntries) {
            aceStates.add(this.getNodeState(entry.getId()));
        }
        for (NodeState state : aceStates) {
            InternalValue[] privs;
            if (!state.hasPropertyName(AccessControlConstants.P_PRIVILEGES)) continue;
            PropertyState propState = this.getPropertyState(new PropertyId(state.getNodeId(), AccessControlConstants.P_PRIVILEGES));
            for (InternalValue priv : privs = propState.getValues()) {
                if (!priv.getName().getNamespaceURI().equals("{http://sas.com/XmlNamespaces/DAV}delete".substring(1, "{http://sas.com/XmlNamespaces/DAV}delete".indexOf(125))) || !priv.getName().getLocalName().equalsIgnoreCase("{http://sas.com/XmlNamespaces/DAV}delete".substring("{http://sas.com/XmlNamespaces/DAV}delete".indexOf(125) + 1))) continue;
                PropertyState principalState = this.getPropertyState(new PropertyId(state.getNodeId(), AccessControlConstants.P_PRINCIPAL_NAME));
                principals.add(principalState.getValues()[0].getString());
            }
        }
        NameFactory NF = NameFactoryImpl.getInstance();
        NodeState parentState = this.getNodeState(target.getParentId());
        List policies = parentState.getChildNodeEntries(AccessControlConstants.N_POLICY);
        if (!policies.isEmpty()) {
            NodeState acl = this.getNodeState(((ChildNodeEntry)policies.get(0)).getId());
            int numAces = this.getAces(parentState).size() - 1;
            for (String principal : principals) {
                String allowName = numAces == -1 ? "{}allow" : "{}allow" + numAces;
                NodeState allow = this.createNodeState(acl, NF.create(allowName), AccessControlConstants.NT_REP_GRANT_ACE, null, null);
                PropertyState principalProperty = this.createPropertyState(allow, AccessControlConstants.P_PRINCIPAL_NAME, 1, 1);
                principalProperty.setType(1);
                principalProperty.setValues(new InternalValue[]{InternalValue.create((String)principal)});
                this.store((ItemState)principalProperty);
                PropertyState privProperty = this.createPropertyState(allow, AccessControlConstants.P_PRIVILEGES, 7, 1);
                privProperty.setType(7);
                privProperty.setMultiValued(true);
                InternalValue[] privs = new InternalValue[]{InternalValue.create((Name)NF.create("http://www.jcp.org/jcr/1.0", "{http://www.jcp.org/jcr/1.0}removeChildNodes".substring("{http://www.jcp.org/jcr/1.0}removeChildNodes".indexOf(125) + 1)))};
                privProperty.setValues(privs);
                this.store((ItemState)privProperty);
                this.store((ItemState)allow);
                ++numAces;
            }
            this.store((ItemState)acl);
            this.store((ItemState)parentState);
        }
    }

    private List<ChildNodeEntry> getAces(NodeState state) throws ItemNotFoundException, RepositoryException {
        List entries = state.getChildNodeEntries(AccessControlConstants.N_POLICY);
        if (!entries.isEmpty()) {
            ChildNodeEntry policyEntry = (ChildNodeEntry)entries.get(0);
            NodeState policyState = this.getNodeState(policyEntry.getId());
            return policyState.getChildNodeEntries();
        }
        return Collections.emptyList();
    }

    protected static int getCopyFlag() {
        return 0;
    }
}

