/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.commons.time;

import com.sas.framework.commons.time.PeriodType;
import com.sas.framework.commons.time.PeriodTypeN;
import com.sas.framework.commons.time.PeriodTypeName;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;

public final class Year
extends PeriodTypeN {
    private static final long serialVersionUID = 1L;
    private static final String KEY = "Y";

    public static Year getYear(int n) {
        Year year = (Year)Year.getInstance(KEY, n);
        if (null == year) {
            year = new Year(n);
        }
        return year;
    }

    private Year(int key) {
        super(KEY, key);
    }

    @Override
    public PeriodType next() {
        return this.nextYear();
    }

    @Override
    public PeriodType prev() {
        return this.prevYear();
    }

    public Year nextYear() {
        return Year.getYear(this.getCalendarValue() + 1);
    }

    public Year prevYear() {
        return Year.getYear(this.getCalendarValue() - 1);
    }

    @Override
    public PeriodTypeName getName() {
        return PeriodTypeName.YEAR;
    }

    @Override
    protected String getResourceKey() {
        return "Enum.YearN.txt";
    }

    @Override
    protected String getResourceKeyForAbbreviation() {
        return "Enum.YN.txt";
    }

    @Override
    public String getCalendarValueAsString() {
        int year = this.getCalendarValue();
        GregorianCalendar gc = new GregorianCalendar(year, 0, 1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        return sdf.format(gc.getTime());
    }
}

