/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.commons.time;

import com.sas.framework.commons.AbstractEnum;
import com.sas.framework.commons.time.PeriodType;
import com.sas.framework.commons.time.PeriodTypeName;
import java.util.Locale;

public final class Month
extends PeriodType {
    private static final long serialVersionUID = 1L;
    public static final Month JANUARY = new Month(0, "January");
    public static final Month FEBRUARY = new Month(1, "February");
    public static final Month MARCH = new Month(2, "March");
    public static final Month APRIL = new Month(3, "April");
    public static final Month MAY = new Month(4, "May");
    public static final Month JUNE = new Month(5, "June");
    public static final Month JULY = new Month(6, "July");
    public static final Month AUGUST = new Month(7, "August");
    public static final Month SEPTEMBER = new Month(8, "September");
    public static final Month OCTOBER = new Month(9, "October");
    public static final Month NOVEMBER = new Month(10, "November");
    public static final Month DECEMBER = new Month(11, "December");
    public static final Month[] MONTHS = new Month[]{JANUARY, FEBRUARY, MARCH, APRIL, MAY, JUNE, JULY, AUGUST, SEPTEMBER, OCTOBER, NOVEMBER, DECEMBER};
    private final int _calendarValue;

    public static Month getMonth(String key) {
        return (Month)Month.getInstance((String)key, (AbstractEnum[])MONTHS);
    }

    public static Month getMonth(int calendarValue) {
        return MONTHS[calendarValue];
    }

    private Month(int calendarValue, String key) {
        super(key);
        this._calendarValue = calendarValue;
    }

    public int getCalendarValue() {
        return this._calendarValue;
    }

    @Override
    public PeriodType next() {
        return this.nextMonth();
    }

    @Override
    public PeriodType prev() {
        return this.prevMonth();
    }

    public Month nextMonth() {
        int m = this.getCalendarValue();
        m = m == 11 ? 0 : ++m;
        return Month.getMonth(m);
    }

    public Month prevMonth() {
        int m = this.getCalendarValue();
        m = m == 0 ? 11 : --m;
        return Month.getMonth(m);
    }

    @Override
    public PeriodTypeName getName() {
        return PeriodTypeName.MONTH;
    }

    public String getLabel(Locale locale) {
        return this.getDateFormatSymbols(locale).getMonths()[this.getCalendarValue()];
    }

    @Override
    public String getAbbreviation(Locale locale) {
        return this.getDateFormatSymbols(locale).getShortMonths()[this.getCalendarValue()];
    }
}

