/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.commons.time;

import com.sas.framework.commons.AbstractEnum;
import com.sas.framework.commons.time.PeriodType;
import com.sas.framework.commons.time.PeriodTypeName;
import java.util.Locale;

public final class Day
extends PeriodType {
    private static final long serialVersionUID = 1L;
    public static final Day SUNDAY = new Day(1, "Sunday");
    public static final Day MONDAY = new Day(2, "Monday");
    public static final Day TUESDAY = new Day(3, "Tuesday");
    public static final Day WEDNESDAY = new Day(4, "Wednesday");
    public static final Day THURSDAY = new Day(5, "Thursday");
    public static final Day FRIDAY = new Day(6, "Friday");
    public static final Day SATURDAY = new Day(7, "Saturday");
    public static final Day[] DAYS = new Day[]{SUNDAY, MONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY};
    private final int _calendarValue;

    public static Day getDay(String key) {
        return (Day)Day.getInstance((String)key, (AbstractEnum[])DAYS);
    }

    public static Day getDay(int calendarValue) {
        return DAYS[calendarValue - 1];
    }

    private Day(int calendarValue, String key) {
        super(key);
        this._calendarValue = calendarValue;
    }

    public int getCalendarValue() {
        return this._calendarValue;
    }

    @Override
    public PeriodType next() {
        return this.nextDay();
    }

    @Override
    public PeriodType prev() {
        return this.prevDay();
    }

    public Day nextDay() {
        int d = this.getCalendarValue();
        d = d == 7 ? 1 : ++d;
        return Day.getDay(d);
    }

    public Day prevDay() {
        int d = this.getCalendarValue();
        d = d == 1 ? 7 : --d;
        return Day.getDay(d);
    }

    @Override
    public PeriodTypeName getName() {
        return PeriodTypeName.DAY;
    }

    public String getLabel(Locale locale) {
        return this.getDateFormatSymbols(locale).getWeekdays()[this.getCalendarValue()];
    }

    @Override
    public String getAbbreviation(Locale locale) {
        return this.getDateFormatSymbols(locale).getShortWeekdays()[this.getCalendarValue()];
    }
}

