/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.security.login;

import com.sas.framework.commons.TenantIdentifier;
import com.sas.framework.commons.holders.TenantHolder;
import com.sas.iom.SASIOMCommon.IFilteredList;
import com.sas.iom.SASIOMCommon.IServerInformation;
import com.sas.iom.SASIOMCommon.IServerInformationHelper;
import com.sas.iom.SASIOMDefs.AnySeqHolder;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.IOMIHelper;
import com.sas.meta.SASOMI.ISecurityPackage.InvalidCredHandle;
import com.sas.meta.SASOMI.ISecurity_1_1;
import com.sas.meta.SASOMI.ISecurity_1_1Helper;
import com.sas.meta.SASOMI.ISecurity_1_1Package.InvalidInfoType;
import com.sas.meta.SASOMI.ISecurity_1_1Package.InvalidOptionName;
import com.sas.meta.SASOMI.ISecurity_1_1Package.InvalidOptionValue;
import com.sas.meta.SASOMI.IServer;
import com.sas.meta.SASOMI.IServerHelper;
import com.sas.services.connection.Cluster;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryInterface;
import com.sas.services.connection.ConnectionFactoryManager;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.ConnectionMetadataInterface;
import com.sas.services.connection.Credential;
import com.sas.services.connection.ExpiredCredentialsException;
import com.sas.services.connection.FatalConnectionFactoryException;
import com.sas.services.connection.InvalidCredentialsException;
import com.sas.services.connection.ManualConnectionFactoryConfiguration;
import com.sas.services.connection.MetadataClusterUtil;
import com.sas.services.connection.PasswordCredential;
import com.sas.services.security.login.BadHostException;
import com.sas.services.security.login.ConnectRefusedException;
import com.sas.services.security.login.ConnectionResourcesCallback;
import com.sas.services.security.login.CredentialException;
import com.sas.services.security.login.ExpiredCredentialException;
import com.sas.services.security.login.ExternalIdPrincipal;
import com.sas.services.security.login.LoginPropertyConstants;
import com.sas.services.security.login.OMIServerPrincipal;
import com.sas.services.security.login.PFSCredential;
import com.sas.services.security.login.PFSGroupPrincipal;
import com.sas.services.security.login.PFSPrincipal;
import com.sas.services.security.login.PFSRolePrincipal;
import com.sas.services.security.login.RB;
import com.sas.services.security.login.ServerPausedException;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.nio.channels.UnresolvedAddressException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.logging.log4j.LogManager;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SasLoginModule
implements LoginModule {
    private static final int SERVER_STATE_ONLINE = 0;
    private static final int SERVER_STATE_ADMIN = 1;
    private static final int SERVER_STATE_OFFLINE = 2;
    private static final int LENGTH_CHAINED_MESSAGE = 240;
    private static final int MAX_NUM_NESTED_GROUPS = 100;
    private Subject _subject;
    protected CallbackHandler _callbackHandler;
    protected boolean _succeeded;
    protected String _name;
    protected String _username;
    protected String _password;
    protected String _domain;
    private List<String> _aliasDomains = new ArrayList<String>();
    protected Cluster _metadataCluster;
    protected String _defaultDomain;
    protected String _defaultRepository;
    @Deprecated
    protected String _repository;
    protected IOMI _cnxn;
    protected ISecurity_1_1 _iSecurity;
    private boolean _addDomain;
    protected boolean _debug;
    protected boolean _encrypt;
    private Credential _cred;
    private String _pauseComment = null;
    private int _serverState;
    private boolean _noredirect = false;
    private String _tenant;
    private String _host;
    private int _port;
    protected List<PFSPrincipal> _principals = new ArrayList<PFSPrincipal>(5);
    protected List<PFSPrincipal> _groups = new ArrayList<PFSPrincipal>(5);
    protected List<PFSCredential> _credentials = new ArrayList<PFSCredential>(5);
    protected List<PFSPrincipal> _roles = new ArrayList<PFSPrincipal>(5);
    protected ConnectionFactoryInterface cxf;
    protected ConnectionInterface cx;
    protected ConnectionFactoryManager _cxfManager;
    protected boolean _importConnectionResources;
    protected boolean _holdOpenConnection = false;
    protected boolean isSSPI = false;
    private String modulePrefix;

    @Override
    public boolean abort() throws LoginException {
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        java.lang.Object[] arguments;
        if (!this._succeeded) {
            return false;
        }
        Subject subject = this._subject;
        boolean debug = this._debug;
        for (PFSPrincipal p : this._principals) {
            if (!subject.getPrincipals().contains(p)) {
                if (debug) {
                    arguments = new java.lang.Object[]{p.getName()};
                    this.doDebugOutput(MessageFormat.format(this.getRBString("SASLoginModule.addingprincipal.msg.fmt.txt"), arguments));
                }
                subject.getPrincipals().add(p);
                continue;
            }
            if (!(p instanceof OMIServerPrincipal)) continue;
            String name = p.getName();
            String newName = "sas.security." + name;
            OMIServerPrincipal p2 = this.copyServerPrincipal((OMIServerPrincipal)p, newName);
            if (subject.getPrincipals().contains(p2)) continue;
            if (debug) {
                this.doDebugOutput(MessageFormat.format(this.getRBString("SASLoginModule.addingprincipal.msg.fmt.txt"), p2.getName()));
            }
            subject.getPrincipals().add(p2);
        }
        for (PFSPrincipal p : this._groups) {
            if (subject.getPrincipals().contains(p)) continue;
            if (debug) {
                this.doDebugOutput(MessageFormat.format(this.getRBString("SASLoginModule.addinggroup.msg.fmt.txt"), p.getName()));
            }
            subject.getPrincipals().add(p);
        }
        for (PFSPrincipal p : this._roles) {
            if (subject.getPrincipals().contains(p)) continue;
            if (debug) {
                this.doDebugOutput(MessageFormat.format(this.getRBString("SASLoginModule.addinggroup.msg.fmt.txt"), p.getName()));
            }
            subject.getPrincipals().add(p);
        }
        for (PFSCredential pc : this._credentials) {
            if (debug) {
                arguments = new java.lang.Object[]{pc.getUserId(), pc.getDomain()};
                this.doDebugOutput(MessageFormat.format(this.getRBString("SASLoginModule.addcred.msg.fmt.txt"), arguments));
            }
            if (subject.getPrivateCredentials().contains(pc)) continue;
            subject.getPrivateCredentials().add(pc);
        }
        return true;
    }

    protected OMIServerPrincipal copyServerPrincipal(OMIServerPrincipal oldPrincipal, String newName) {
        OMIServerPrincipal p2 = new OMIServerPrincipal(newName);
        p2.setUserType("Person");
        p2.setDescription("");
        p2.setUserId(oldPrincipal.getUserId());
        p2.setPassword(oldPrincipal.getPassword());
        p2.setConnection(oldPrincipal.getIOMI());
        p2.setUserName(oldPrincipal.getUserName());
        p2.setUserClass(oldPrincipal.getUserClass());
        p2.setMetadataCluster(oldPrincipal.getMetadataCluster());
        p2.setDomain(oldPrincipal.getDomain());
        p2.setProtocol("omi");
        p2.setBase(this._defaultRepository);
        p2.setIsValidated(true);
        return p2;
    }

    @Override
    public boolean login() throws LoginException {
        this._succeeded = false;
        if (this._callbackHandler == null) {
            throw new LoginException(this.getRBString("SASLoginModule.nocallback.msg.txt"));
        }
        this._succeeded = this.setupAuthParams();
        if (!this._succeeded) {
            return false;
        }
        this._succeeded = this.setupConnectionResources();
        if (!this._succeeded) {
            return false;
        }
        this._succeeded = this.attemptConnection(this._cred);
        if (!this._succeeded) {
            return false;
        }
        this.getUserInfo();
        this.closeCx();
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        for (PFSPrincipal p : this._principals) {
            if (!this._subject.getPrincipals().contains(p)) continue;
            this._subject.getPrincipals().remove(p);
        }
        for (PFSCredential pc : this._credentials) {
            if (!this._subject.getPrivateCredentials().contains(pc)) continue;
            this._subject.getPrivateCredentials().remove(pc);
        }
        return true;
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        String holdOpenConnectionString;
        String importConnectionResourcesString;
        boolean bl = this._debug = Boolean.parseBoolean((String)options.get("debug")) || LogManager.getLogger(this.getClass()).isDebugEnabled();
        if (this._debug) {
            this.doDebugOutput("Initializing login module.");
        }
        this._name = null;
        this._subject = subject;
        this._callbackHandler = callbackHandler;
        this._succeeded = false;
        this._domain = null;
        this._defaultDomain = (String)options.get("domain");
        String aliasDomain = (String)options.get("aliasdomain");
        if (null != aliasDomain) {
            String[] domains = aliasDomain.split(",");
            this._aliasDomains = Arrays.asList(domains);
        }
        this._defaultRepository = (String)options.get("repository");
        this._addDomain = false;
        String addDomainString = (String)options.get("domainQualifyUid");
        if (addDomainString != null && addDomainString.equalsIgnoreCase(LoginPropertyConstants.PROPERTYVALUE_TRUE)) {
            this._addDomain = true;
        }
        this._encrypt = false;
        String encryptString = (String)options.get("encrypt");
        if (encryptString != null && encryptString.equalsIgnoreCase("true")) {
            this._encrypt = true;
        }
        if ((importConnectionResourcesString = (String)options.get("importConnectionResources")) != null && importConnectionResourcesString.equalsIgnoreCase(LoginPropertyConstants.PROPERTYVALUE_TRUE)) {
            this._importConnectionResources = true;
        }
        if ((holdOpenConnectionString = (String)options.get("holdopenconnection")) != null && holdOpenConnectionString.equalsIgnoreCase(LoginPropertyConstants.PROPERTYVALUE_TRUE)) {
            this._holdOpenConnection = true;
        }
        HashMap<String, String> clusterOptions = new HashMap<String, String>();
        if (this._encrypt) {
            clusterOptions.put("encrypt", "true");
        }
        if (options.containsKey("sspisecuritypackagelist")) {
            clusterOptions.put("sspipackagelist", (String)options.get("sspisecuritypackagelist"));
        }
        if (options.containsKey("sspispn")) {
            clusterOptions.put("sspispn", (String)options.get("sspispn"));
        }
        this._metadataCluster = MetadataClusterUtil.createCluster((String)((String)options.get("host")), (String)((String)options.get("port")), clusterOptions);
        this._tenant = (String)options.get("tenant");
        this._noredirect = Boolean.parseBoolean((String)options.get("noredirect"));
        if (this._debug) {
            this.doDebugOutput(this.getRBString("SASLoginModule.initialized.msg.txt"));
        }
    }

    public static String normalizeIDPropagation(String idp) {
        if (idp == null) {
            return null;
        }
        String normIDP = idp.toLowerCase();
        if (normIDP.equals("none")) {
            return null;
        }
        if (!normIDP.equals("sspi") && !normIDP.equals("trustedpeer")) {
            throw new IllegalArgumentException(idp);
        }
        return normIDP;
    }

    protected final boolean isDebug() {
        return this._debug;
    }

    protected final boolean isEncrypt() {
        return this._encrypt;
    }

    protected final boolean isImportConnectionResources() {
        return this._importConnectionResources;
    }

    protected String getRBString(String key) {
        return RB.getStringResource(key);
    }

    protected final String getDomain() {
        return this._domain;
    }

    protected boolean setupConnectionResources() {
        if (this._importConnectionResources) {
            ConnectionResourcesCallback callback = new ConnectionResourcesCallback();
            Callback[] callbackArr = new Callback[]{callback};
            try {
                this._callbackHandler.handle(callbackArr);
            }
            catch (IOException ioe) {
                return false;
            }
            catch (UnsupportedCallbackException uce) {
                if (this._debug) {
                    this.doDebugOutput(this.getRBString("SASLoginModule.importfailed.msg.txt"));
                }
                return false;
            }
            this._cxfManager = callback.getConnectionFactoryManager();
        } else {
            this._cxfManager = new ConnectionFactoryManager();
        }
        return true;
    }

    protected boolean setupAuthParams() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback("Name"), new PasswordCallback("PWD", false)};
        try {
            this._callbackHandler.handle(callbacks);
            this._username = ((NameCallback)callbacks[0]).getName();
            char[] password = ((PasswordCallback)callbacks[1]).getPassword();
            this._password = password != null ? new String(password) : null;
        }
        catch (IOException ioex) {
            return false;
        }
        catch (UnsupportedCallbackException ucex) {
            this.doDebugOutput("Callbacks threw an UnsupportedCallbackException.");
            return false;
        }
        this.overrideAuthParams();
        if (this._username == null) {
            if (this._debug) {
                this.doDebugOutput(this.getRBString("SASLoginModule.nulluser.msg.txt"));
            }
            return false;
        }
        if (this._username.startsWith("[@")) {
            int index = this._username.indexOf(93);
            if (index > -1) {
                this._domain = this._username.substring(2, index);
                this._username = this._username.substring(index + 1);
            } else {
                this._domain = this._defaultDomain;
            }
        } else {
            this._domain = this._defaultDomain;
        }
        if (this._debug && this._username != null) {
            this.doDebugOutput("User to authenticate: " + this._username);
        }
        if (this._domain != null && !this._domain.equalsIgnoreCase(this._defaultDomain) && !this._aliasDomains.contains(this._domain)) {
            if (this._debug) {
                java.lang.Object[] arguments = new java.lang.Object[]{this._domain, this._defaultDomain};
                this.doDebugOutput(MessageFormat.format(this.getRBString("SASLoginModule.wrongdomain.msg.fmt.txt"), arguments));
                if (this._aliasDomains != null) {
                    arguments = new java.lang.Object[]{this._aliasDomains};
                    this.doDebugOutput(MessageFormat.format(this.getRBString("SASLoginModule.wrongdomainalias.msg.fmt.txt"), arguments));
                }
            }
            return false;
        }
        if (this._addDomain && this._username.indexOf("\\") == -1 && this._username.indexOf("@") == -1) {
            this._username = this._username + '@' + this._domain;
        }
        PasswordCredential cred = new PasswordCredential(this._username, this._password);
        this.setCredential((Credential)cred);
        return true;
    }

    protected void overrideAuthParams() {
    }

    protected void setCredential(Credential cred) {
        this._cred = cred;
    }

    protected boolean attemptConnection(String user, String password) throws LoginException {
        PasswordCredential cred = new PasswordCredential(user, password);
        boolean result = this.attemptConnection((Credential)cred);
        return result;
    }

    protected boolean attemptConnection(Credential cred) throws LoginException {
        if (this._metadataCluster == null) {
            throw new LoginException(this.getRBString("SASLoginModule.invalidserverdef.msg.txt"));
        }
        try {
            ManualConnectionFactoryConfiguration cxfConfig;
            if (this._noredirect) {
                cxfConfig = new ManualConnectionFactoryConfiguration(this._metadataCluster.getServerArray()[0], this._noredirect);
                if (this._debug && this._metadataCluster.getServerArray().length > 1) {
                    this.doDebugOutput("No redirect disables cluster connection");
                }
            } else {
                cxfConfig = new ManualConnectionFactoryConfiguration(this._metadataCluster);
            }
            this.cxf = this._cxfManager.getFactory((ConnectionFactoryConfiguration)cxfConfig);
            if (this._tenant != null) {
                TenantHolder.set((TenantIdentifier)new TenantIdentifier(0, this._tenant));
            }
            this.cx = this.cxf.getConnection(cred);
            this._cnxn = IOMIHelper.narrow((Object)this.cx.getObject());
            if (this._debug) {
                this.doDebugOutput(this.getRBString("SASLoginModule.cnxncmplt.msg.txt"));
            }
            this._iSecurity = ISecurity_1_1Helper.narrow((Object)this.cx.getObject());
            IServer iserver = IServerHelper.narrow((Object)this.cx.getObject());
            StringHolder output = new StringHolder();
            String input = "<PlatformVersion/><ServerState/><PauseComment/>";
            int version = 0;
            iserver.Status("<PlatformVersion/><ServerState/><PauseComment/>", output, "");
            String statResult = output.value;
            int indexVersionStart = statResult.indexOf("<PlatformVersion>");
            int indexVersionEnd = statResult.indexOf("</PlatformVersion>");
            int indexStateStart = statResult.indexOf("<ServerState>");
            int indexStateEnd = statResult.indexOf("</ServerState>");
            int indexCommentStart = statResult.indexOf("<PauseComment>");
            int indexCommentEnd = statResult.indexOf("</PauseComment>");
            String versionString = statResult.substring(indexVersionStart + 17, indexVersionEnd);
            if (versionString != null && versionString.length() > 0) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < versionString.length(); ++i) {
                    char c = versionString.charAt(i);
                    if (c == '.') continue;
                    sb.append(c);
                }
                version = Integer.parseInt(sb.toString());
            }
            if (version < 9200) {
                this.closeCx();
                throw new LoginException(this.getRBString("SASLoginModule.oldversion.msg.txt"));
            }
            String state = statResult.substring(indexStateStart + 13, indexStateEnd);
            this._serverState = state.equalsIgnoreCase("ONLINE") ? 0 : (state.equalsIgnoreCase("ADMIN") ? 1 : 2);
            if (indexCommentStart > -1) {
                this._pauseComment = statResult.substring(indexCommentStart + 14, indexCommentEnd);
            }
            IServerInformation serverInfo = IServerInformationHelper.narrow((Object)this.cx.getObject());
            IFilteredList filtList = serverInfo.UseCategory("Information", "");
            AnySeqHolder anySeqHolder = new AnySeqHolder();
            try {
                filtList.GetAttribute("Server.HostKnownBy", "value", anySeqHolder);
            }
            catch (OBJECT_NOT_EXIST e) {
                try {
                    filtList.GetAttribute("Server.FullyQualifiedDNSName", "value", anySeqHolder);
                }
                catch (OBJECT_NOT_EXIST e2) {
                    filtList.GetAttribute("Server.DNSName", "value", anySeqHolder);
                }
            }
            this._host = anySeqHolder.value[0].extract_string();
            filtList.GetAttribute("IOM.ServerPort", "value", anySeqHolder);
            this._port = anySeqHolder.value[0].extract_long();
            filtList.Close();
        }
        catch (ExpiredCredentialsException ex) {
            this._succeeded = false;
            ExpiredCredentialException ece = new ExpiredCredentialException(ex.getMessage());
            ece.initCause(ex);
            throw ece;
        }
        catch (InvalidCredentialsException ice) {
            this._succeeded = false;
            CredentialException cex = new CredentialException(ice.getMessage());
            cex.initCause(ice);
            throw cex;
        }
        catch (FatalConnectionFactoryException fcfe) {
            this._succeeded = false;
            for (Throwable t = fcfe.getCause(); t != null; t = t.getCause()) {
                if (t instanceof UnknownHostException) {
                    BadHostException bdh = new BadHostException(fcfe.getMessage());
                    bdh.initCause(fcfe);
                    throw bdh;
                }
                if (t instanceof UnresolvedAddressException) {
                    BadHostException bdh = new BadHostException(fcfe.getMessage());
                    bdh.initCause(fcfe);
                    throw bdh;
                }
                if (!(t instanceof ConnectException)) continue;
                ConnectRefusedException crex = new ConnectRefusedException(fcfe.getMessage());
                crex.initCause(fcfe);
                throw crex;
            }
            LoginException lex = new LoginException(fcfe.getMessage());
            lex.initCause(fcfe);
            throw lex;
        }
        catch (Throwable t) {
            this._succeeded = false;
            for (Throwable t2 = t.getCause(); t2 != null; t2 = t2.getCause()) {
                if (t2 instanceof UnresolvedAddressException) {
                    BadHostException bdh = new BadHostException(t.getMessage());
                    bdh.initCause(t);
                    throw bdh;
                }
                if (!(t2 instanceof ConnectException)) continue;
                ConnectRefusedException crex = new ConnectRefusedException(t.getMessage());
                crex.initCause(t);
                throw crex;
            }
            LoginException lex = new LoginException(t.getMessage());
            lex.initCause(t);
            throw lex;
        }
        return true;
    }

    protected String makeChainedMessage(Throwable t) {
        StringBuffer buffer = new StringBuffer(240);
        while (t != null) {
            buffer.append(t.getClass().getName());
            buffer.append(":");
            buffer.append(t.getMessage());
            buffer.append("  ");
            t = t.getCause();
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getUserInfo() throws LoginException {
        try (StringReader strReader = null;){
            PFSCredential pc;
            String resolvedUsername = null;
            if (this._debug) {
                this.doDebugOutput(this.getRBString("SASLoginModule.getngident.msg.txt"));
            }
            IdentityInfo info = this.getUserClass();
            String userClass = info.getUserClass();
            if (this._serverState != 0 && userClass.indexOf("Unrestricted") <= -1) {
                String exceptionString = null;
                exceptionString = this._pauseComment == null || this._pauseComment.length() == 0 ? this.getRBString("SASLoginModule.serverpausednomsg.msg.txt") : this.getRBString("SASLoginModule.serverpaused.msg.txt") + this._pauseComment;
                throw new ServerPausedException(exceptionString);
            }
            StringHolder identHolder = new StringHolder();
            try {
                this._iSecurity.GetIdentity("", identHolder);
            }
            catch (InvalidCredHandle ex) {
                LoginException lex = new LoginException(ex.getMessage());
                lex.initCause(ex);
                throw lex;
            }
            catch (GenericError ex) {
                LoginException lex = new LoginException(ex.getMessage());
                lex.initCause(ex);
                throw lex;
            }
            if (this._debug) {
                this.doDebugOutput(this.getRBString("SASLoginModule.gotident.msg.txt"));
            }
            String identString = identHolder.value;
            if (this.cx instanceof ConnectionMetadataInterface) {
                ConnectionMetadataInterface cxMeta = (ConnectionMetadataInterface)this.cx;
                String dom = cxMeta.getNormalizedDomain();
                resolvedUsername = cxMeta.getNormalizedUserName() + (dom != null && dom.trim().length() > 0 ? "@" + dom : "");
                if (this._username == null && !this.isSSPI) {
                    this._username = cxMeta.getNormalizedUserName();
                    pc = new PFSCredential(this._username, this._password, this._domain);
                    this._credentials.add(pc);
                }
            }
            if (this._username == null && !this.isSSPI) {
                this._username = resolvedUsername;
                PFSCredential pc2 = new PFSCredential(this._username, this._password, this._domain);
                this._credentials.add(pc2);
            }
            if (identString.equals("UNKNOWN:")) {
                if (this._debug) {
                    java.lang.Object[] arguments = new java.lang.Object[]{this._username};
                    this.doDebugOutput(MessageFormat.format(this.getRBString("SASLoginModule.userunknwn.msg.fmt.txt"), arguments));
                }
                this._name = "unknown";
                OMIServerPrincipal p = new OMIServerPrincipal(this._name);
                p.setUserType("Person");
                p.setDescription("");
                p.setUserId(resolvedUsername == null ? this._username : resolvedUsername);
                p.setPassword(this._password);
                p.setUserName(this._name);
                if (info != null) {
                    p.setUserClass(info.getUserClass());
                }
                if (this._holdOpenConnection) {
                    p.setConnection(this._cnxn);
                }
                p.setMetadataCluster(this._metadataCluster);
                p.setHost(this._host);
                p.setPort(this._port);
                p.setDomain(this._domain);
                p.setProtocol("omi");
                p.setBase(this._defaultRepository);
                p.setIsValidated(true);
                this._principals.add(p);
                PFSPrincipal pfsp = new PFSPrincipal(this._username + '@' + this._domain);
                pfsp.setDomain(this._domain);
                this._principals.add(pfsp);
                if (this._username != null) {
                    if (this._username.indexOf("!*(generatedpassworddomain)*!") > -1) {
                        pc = new PFSCredential(resolvedUsername, "", this._domain);
                        this._credentials.add(pc);
                    } else {
                        pc = new PFSCredential(this._username, this._password, this._domain);
                        this._credentials.add(pc);
                    }
                }
                this._succeeded = true;
                boolean pc3 = true;
                return pc3;
            }
            int index = identString.indexOf(":");
            int index2 = identString.indexOf("/");
            String type = identString.substring(index + 1, index2);
            String personId = identString.substring(index2 + 1);
            try {
                Node pnode;
                String getMetadata = null;
                getMetadata = "<GetMetadata>\n  <Metadata>\n    <" + type + " Id=\"" + personId + "\" Name=\"\" Desc=\"\">\n      <IdentityGroups/>\n      <EmailAddresses/>\n      <PhoneNumbers/>\n      <Locations/>\n      <ExternalIdentities/>\n    </" + type + ">\n  </Metadata>\n  <NS>SAS</NS>\n  <Flags>4</Flags>\n  <Options>\n    <Templates>\n      <ExternalIdentity Name=\"\" Context=\"\" Identifier=\"\"/>\n      <Login Name=\"\" UserId=\"\" Password=\"\" >\n        <Domain/>\n      </Login>\n      <Email Name=\"\" Address=\"\" />\n      <Phone Name=\"\" Number=\"\" />\n      <AuthenticationDomain Name=\"\" />\n      <IdentityGroup Name=\"\" GroupType=\"\">\n        <IdentityGroups/>      </IdentityGroup>\n    </Templates>\n  </Options>\n</GetMetadata>\n";
                if (this._debug) {
                    this.doDebugOutput("Client XML: " + getMetadata);
                }
                StringHolder outXMLHolder = new StringHolder();
                this._cnxn.DoRequest(getMetadata, outXMLHolder);
                String outXML = outXMLHolder.value;
                if (this._debug) {
                    this.doDebugOutput("Server XML: " + outXML);
                    this.doDebugOutput(this.getRBString("SASLoginModule.gotident.msg.txt"));
                }
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                strReader = new StringReader(outXML);
                Document doc = null;
                doc = db.parse(new InputSource(strReader));
                if (doc != null) {
                    Node xidnode;
                    Node phnode;
                    Node enode;
                    String loginType;
                    int i;
                    Node lnode;
                    Node node = doc.getFirstChild();
                    pnode = this.getNode(node, "Metadata/" + type);
                    Element element = (Element)pnode;
                    this._name = element.getAttribute("Name");
                    OMIServerPrincipal p = new OMIServerPrincipal(this._name);
                    String description = element.getAttribute("Desc");
                    if (description != null) {
                        p.setDescription(description);
                    }
                    p.setUserId(resolvedUsername == null ? this._username : resolvedUsername);
                    p.setUserType(type);
                    p.setPassword(this._password);
                    p.setUserName(this._name);
                    p.setUserFQID(personId);
                    if (info != null) {
                        p.setUserClass(info.getUserClass());
                    }
                    if (this._holdOpenConnection) {
                        p.setConnection(this._cnxn);
                    }
                    p.setMetadataCluster(this._metadataCluster);
                    p.setHost(this._host);
                    p.setPort(this._port);
                    p.setDomain(this._domain);
                    p.setProtocol("omi");
                    p.setBase(this._defaultRepository);
                    p.setIsValidated(true);
                    this._principals.add(p);
                    PFSPrincipal pfsp = new PFSPrincipal(this._username + '@' + this._domain);
                    pfsp.setDomain(this._domain);
                    pfsp.setReposId(personId);
                    pfsp.setIsValidated(true);
                    this._principals.add(pfsp);
                    if (this._username != null) {
                        PFSCredential pc4;
                        if (this._username.indexOf("!*(generatedpassworddomain)*!") > -1) {
                            pc4 = new PFSCredential(resolvedUsername, "", this._domain);
                            this._credentials.add(pc4);
                        } else {
                            pc4 = new PFSCredential(this._username, this._password, this._domain);
                            this._credentials.add(pc4);
                        }
                    }
                    if ((lnode = this.getNode(pnode, "Logins")) != null) {
                        NodeList loginList = lnode.getChildNodes();
                        int mapSize = loginList.getLength();
                        List<PFSCredential> credentials = this._credentials;
                        boolean debug = this._debug;
                        for (i = 0; i < mapSize; ++i) {
                            Node loginNode = loginList.item(i);
                            loginType = loginNode.getNodeName();
                            if (!loginType.equalsIgnoreCase("Login")) continue;
                            element = (Element)loginNode;
                            String uid = element.getAttribute("UserID");
                            String pw = element.getAttribute("Password");
                            String domain = null;
                            NodeList loginKids = loginNode.getChildNodes();
                            int kidSize = loginKids.getLength();
                            for (int ki = 0; ki < kidSize; ++ki) {
                                Node kidNode = loginKids.item(ki);
                                if (!kidNode.getNodeName().equalsIgnoreCase("Domain")) continue;
                                NodeList domNodes = kidNode.getChildNodes();
                                int domSize = domNodes.getLength();
                                for (int di = 0; di < domSize; ++di) {
                                    Node domNode = domNodes.item(di);
                                    if (!domNode.getNodeName().equalsIgnoreCase("AuthenticationDomain")) continue;
                                    Element delement = (Element)domNode;
                                    domain = delement.getAttribute("Name");
                                }
                                break;
                            }
                            if (debug) {
                                java.lang.Object[] arguments = new java.lang.Object[]{uid, domain};
                                this.doDebugOutput(MessageFormat.format(this.getRBString("SASLoginModule.addcred.msg.fmt.txt"), arguments));
                            }
                            credentials.add(new PFSCredential(uid, pw, domain));
                        }
                    }
                    if ((enode = this.getNode(pnode, "EmailAddresses")) != null) {
                        NodeList emailList = enode.getChildNodes();
                        int mapSize = emailList.getLength();
                        for (i = 0; i < mapSize; ++i) {
                            Node emailNode = emailList.item(i);
                            loginType = emailNode.getNodeName();
                            if (!loginType.equalsIgnoreCase("Email")) continue;
                            element = (Element)emailNode;
                            String address = element.getAttribute("Address");
                            PFSPrincipal mailPrincipal = new PFSPrincipal("EmailAddress");
                            mailPrincipal.setDomain(address);
                            this._principals.add(mailPrincipal);
                        }
                    }
                    if ((phnode = this.getNode(pnode, "PhoneNumbers")) != null) {
                        NodeList phoneList = phnode.getChildNodes();
                        int mapSize = phoneList.getLength();
                        for (int i2 = 0; i2 < mapSize; ++i2) {
                            Node phoneNode = phoneList.item(i2);
                            String loginType2 = phoneNode.getNodeName();
                            if (!loginType2.equalsIgnoreCase("Phone")) continue;
                            element = (Element)phoneNode;
                            String phoneNumber = element.getAttribute("Number");
                            PFSPrincipal phonePrincipal = new PFSPrincipal("PhoneNumber");
                            phonePrincipal.setDomain(phoneNumber);
                            this._principals.add(phonePrincipal);
                        }
                    }
                    if ((xidnode = this.getNode(pnode, "ExternalIdentities")) != null) {
                        NodeList exidList = xidnode.getChildNodes();
                        int mapSize = exidList.getLength();
                        for (int i3 = 0; i3 < mapSize; ++i3) {
                            Node emailNode = exidList.item(i3);
                            String loginType3 = emailNode.getNodeName();
                            if (!loginType3.equalsIgnoreCase("ExternalIdentity")) continue;
                            element = (Element)emailNode;
                            String context = element.getAttribute("Context");
                            String identifier = element.getAttribute("Identifier");
                            ExternalIdPrincipal exidPrincipal = new ExternalIdPrincipal(context + "/" + identifier);
                            exidPrincipal.setCategory(context);
                            exidPrincipal.setIdentifier(identifier);
                            this._principals.add(exidPrincipal);
                        }
                    }
                } else {
                    try {
                        this.cx.close();
                        this.cxf.getAdminInterface().shutdown();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    boolean bl = false;
                    return bl;
                }
                this.processGroups(pnode, 0);
            }
            catch (Throwable t) {
                try {
                    this._name = "unknown";
                    OMIServerPrincipal p = new OMIServerPrincipal(this._name);
                    p.setUserType(type);
                    p.setUserName(this._name);
                    p.setDescription("");
                    p.setUserId(resolvedUsername == null ? this._username : resolvedUsername);
                    p.setPassword(this._password);
                    if (this._holdOpenConnection) {
                        p.setConnection(this._cnxn);
                    }
                    p.setMetadataCluster(this._metadataCluster);
                    p.setHost(this._host);
                    p.setPort(this._port);
                    p.setDomain(this._domain);
                    p.setProtocol("omi");
                    p.setBase(this._defaultRepository);
                    p.setIsValidated(true);
                    this._principals.add(p);
                    PFSPrincipal pfsp = new PFSPrincipal(this._username + '@' + this._domain);
                    pfsp.setDomain(this._domain);
                    this._principals.add(pfsp);
                    if (this._username != null) {
                        PFSCredential pc5;
                        if (this._username.indexOf("!*(generatedpassworddomain)*!") > -1) {
                            pc5 = new PFSCredential(resolvedUsername, "", this._domain);
                            this._credentials.add(pc5);
                        } else {
                            pc5 = new PFSCredential(this._username, this._password, this._domain);
                            this._credentials.add(pc5);
                        }
                    }
                    this._succeeded = true;
                    boolean bl = true;
                    return bl;
                }
                catch (Exception ex) {
                    try {
                        this.cx.close();
                        this.cxf.getAdminInterface().shutdown();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    boolean bl = false;
                    if (strReader != null) {
                        strReader.close();
                    }
                    return bl;
                }
            }
        }
        return true;
    }

    private IdentityInfo getUserClass() {
        IdentityInfo info = new IdentityInfo();
        String[][] options = new String[1][2];
        options[0][0] = "ReturnUnrestrictedSource";
        options[0][1] = "";
        VariableArray2dOfStringHolder output = new VariableArray2dOfStringHolder();
        try {
            this._iSecurity.GetInfo("GetIdentityInfo", "", options, output);
            String[][] value = output.value;
            if (value.length > 0) {
                for (int i = 0; i < value.length; ++i) {
                    String keyword = value[i][0];
                    String result = value[i][1];
                    if ("UserClass".equalsIgnoreCase(keyword)) {
                        info.setUserClass(result);
                        continue;
                    }
                    if ("AuthenticatedUserId".equalsIgnoreCase(keyword)) {
                        info.setAuthenticatedUserId(result);
                        continue;
                    }
                    if ("IdentityName".equalsIgnoreCase(keyword)) {
                        info.setName(result);
                        continue;
                    }
                    if ("IdentityType".equalsIgnoreCase(keyword)) {
                        info.setType(result);
                        continue;
                    }
                    if ("IdentityObjectId".equalsIgnoreCase(keyword)) {
                        info.setReposid(result);
                        continue;
                    }
                    if (!"UnrestrictedSource".equalsIgnoreCase(keyword)) continue;
                    info.setPowerSource(result);
                }
            }
        }
        catch (InvalidInfoType ex) {
            return null;
        }
        catch (InvalidOptionName ex) {
            return null;
        }
        catch (InvalidOptionValue ex) {
            return null;
        }
        catch (InvalidCredHandle ex) {
            return null;
        }
        catch (GenericError ex) {
            return null;
        }
        return info;
    }

    protected void closeCx() {
        if (!this._holdOpenConnection) {
            try {
                this.cx.close();
                this.cxf.getAdminInterface().shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected ConnectionFactoryManager getConnectionFactoryManager() {
        return this._cxfManager;
    }

    private void processGroups(Node pnode, int depth) {
        if (depth > 100) {
            return;
        }
        Node inode = this.getNode(pnode, "IdentityGroups");
        if (inode != null) {
            NodeList identList = inode.getChildNodes();
            int iMapSize = identList.getLength();
            boolean debug = this._debug;
            List<PFSCredential> credentials = this._credentials;
            List<PFSPrincipal> roles = this._roles;
            List<PFSPrincipal> groups = this._groups;
            for (int j = 0; j < iMapSize; ++j) {
                java.lang.Object[] arguments;
                Node identNode = identList.item(j);
                String identType = identNode.getNodeName();
                if (!identType.equalsIgnoreCase("IdentityGroup")) continue;
                Element iElement = (Element)identNode;
                String rid = iElement.getAttribute("Id");
                String iName = iElement.getAttribute("Name");
                PFSPrincipal grpPrincipal = null;
                String groupType = iElement.getAttribute("GroupType");
                if (groupType.equalsIgnoreCase("Role")) {
                    grpPrincipal = new PFSRolePrincipal(iName);
                    roles.add(grpPrincipal);
                    if (debug) {
                        arguments = new java.lang.Object[]{grpPrincipal.getName()};
                        this.doDebugOutput(MessageFormat.format(this.getRBString("SASLoginModule.fndrole.msg.fmt.txt"), arguments));
                    }
                } else {
                    grpPrincipal = new PFSGroupPrincipal(iName);
                    groups.add(grpPrincipal);
                    if (debug) {
                        arguments = new java.lang.Object[]{grpPrincipal.getName()};
                        this.doDebugOutput(MessageFormat.format(this.getRBString("SASLoginModule.fndgroup.msg.fmt.txt"), arguments));
                    }
                }
                grpPrincipal.setDomain(this._domain);
                grpPrincipal.setReposId(rid);
                grpPrincipal.setIsValidated(true);
                this.processGroups(identNode, depth + 1);
                Node lnode = this.getNode(identNode, "Logins");
                if (lnode == null) continue;
                NodeList loginList = lnode.getChildNodes();
                int mapSize = loginList.getLength();
                for (int i = 0; i < mapSize; ++i) {
                    Node loginNode = loginList.item(i);
                    String loginType = loginNode.getNodeName();
                    if (!loginType.equalsIgnoreCase("Login")) continue;
                    Element element = (Element)loginNode;
                    String uid = element.getAttribute("UserID");
                    String pw = element.getAttribute("Password");
                    String domain = null;
                    NodeList loginKids = loginNode.getChildNodes();
                    int kidSize = loginKids.getLength();
                    for (int ki = 0; ki < kidSize; ++ki) {
                        Node kidNode = loginKids.item(ki);
                        if (!kidNode.getNodeName().equalsIgnoreCase("Domain")) continue;
                        NodeList domNodes = kidNode.getChildNodes();
                        int domSize = domNodes.getLength();
                        for (int di = 0; di < domSize; ++di) {
                            Node domNode = domNodes.item(di);
                            if (!domNode.getNodeName().equalsIgnoreCase("AuthenticationDomain")) continue;
                            Element delement = (Element)domNode;
                            domain = delement.getAttribute("Name");
                        }
                        break;
                    }
                    if (debug) {
                        java.lang.Object[] arguments2 = new java.lang.Object[]{uid, domain};
                        this.doDebugOutput(MessageFormat.format(this.getRBString("SASLoginModule.fndcred.msg.fmt.txt"), arguments2));
                    }
                    credentials.add(new PFSCredential(uid, pw, domain));
                }
            }
        }
    }

    private Node getNode(Node start, String path) {
        int index = path.indexOf("/");
        String firstElement = null;
        String remainder = null;
        if (index == 0) {
            path = path.substring(1);
            index = path.indexOf("/");
        }
        if (index < 0) {
            firstElement = path;
        } else {
            firstElement = path.substring(0, index);
            remainder = path.substring(index + 1);
        }
        NodeList nodeList = start.getChildNodes();
        int mapSize = nodeList.getLength();
        for (int i = 0; i < mapSize; ++i) {
            Node mapNode = nodeList.item(i);
            if (!mapNode.getNodeName().equals(firstElement)) continue;
            return remainder == null ? mapNode : this.getNode(mapNode, remainder);
        }
        return null;
    }

    protected void doDebugOutput(String message) {
        if (this.modulePrefix == null) {
            this.modulePrefix = "[" + this.getClass().getSimpleName() + "] ";
        }
        System.out.println(this.modulePrefix + message);
        LogManager.getLogger(this.getClass()).debug(message);
    }

    public class IdentityInfo
    implements Serializable {
        private String userClass = null;
        private String authenticatedUserId = null;
        private String name = null;
        private String type = null;
        private String reposid = null;
        private List powerSource = null;

        public final String getUserClass() {
            return this.userClass;
        }

        public final void setUserClass(String userClass) {
            this.userClass = userClass;
        }

        public final String getAuthenticatedUserId() {
            return this.authenticatedUserId;
        }

        public final void setAuthenticatedUserId(String authenticatedUserId) {
            this.authenticatedUserId = authenticatedUserId;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getReposid() {
            return this.reposid;
        }

        public final void setReposid(String reposid) {
            this.reposid = reposid;
        }

        public final List getPowerSource() {
            return this.powerSource;
        }

        public final void setPowerSource(String powerSource) {
            this.powerSource = new ArrayList();
            StringTokenizer st = new StringTokenizer(powerSource, ",");
            while (st.hasMoreTokens()) {
                String nextToken = st.nextToken().trim();
                this.powerSource.add(nextToken);
            }
        }
    }
}

