/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.security.login;

import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.IOMIHelper;
import com.sas.meta.SASOMI.ISecurity;
import com.sas.meta.SASOMI.ISecurityHelper;
import com.sas.services.connection.Cluster;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionFactoryInterface;
import com.sas.services.connection.ConnectionFactoryManager;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.ManualConnectionFactoryConfiguration;
import com.sas.services.security.login.PFSPrincipal;
import com.sas.services.security.login.ServerPrincipal;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;

public class OMIServerPrincipal
extends ServerPrincipal {
    private static final long serialVersionUID = -851069021017620130L;
    private String _password = null;
    private IOMI _cnxn = null;
    private ISecurity _isec;
    private Object _obj2;
    private Cluster metadataCluster;
    protected ConnectionFactoryInterface cxf = null;
    protected ConnectionInterface cx = null;
    private IOMI _trustedCnxn;
    private String _genUser;
    private String _genPass;
    protected ConnectionInterface tcx = null;
    private String _trustedUser;
    private String _trustedPw;
    private String _userFQID;
    private String _userType;
    private String _userClass;
    private String _userName;

    public OMIServerPrincipal(String name) {
        super(name);
    }

    public void setPassword(String password) {
        if (this._password == null) {
            this._password = password;
        }
    }

    public String getPassword() {
        return this._password;
    }

    public Cluster getMetadataCluster() {
        return this.metadataCluster;
    }

    public void setMetadataCluster(Cluster metadataCluster) {
        this.metadataCluster = metadataCluster;
    }

    public ConnectionFactoryConfiguration getConnectionFactoryConfiguration() {
        return null;
    }

    public void setConnectionFactoryConfiguration(ConnectionFactoryConfiguration connectionFactoryConfiguration) {
    }

    public IOMI getIOMI() {
        return this._cnxn;
    }

    public void setConnection(IOMI iomi) {
        this._cnxn = iomi;
        if (this._cnxn != null) {
            Object obj = this._cnxn._duplicate();
            this._isec = ISecurityHelper.narrow((Object)obj);
        } else {
            this._isec = null;
        }
    }

    public ISecurity getISecurity() {
        if (this._isec == null) {
            try {
                this.attemptConnection(this.getUserId(), this._password);
            }
            catch (Exception ex) {
                this._isec = null;
            }
        }
        return this._isec;
    }

    protected boolean attemptConnection(String user, String password) throws ConnectionFactoryException {
        if ((password == null || password.length() == 0) && this._trustedUser != null && this.generatePassword()) {
            user = this._genUser;
            password = this._genPass;
        }
        if (this.cxf == null) {
            ManualConnectionFactoryConfiguration cxfConfig = new ManualConnectionFactoryConfiguration(this.metadataCluster);
            ConnectionFactoryManager cxfManager = new ConnectionFactoryManager();
            this.cxf = cxfManager.getFactory((ConnectionFactoryConfiguration)cxfConfig);
        }
        this.cx = this.cxf.getConnection(user, password);
        this._obj2 = this.cx.getObject();
        this.closeTrust();
        this._cnxn = IOMIHelper.narrow((Object)this._obj2);
        Object obj = this._cnxn._duplicate();
        this._isec = ISecurityHelper.narrow((Object)obj);
        return true;
    }

    public boolean generatePassword() {
        if (this._trustedCnxn == null) {
            try {
                if (this.cxf == null) {
                    ManualConnectionFactoryConfiguration cxfConfig = new ManualConnectionFactoryConfiguration(this.metadataCluster);
                    ConnectionFactoryManager cxfManager = new ConnectionFactoryManager();
                    this.cxf = cxfManager.getFactory((ConnectionFactoryConfiguration)cxfConfig);
                }
                this.tcx = this.cxf.getConnection(this._trustedUser, this._trustedPw);
                Object obj2 = this.tcx.getObject();
                this._trustedCnxn = IOMIHelper.narrow((Object)obj2);
            }
            catch (Throwable t) {
                if (this.tcx != null) {
                    this.tcx.close();
                }
                return false;
            }
        }
        StringHolder qualUserNameHolder = new StringHolder();
        StringHolder genPasswordHolder = new StringHolder();
        try {
            this.tcx.generatePassword(this.getUserId(), qualUserNameHolder, genPasswordHolder);
        }
        catch (Exception se) {
            se.printStackTrace(System.out);
            this.closeTrust();
            return false;
        }
        this._genUser = qualUserNameHolder.value;
        this._genPass = genPasswordHolder.value;
        return true;
    }

    private void closeConnection() {
        try {
            if (this.cx != null) {
                this.cx.close();
                this.cxf.getAdminInterface().destroy();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    private void closeTrust() {
        if (this.tcx == null) {
            return;
        }
        try {
            this.tcx.close();
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    public String getTrustedPw() {
        return this._trustedPw;
    }

    public void setTrustedPw(String pw) {
        this._trustedPw = pw;
    }

    public String getTrustedUser() {
        return this._trustedUser;
    }

    public void setTrustedUser(String user) {
        this._trustedUser = user;
    }

    protected void finalize() throws Throwable {
        this.closeConnection();
        super.finalize();
    }

    @Override
    public void setProcessed() {
        if (this._cnxn != null) {
            this._cnxn = null;
        }
        if (this._isec != null) {
            this._isec = null;
        }
        if (this.cx != null) {
            this.cx = null;
        }
        super.setProcessed();
    }

    public final String get_userFQID() {
        return this._userFQID;
    }

    public final void setUserFQID(String userfqid) {
        this._userFQID = userfqid;
    }

    public final String getUserType() {
        return this._userType;
    }

    public final void setUserType(String type) {
        this._userType = type;
    }

    public final String getUserClass() {
        return this._userClass;
    }

    public final void setUserClass(String class1) {
        this._userClass = class1;
    }

    @Override
    public boolean blindlyEquals(PFSPrincipal o, boolean forward) {
        OMIServerPrincipal osp = (OMIServerPrincipal)o;
        if (!this.stringEquals(this.get_userFQID(), osp.get_userFQID())) {
            return false;
        }
        return super.blindlyEquals(o, forward);
    }

    @Override
    protected java.lang.Object getEquivalenceClass() {
        return OMIServerPrincipal.class;
    }

    public String getUserName() {
        return this._userName;
    }

    public void setUserName(String name) {
        this._userName = name;
    }
}

