/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.security.login;

import com.sas.services.connection.Credential;
import com.sas.services.connection.SecurityPackageCredential;
import com.sas.services.connection.TrustedPeerCredential;
import com.sas.services.security.login.OptionsCallback;
import com.sas.services.security.login.SasLoginModule;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;

public class OMILoginModule
extends SasLoginModule {
    public static final String PROPERTYNAME_ID_PROPAGATION = "idpropagation";
    public static final String PROPERTYNAME_SSPI_SECURITY_PACKAGE_LIST = "sspisecuritypackagelist";
    public static final String PROPERTYNAME_SSPI_SPN = "sspispn";
    public static final String PROPERTYVALUE_ID_PROPAGATION_SSPI = "sspi";
    public static final String PROPERTYVALUE_ID_PROPAGATION_TRUSTED_PEER = "trustedpeer";
    public static final String PROPERTYVALUE_ID_PROPAGATION_NONE = "none";
    private String _idPropagation;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        String idp = (String)options.get(PROPERTYNAME_ID_PROPAGATION);
        this._idPropagation = OMILoginModule.normalizeIDPropagation(idp);
    }

    public static boolean isIDPropagation(Map options) {
        String idp = (String)options.get(PROPERTYNAME_ID_PROPAGATION);
        String normIDP = null;
        try {
            normIDP = OMILoginModule.normalizeIDPropagation(idp);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        boolean result = normIDP != null;
        return result;
    }

    @Override
    protected boolean setupAuthParams() throws LoginException {
        boolean result;
        boolean bl = result = this._idPropagation == null ? false : this.invokeLoginCallback();
        if (result) {
            SecurityPackageCredential cred = null;
            if (this._idPropagation.equals(PROPERTYVALUE_ID_PROPAGATION_SSPI)) {
                cred = SecurityPackageCredential.getInstance();
                this.isSSPI = true;
            } else {
                cred = TrustedPeerCredential.getInstance();
            }
            this.setCredential((Credential)cred);
        } else {
            result = super.setupAuthParams();
            if (result && (this._password == null || this._password.trim().length() == 0)) {
                if (this._debug) {
                    this.doDebugOutput(this.getRBString("SASLoginModule.nullpass.msg.txt"));
                }
                throw new LoginException(this.getRBString("SASLoginModule.nullpass.msg.txt"));
            }
        }
        return result;
    }

    private boolean invokeLoginCallback() {
        OptionsCallback optionsCallback = new OptionsCallback(PROPERTYNAME_ID_PROPAGATION);
        Callback[] callbackArr = new Callback[]{optionsCallback};
        try {
            this._callbackHandler.handle(callbackArr);
            String val = (String)optionsCallback.getValue();
            String idPropagation = OMILoginModule.normalizeIDPropagation(val);
            if (idPropagation == null || !idPropagation.equals(this._idPropagation)) {
                return false;
            }
            this._domain = this._defaultDomain;
        }
        catch (IOException ioex) {
            return false;
        }
        catch (UnsupportedCallbackException ucex) {
            return false;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
        return true;
    }
}

