/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.services.user;

import com.sas.framework.commons.SASFrameworkException;
import com.sas.framework.commons.util.LocaleUtil;
import com.sas.framework.config.ConfigurationServiceInterface;
import com.sas.framework.services.user.UserDetails;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.Email;
import com.sas.metadata.remote.IdentityGroup;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Person;
import com.sas.metadata.remote.Phone;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.services.ServiceException;
import com.sas.services.information.DAVRepositoryInterface;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PersonInterface;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

@Deprecated
public class UserDetailsFactory {
    public static final String FOUNDATION_GROUP = "Foundation";
    public static final String USE_NAME_ATTRIBUTE = "Name";
    public static final String USE_DESC_ATTRIBUTE = "Desc";
    private UserContextInterface publishUser;
    private InformationServiceInterface infoService;
    private ConfigurationServiceInterface config;

    public void setUser(UserContextInterface u) {
        this.publishUser = u;
    }

    public void setInformationService(InformationServiceInterface isi) {
        this.infoService = isi;
    }

    public void setConfigurationService(ConfigurationServiceInterface csi) {
        this.config = csi;
    }

    public UserDetails getDetails(String userid) throws SASFrameworkException {
        UserDetails thisUser = new UserDetails(userid);
        Person person = this.findPerson(userid);
        thisUser.setName(this.getDisplayNameForPerson(person));
        try {
            thisUser.setTitle(person.getTitle());
        }
        catch (RemoteException re) {
            throw new SASFrameworkException((Throwable)re);
        }
        String domain = this.getDAVDomain(thisUser.getName());
        thisUser.setDavDomain(domain);
        thisUser.setDavUserid(this.getDAVLoginID(person, domain));
        thisUser.setEmailAddresses(this.getEmailAddressesForPerson(person));
        thisUser.setPhoneNumbers(this.getPhoneNumbersForPerson(person));
        HashMap preferences = this.getPreferencesForPerson(person);
        Properties settings = this.config.getSettings("SAS Application Infrastructure");
        if (!preferences.containsKey("Notifications.EmailType") && null != settings.getProperty("Notifications.EmailType")) {
            preferences.put("Notifications.EmailType", settings.getProperty("Notifications.EmailType"));
        }
        if (!preferences.containsKey("Notifications.AlertsType") && null != settings.getProperty("Notifications.AlertsType")) {
            preferences.put("Notifications.AlertsType", settings.getProperty("Notifications.AlertsType"));
        }
        thisUser.setLocale(this.getPreferredLocaleForPreferences(preferences));
        thisUser.setPreferences(preferences);
        return thisUser;
    }

    public UserDetails getDisplayNameAndEmail(String userid) throws SASFrameworkException {
        UserDetails thisUser = new UserDetails(userid);
        Person person = this.findPerson(userid);
        thisUser.setName(this.getDisplayNameForPerson(person));
        thisUser.setEmailAddresses(this.getEmailAddressesForPerson(person));
        return thisUser;
    }

    public String getDisplayName(String userid) throws SASFrameworkException {
        return this.getDisplayNameForPerson(this.findPerson(userid));
    }

    public List getEmailAddresses(String userid) throws SASFrameworkException {
        return this.getEmailAddressesForPerson(this.findPerson(userid));
    }

    private Person findPerson(String userid) throws SASFrameworkException {
        Person person = null;
        try {
            Filter filter = new Filter(USE_NAME_ATTRIBUTE, 0, userid);
            filter.setType("Person");
            List list = this.infoService.search(this.publishUser, (FilterInterface)filter);
            if (null == list || list.isEmpty()) {
                throw new SASFrameworkException("Cannot find user with id '" + userid + "'.");
            }
            Iterator iter = list.iterator();
            PersonInterface mi = (PersonInterface)iter.next();
            person = (Person)mi.getRepositoryEntity();
            if (null == person) {
                throw new SASFrameworkException("The userid '" + userid + "' is not found in the metadata.");
            }
        }
        catch (RemoteException re) {
            throw new SASFrameworkException((Throwable)re);
        }
        catch (ServiceException se) {
            throw new SASFrameworkException((Throwable)se);
        }
        return person;
    }

    private HashMap getPreferencesForPerson(Person person) throws SASFrameworkException {
        HashMap preferences = new HashMap();
        try {
            AssociationList propertySets = person.getPropertySets(true);
            preferences = this.findPreferences((List)propertySets, preferences);
        }
        catch (MdException mde) {
            throw new SASFrameworkException((Throwable)mde);
        }
        catch (RemoteException re) {
            throw new SASFrameworkException((Throwable)re);
        }
        return preferences;
    }

    private HashMap findPreferences(List propertySets, HashMap preferences) throws RemoteException, MdException {
        Iterator iter = propertySets.iterator();
        PropertySet propset = null;
        while (iter.hasNext()) {
            propset = (PropertySet)iter.next();
            AssociationList sets = propset.getSetProperties(true);
            for (Property property : sets) {
                String name = property.getName();
                String value = property.getDefaultValue();
                if (preferences.containsKey(name)) continue;
                preferences.put(name, value);
            }
            AssociationList nextPropertySets = propset.getPropertySets(true);
            if (null == nextPropertySets) continue;
            this.findPreferences((List)nextPropertySets, preferences);
        }
        return preferences;
    }

    public Locale getPreferredLocale(String userid) throws SASFrameworkException {
        UserDetails thisPerson = this.getDetails(userid);
        return thisPerson.getLocale();
    }

    private String getDisplayNameForPerson(Person person) throws SASFrameworkException {
        String displayName = null;
        Properties settings = this.config.getSettings("SAS Application Infrastructure");
        String displayNameAttribute = settings.getProperty("User.DisplayNameAttribute");
        try {
            displayName = null == displayNameAttribute || USE_DESC_ATTRIBUTE.equals(displayNameAttribute) ? person.getDesc() : person.getName();
        }
        catch (RemoteException re) {
            throw new SASFrameworkException((Throwable)re);
        }
        return displayName;
    }

    private List getEmailAddressesForPerson(Person person) throws SASFrameworkException {
        ArrayList<String> addressList = null;
        try {
            AssociationList emails = person.getEmailAddresses(true);
            if (null != emails && !emails.isEmpty()) {
                addressList = new ArrayList<String>();
                for (Email email : emails) {
                    addressList.add(email.getAddress());
                }
            }
        }
        catch (MdException mde) {
            throw new SASFrameworkException((Throwable)mde);
        }
        catch (RemoteException re) {
            throw new SASFrameworkException((Throwable)re);
        }
        return addressList;
    }

    private List getPhoneNumbersForPerson(Person person) throws SASFrameworkException {
        ArrayList<String> phoneList = null;
        try {
            AssociationList phones = person.getPhoneNumbers(true);
            if (null != phones && !phones.isEmpty()) {
                phoneList = new ArrayList<String>();
                for (Phone phone : phones) {
                    phoneList.add(phone.getNumber());
                }
            }
        }
        catch (MdException mde) {
            throw new SASFrameworkException((Throwable)mde);
        }
        catch (RemoteException re) {
            throw new SASFrameworkException((Throwable)re);
        }
        return phoneList;
    }

    private Locale getPreferredLocaleForPreferences(HashMap preferences) {
        String localeStr = null;
        Locale locale = null;
        if (preferences.containsKey("locale") && !preferences.containsKey("Locale.DefaultLocale")) {
            localeStr = (String)preferences.get("locale");
        } else if (preferences.containsKey("Locale.DefaultLocale")) {
            localeStr = (String)preferences.get("Locale.DefaultLocale");
        }
        if (null != localeStr) {
            locale = LocaleUtil.getLocaleFromString((String)localeStr);
        }
        if (null == locale) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    private String getDAVDomain(String name) throws SASFrameworkException {
        String domain = null;
        try {
            List reposList = this.publishUser.getRepositories();
            for (RepositoryInterface ri : reposList) {
                if (!(ri instanceof DAVRepositoryInterface)) continue;
                domain = ri.getDomain();
                break;
            }
        }
        catch (RemoteException re) {
            throw new SASFrameworkException((Throwable)re);
        }
        if (null == domain) {
            throw new SASFrameworkException("Unable to find the correct DAV domain for user '" + name + "'.");
        }
        return domain;
    }

    private String getDAVLoginID(Person person, String domain) throws SASFrameworkException {
        if (null == person) {
            throw new SASFrameworkException("Cannot locate DAV domain for null user.");
        }
        String davLogin = null;
        try {
            AssociationList logins = person.getLogins();
            for (Login login : logins) {
                AuthenticationDomain userDomain = login.getDomain();
                if (null == userDomain || !domain.equals(userDomain.getName())) continue;
                davLogin = login.getUserID();
                break;
            }
        }
        catch (MdException mde) {
            throw new SASFrameworkException((Throwable)mde);
        }
        catch (RemoteException re) {
            throw new SASFrameworkException((Throwable)re);
        }
        return davLogin;
    }

    public String getEmailAddressesAsString(String userid) throws SASFrameworkException {
        UserDetails thisPerson = this.getDisplayNameAndEmail(userid);
        return this.getEmailAddressesAsString(thisPerson);
    }

    public String getEmailAddressesAsString(UserDetails person) {
        if (null == person) {
            return null;
        }
        int count = 1;
        List emailAddresses = person.getEmailAddresses();
        if (null == emailAddresses) {
            return null;
        }
        int numCharsPerEmail = 32;
        int stringLength = 32 * emailAddresses.size();
        StringBuilder maillist = new StringBuilder(stringLength);
        for (String address : emailAddresses) {
            if (1 != count) {
                maillist.append(",");
            }
            maillist.append(address);
            ++count;
        }
        return maillist.toString();
    }

    public List getGroupMembers(String groupName) throws SASFrameworkException {
        ArrayList<String> members = null;
        try {
            Filter filter = new Filter(USE_NAME_ATTRIBUTE, 0, groupName);
            filter.setType("IdentityGroup");
            ArrayList<String> protocols = new ArrayList<String>();
            protocols.add("omi");
            List list = this.infoService.searchProtocols(this.publishUser, protocols, (FilterInterface)filter);
            if (null == list || list.size() < 1) {
                return members;
            }
            Iterator iter = list.iterator();
            MetadataInterface mi = (MetadataInterface)iter.next();
            IdentityGroup group = (IdentityGroup)mi.getRepositoryEntity();
            AssociationList memberIdentities = group.getMemberIdentities(true);
            if (memberIdentities == null || memberIdentities.size() < 1) {
                return members;
            }
            iter = memberIdentities.iterator();
            members = new ArrayList<String>();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!(o instanceof Person)) continue;
                Person person = (Person)o;
                members.add(person.getName());
            }
        }
        catch (MdException mde) {
            throw new SASFrameworkException((Throwable)mde);
        }
        catch (RemoteException re) {
            throw new SASFrameworkException((Throwable)re);
        }
        catch (ServiceException se) {
            throw new SASFrameworkException((Throwable)se);
        }
        return members;
    }
}

