/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.services.themes.dao.builder;

import com.sas.framework.annotation.WriteOperation;
import com.sas.framework.config.ApplicationRegistration;
import com.sas.framework.themes.dao.builder.AbstractXmlThemeDAO;
import com.sas.framework.themes.dao.builder.ThemeDAOInterface;
import com.sas.services.information.Filter;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.user.UserContextInterface;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.InputSource;

public class MetadataThemeDAO
extends AbstractXmlThemeDAO
implements ThemeDAOInterface {
    private static final Logger LOGGER = LogManager.getLogger(MetadataThemeDAO.class);
    private InformationServiceInterface info;
    private UserContextInterface user;
    private final List protocols = new ArrayList();
    private static final String TEMPLATE = "<Templates><SoftwareComponent Name=\"\"><Notes/></SoftwareComponent><TextStore StoredText=\"\"/></Templates>";

    public MetadataThemeDAO() {
        this.protocols.add("omi");
    }

    public void setProtocols(List protocolList) {
        for (Object protocol : protocolList) {
            if (this.protocols.contains(protocol)) continue;
            this.protocols.add(protocol);
        }
    }

    public void setInformationService(InformationServiceInterface service) {
        this.info = service;
    }

    public void setUser(UserContextInterface service) {
        this.user = service;
    }

    @WriteOperation
    public void reload() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WriteOperation
    public void init() {
        for (ApplicationRegistration reg : this.getThemeRegistrations()) {
            String name = reg.getName();
            Filter filter = new Filter("Name", 0, name);
            filter.setOMRTemplate(TEMPLATE);
            filter.setOMRFlags(0x200 | filter.getOMRFlags());
            filter.setType("SoftwareComponent");
            try {
                List list = this.info.browseSearchProtocols(this.user, this.protocols, filter);
                if (list.isEmpty()) {
                    LOGGER.warn("Unable to find theme, " + name + ". Processing for it is being skipped.");
                    continue;
                }
                if (list.size() > 1) {
                    LOGGER.warn("Found more than one definition for theme, " + name + ". Only the first is being processed.");
                }
                BrowseMetadataInterface bmi = (BrowseMetadataInterface)list.get(0);
                List notes = (List)bmi.get("Notes");
                for (BrowseMetadataInterface note : notes) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Processing definition, " + note.getName() + ", for theme, " + name + ".");
                    }
                    String text = (String)note.get("StoredText");
                    ByteArrayInputStream bais = null;
                    try {
                        bais = new ByteArrayInputStream(text.getBytes());
                        InputSource in = new InputSource(bais);
                        this.addTheme(in, reg.getExternalUrl(), reg.getUrl());
                    }
                    finally {
                        if (null == bais) continue;
                        bais.close();
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to initialize theme: " + name + ".", e);
            }
        }
    }
}

