/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.services.remoting;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class ReachabilityChecker {
    private static final Logger logger = LogManager.getLogger(ReachabilityChecker.class);
    private static final RestTemplate REST_TEMPLATE;

    public static boolean isReachable(String url) {
        try {
            REST_TEMPLATE.headForHeaders(url, new Object[0]);
            return true;
        }
        catch (ResourceAccessException e) {
            logger.debug("Encountered ResourceAccessException trying " + url, (Throwable)e);
        }
        catch (RemoteAccessException e) {
            logger.debug("Encountered RemoteAccessException trying " + url, (Throwable)e);
        }
        catch (RestClientException e) {
            logger.debug("Encountered RestClientException trying " + url, (Throwable)e);
            return true;
        }
        catch (Throwable t) {
            logger.debug("Encountered exception trying " + url, t);
        }
        return false;
    }

    static {
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setConnectTimeout(Integer.getInteger("sun.net.client.defaultConnectTimeout", 5000).intValue());
        requestFactory.setReadTimeout(Integer.getInteger("sun.net.client.defaultReadTimeout", 5000).intValue());
        REST_TEMPLATE = new RestTemplate((ClientHttpRequestFactory)requestFactory);
    }
}

