/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.services.metadata;

import com.sas.framework.services.metadata.BaseAssociationFilter;
import com.sas.framework.services.metadata.BrowseMetadataUtil;
import com.sas.services.information.Filter;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.user.UserContextInterface;
import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class TextStorePropertiesFactoryBean
implements FactoryBean<Properties> {
    private static final Logger LOGGER = LogManager.getLogger(TextStorePropertiesFactoryBean.class);
    private InformationServiceInterface infoService;
    private UserContextInterface user;
    private String search = "@Name='Locale Properties TextStore'";
    private final List<String> protocols = Arrays.asList("omi");

    @Autowired
    public void setInfoService(InformationServiceInterface service) {
        this.infoService = service;
    }

    @Autowired
    public void setUser(@Qualifier(value="metadataUser") UserContextInterface user) {
        this.user = user;
    }

    public void setSearch(String search) {
        this.search = search;
    }

    public Properties getObject() throws Exception {
        Properties p = new Properties();
        BaseAssociationFilter f = new BaseAssociationFilter();
        f.setXMLSelect("<XMLSelect search=\"TextStore[" + this.search + "]\" />");
        f.setOMRTemplate("<Templates><TextStore StoredText=\"\" /></Templates>");
        f.setType("TextStore");
        f.setOMRFlags(512);
        List results = this.infoService.browseSearchProtocols(this.user, this.protocols, (Filter)f);
        if (results != null && results.size() > 0) {
            BrowseMetadataInterface bmi;
            String text;
            if (results.size() > 1) {
                LOGGER.warn("Found more than one TextStore result, using the first");
            }
            if (null != (text = BrowseMetadataUtil.getAttribute(bmi = (BrowseMetadataInterface)results.get(0), "StoredText")) && text.length() > 0) {
                p.load(new ByteArrayInputStream(text.getBytes("UTF-8")));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Loaded locale properties from metadata: " + p);
                }
            }
        }
        return p;
    }

    public Class<?> getObjectType() {
        return Properties.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

