/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.services.metadata;

import com.sas.framework.services.config.dao.AppProperty;
import com.sas.framework.services.config.dao.PropertySetDatabaseAdminDAO;
import com.sas.framework.services.metadata.BaseAssociationFilter;
import com.sas.framework.services.metadata.BrowseMetadataUtil;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.metadata.PropertyInterface;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class PropertySetFactoryBean
implements FactoryBean<Properties>,
ApplicationContextAware {
    private static final Logger LOGGER = LogManager.getLogger(PropertySetFactoryBean.class);
    private static final String UNCHECKED = "unchecked";
    private static final String PROPERTY_SET_NAME = "Environment.Properties";
    private static final String PROPERTY_NAME_KEY = "property_nm";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String TAB = "\t";
    private PropertySetDatabaseAdminDAO propertySetDatabaseAdminDAO;
    private UserContextInterface user;
    private InformationServiceInterface informationService;
    private ApplicationContext applicationContext;
    private String propertySetName = "Environment.Properties";
    private String changeFlagName = "properties.change.flag";
    private boolean updateEnabled = true;
    private String xmlSelect = "<XMLSelect search=\"PropertySet[@PropertySetName='" + this.propertySetName + "']\" />";
    private final String changeFlagXmlSelect = "<XMLSelect search=\"Property[@PropertyName='" + this.changeFlagName + "'][AssociatedPropertySet/PropertySet[@PropertySetName='" + this.propertySetName + "']]\" />";
    private static final String OMR_TEMPLATE = "<Templates><PropertySet><SetProperties /></PropertySet><Property Name=\"\" PropertyName=\"\" DefaultValue=\"\" /></Templates>";
    private static final List<String> PROTOCOLS = Arrays.asList("omi");

    public void setPropertySetName(String propertySetName) {
        this.propertySetName = propertySetName;
    }

    public void setChangeFlagName(String changeFlagName) {
        this.changeFlagName = changeFlagName;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setUser(UserContextInterface user) {
        this.user = user;
    }

    public void setInformationService(InformationServiceInterface informationService) {
        this.informationService = informationService;
    }

    public void setXmlSelect(String xmlSelect) {
        this.xmlSelect = xmlSelect;
    }

    public void setPropertySetDatabaseAdminDAO(PropertySetDatabaseAdminDAO propertySetDatabaseAdminDAO) {
        this.propertySetDatabaseAdminDAO = propertySetDatabaseAdminDAO;
    }

    public void setUpdateEnabled(boolean updateEnabled) {
        this.updateEnabled = updateEnabled;
    }

    public Properties getObject() throws Exception {
        return this.getProperties();
    }

    public Class<Properties> getObjectType() {
        return Properties.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void run() {
        if (this.isChanged() && this.updateEnabled) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Change detected for PropertySet " + this.propertySetName);
            }
            this.updateDatabase(this.getProperties());
            this.resetChangeFlag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getProperties() {
        Properties props = new Properties();
        BaseAssociationFilter filter = new BaseAssociationFilter();
        filter.setType("PropertySet");
        filter.setXMLSelect(this.xmlSelect);
        filter.setOMRTemplate(OMR_TEMPLATE);
        Throwable exception = null;
        try {
            List objects = this.informationService.browseSearchProtocols(this.user, PROTOCOLS, (Filter)filter);
            for (BrowseMetadataInterface set : objects) {
                List properties = BrowseMetadataUtil.getAssociation(set, "SetProperties");
                for (BrowseMetadataInterface property : properties) {
                    String name = BrowseMetadataUtil.getAttribute(property, "PropertyName");
                    if (null == name) {
                        name = property.getName();
                    }
                    String value = BrowseMetadataUtil.getAttribute(property, "DefaultValue");
                    if (null == name || null == value) continue;
                    props.setProperty(name, value);
                }
            }
        }
        catch (RemoteException e) {
            exception = e;
        }
        catch (ServiceException e) {
            exception = e;
        }
        finally {
            if (null != exception) {
                LOGGER.error("Received exception when reading the PropertySet object; propertySetName=" + this.propertySetName, exception);
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isChanged() {
        BaseAssociationFilter filter = new BaseAssociationFilter();
        filter.setType("Property");
        filter.setXMLSelect(this.changeFlagXmlSelect);
        filter.setOMRTemplate(OMR_TEMPLATE);
        Throwable exception = null;
        try {
            List objects = this.informationService.browseSearchProtocols(this.user, PROTOCOLS, (Filter)filter);
            if (!objects.isEmpty()) {
                BrowseMetadataInterface property = (BrowseMetadataInterface)objects.get(0);
                String propValue = BrowseMetadataUtil.getAttribute(property, "DefaultValue");
                boolean bl = Boolean.parseBoolean(propValue);
                return bl;
            }
        }
        catch (RemoteException e) {
            exception = e;
        }
        catch (ServiceException e) {
            exception = e;
        }
        finally {
            if (null != exception) {
                LOGGER.error("Received exception when retrieving property value; propertySetName=" + this.propertySetName + ", changeFlagName=" + this.changeFlagName, exception);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetChangeFlag() {
        BaseAssociationFilter filter = new BaseAssociationFilter();
        filter.setType("Property");
        filter.setXMLSelect(this.changeFlagXmlSelect);
        filter.setOMRTemplate(OMR_TEMPLATE);
        Throwable exception = null;
        try {
            List props = this.informationService.searchProtocols(this.user, PROTOCOLS, (FilterInterface)filter);
            if (props.isEmpty()) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Property not found; propertySetName=" + this.propertySetName + ", changeFlagName=" + this.changeFlagName);
                }
            } else {
                PropertyInterface prop = (PropertyInterface)props.get(0);
                prop.setValue(String.valueOf(false));
                prop.update();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Change flag has been reset.");
                }
            }
        }
        catch (RemoteException e) {
            exception = e;
        }
        catch (ServiceException e) {
            exception = e;
        }
        finally {
            if (null != exception) {
                LOGGER.error("Received exception when resetting change flag; propertySetName=" + this.propertySetName + ", changeFlagName=" + this.changeFlagName, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDatabase(Properties metaDataProperties) {
        boolean isDebugEnabled = LOGGER.isDebugEnabled();
        Exception exception = null;
        ArrayList<AppProperty> addPropertyList = new ArrayList<AppProperty>(20);
        ArrayList<AppProperty> updatePropertyList = new ArrayList<AppProperty>(5);
        StringBuilder addKeys = new StringBuilder(LINE_SEPARATOR);
        StringBuilder updateKeys = new StringBuilder(LINE_SEPARATOR);
        if (isDebugEnabled) {
            LOGGER.debug("Processing Metadata Environment.Properties...");
        }
        ArrayList<String> databaseKeys = new ArrayList<String>(20);
        try {
            List<Map<String, Object>> databasePropertyList = this.propertySetDatabaseAdminDAO.selectProperties(PROPERTY_SET_NAME);
            StringBuilder keys = new StringBuilder(LINE_SEPARATOR);
            for (Map<String, Object> appPropertyMap : databasePropertyList) {
                String key = (String)appPropertyMap.get(PROPERTY_NAME_KEY);
                databaseKeys.add(key);
                keys.append(TAB).append(key).append(LINE_SEPARATOR);
            }
            if (isDebugEnabled) {
                LOGGER.debug("found database keys: ");
                LOGGER.debug((CharSequence)keys);
            }
            Set<Object> metadataKeys = metaDataProperties.keySet();
            for (Object keyObject : metadataKeys) {
                String key = (String)keyObject;
                String val = metaDataProperties.getProperty(key);
                AppProperty appProperty = new AppProperty(PROPERTY_SET_NAME, key, val);
                if (databaseKeys.contains(key)) {
                    updatePropertyList.add(appProperty);
                    updateKeys.append(TAB).append(appProperty.getName()).append(LINE_SEPARATOR);
                    continue;
                }
                addPropertyList.add(appProperty);
                addKeys.append(TAB).append(appProperty.getName()).append(LINE_SEPARATOR);
            }
            if (0 < updatePropertyList.size()) {
                this.propertySetDatabaseAdminDAO.updateProperties(updatePropertyList);
                if (isDebugEnabled) {
                    LOGGER.debug("Update existing value for keys: ");
                    LOGGER.debug((CharSequence)updateKeys);
                }
            }
            if (0 < addPropertyList.size()) {
                this.propertySetDatabaseAdminDAO.addProperties(addPropertyList);
                if (isDebugEnabled) {
                    LOGGER.debug("Add new value for keys: ");
                    LOGGER.debug((CharSequence)addKeys);
                }
            }
        }
        catch (Exception e) {
            exception = e;
        }
        finally {
            if (null != exception) {
                LOGGER.error("Received exception when attempting update of the SAS_APPLICATION_PROPERTY table in the database", (Throwable)exception);
            }
        }
    }
}

