/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.services.metadata;

import com.sas.framework.services.metadata.CsvExtractionHandler;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.metadata.PropertyInterface;
import com.sas.services.information.metadata.PropertySetInterface;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AbstractCsvMetadataExtractor {
    private static final Logger LOGGER = LogManager.getLogger(AbstractCsvMetadataExtractor.class);
    UserContextInterface user;
    InformationServiceInterface infoService;
    List<String> protocols = Arrays.asList("omi");

    @Autowired
    public void setUser(@Qualifier(value="publishUser") UserContextInterface user) {
        this.user = user;
    }

    @Autowired
    public void setInfoService(@Qualifier(value="local") InformationServiceInterface service) {
        this.infoService = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(String tableName, CsvExtractionHandler mapper) {
        Throwable exception = null;
        try {
            Filter f = new Filter("Name", 0, tableName + " Records");
            f.setType("PropertySet");
            List results = this.infoService.searchProtocols(this.user, this.protocols, (FilterInterface)f);
            if (results.size() > 0) {
                PropertySetInterface propertySet = (PropertySetInterface)results.get(0);
                propertySet.refresh();
                List properties = propertySet.getSetProperties();
                for (PropertyInterface property : properties) {
                    mapper.handle(property.getValue());
                    property.delete();
                }
                propertySet.update();
            }
        }
        catch (RemoteException e) {
            exception = e;
        }
        catch (ServiceException e) {
            exception = e;
        }
        finally {
            if (null != exception) {
                LOGGER.error("Unable to load data from metadata to database, please do this manually...", exception);
            }
        }
    }
}

