/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.services.config.dao;

import com.sas.framework.services.config.dao.BatchUpdatePreparedStatementSetter;
import com.sas.framework.services.config.dao.ServiceAlias;
import com.sas.framework.services.config.dao.ServiceAliasBatchDeletePreparedStatementSetter;
import com.sas.framework.services.config.dao.ServiceAliasBatchInsertPreparedStatementSetter;
import com.sas.framework.services.config.dao.ServiceAliasRowMapper;
import com.sas.framework.services.config.dao.ServiceURL;
import com.sas.framework.services.config.dao.ServiceURLBatchDeletePreparedStatementSetter;
import com.sas.framework.services.config.dao.ServiceURLBatchInsertPreparedStatementSetter;
import com.sas.framework.services.config.dao.ServiceURLRowMapper;
import com.sas.svcs.data.vendor.DatabaseVendor;
import com.sas.svcs.data.vendor.DatabaseVendorUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class ServiceURLDAO {
    private static final String PREPAREDSTATEMENT_ADD_ALIAS = "insert into SAS_SERVICE_ALIAS (SERVICE_TXT, ALIAS_TYPE_TXT, OBJECT_TYPE_TXT, UPDATED_DTTM, CONTEXT_TXT) values (?, ?, ?, ?, ?)";
    private static final String PREPAREDSTATEMENT_DELETE_ALIAS = "delete from SAS_SERVICE_ALIAS where SERVICE_TXT = ? and ALIAS_TYPE_TXT = ? and OBJECT_TYPE_TXT = ? and CONTEXT_TXT = ?";
    private static final String PREPAREDSTATEMENT_DELETE_ALIAS_BY_ID = "delete from SAS_SERVICE_ALIAS where ALIAS_ID = ?";
    private static final String PREPAREDSTATEMENT_DELETE_ALIASES_BY_CONTEXT = "delete from SAS_SERVICE_ALIAS where CONTEXT_TXT = ?";
    private static final String PREPAREDSTATEMENT_GET_ALIAS = "select * from SAS_SERVICE_ALIAS where SERVICE_TXT= ? and OBJECT_TYPE_TXT = ? and CONTEXT_TXT = ?";
    private static final String PREPAREDSTATEMENT_GET_ALIASES_BY_SERVICE_CONTEXT = "select * from SAS_SERVICE_ALIAS where SERVICE_TXT= ? and CONTEXT_TXT = ?";
    private static final String PREPAREDSTATEMENT_GET_ALIAS_BY_ID = "select * from SAS_SERVICE_ALIAS where ALIAS_ID = ?";
    private static final String PREPAREDSTATEMENT_UPDATE_ALIAS = "update SAS_SERVICE_ALIAS set SERVICE_TXT = ?, ALIAS_TYPE_TXT = ?, OBJECT_TYPE_TXT = ?, UPDATED_DTTM = ?, CONTEXT_TXT = ? where ALIAS_ID = ?";
    private static final String STATEMENT_DELETE_ALL_ALIASES = "delete from SAS_SERVICE_ALIAS";
    private static final String STATEMENT_GET_ALIASES = "select * from SAS_SERVICE_ALIAS";
    private static final String PREPAREDSTATEMENT_GET_URL = "select * from SAS_SERVICE_URL where SERVICE_TXT= ? and SERVLETCONTEXT_TXT=? and SERVLET_TXT = ?";
    private static final String PREPAREDSTATEMENT_GET_URL_FOR_OBJECT_TYPE = "select * from SAS_SERVICE_URL where SERVLETCONTEXT_TXT= ? and SERVLET_TXT = ? and SERVICE_TXT = ? and CONTEXT_TXT = ? and OBJECT_TYPE_TXT = ?";
    private static final String PREPAREDSTATEMENT_GET_URLS_FOR_SERVICE = "select * from SAS_SERVICE_URL where SERVICE_TXT= ? order by SERVICE_TXT, SERVLETCONTEXT_TXT, SERVLET_TXT";
    private static final String PREPAREDSTATEMENT_GET_URLS_FOR_CONTEXT = "select * from SAS_SERVICE_URL where SERVICE_TXT= ? and SERVLETCONTEXT_TXT=? order by SERVICE_TXT, SERVLETCONTEXT_TXT, SERVLET_TXT";
    private static final String PREPAREDSTATEMENT_GET_URLS_FOR_CONTEXT_SERVICE = "select * from SAS_SERVICE_URL where CONTEXT_TXT= ? and SERVICE_TXT= ? order by SERVICE_TXT, SERVLETCONTEXT_TXT, SERVLET_TXT";
    private static final String PREPAREDSTATEMENT_GET_URLS_FOR_CONTEXT_OBJECTTYPE = "select * from SAS_SERVICE_URL where CONTEXT_TXT= ? and OBJECT_TYPE_TXT = ? order by SERVLETCONTEXT_TXT, SERVLET_TXT";
    private static final String PREPAREDSTATEMENT_GET_URLS_FOR_CONTEXT_OBJECTTYPE_SERVICE = "select * from SAS_SERVICE_URL where CONTEXT_TXT= ? and OBJECT_TYPE_TXT = ? and SERVICE_TXT = ? order by SERVLETCONTEXT_TXT, SERVLET_TXT";
    private static final String PREPAREDSTATEMENT_ADD = "insert into SAS_SERVICE_URL (SERVICE_TXT, SERVLETCONTEXT_TXT, SERVLET_TXT, UPDATED_DTTM, CONTEXT_TXT, OBJECT_TYPE_TXT) values (?, ?, ?, ?, ?, ?)";
    private static final String PREPAREDSTATEMENT_DELETE_CONTEXT_SERVICES = "delete from SAS_SERVICE_URL where CONTEXT_TXT = ?";
    private static final String PREPAREDSTATEMENT_DELETE_CONTEXT_OBJECTTYPE = "delete from SAS_SERVICE_URL where CONTEXT_TXT = ? and OBJECT_TYPE_TXT = ?";
    private static final String PREPAREDSTATEMENT_DELETE_SERVICE = "delete from SAS_SERVICE_URL where SERVICE_TXT = ?";
    private static final String PREPAREDSTATEMENT_DELETE_SERVICE_URL = "delete from SAS_SERVICE_URL where SERVICE_TXT = ? and SERVLETCONTEXT_TXT = ? and SERVLET_TXT = ?";
    private static final String PREPAREDSTATEMENT_DELETE_SERVICE_URL_BY_ID = "delete from SAS_SERVICE_URL where SERVICEURL_ID = ?";
    private static final String PREPAREDSTATEMENT_DELETE_SERVICE_SERVLETCONTEXT = "delete from SAS_SERVICE_URL where SERVLETCONTEXT_TXT like ?";
    private static final String PREPAREDSTATEMENT_DELETE_OBJECT_TYPE_URL = "delete from SAS_SERVICE_URL where OBJECT_TYPE_TXT = ? and SERVLETCONTEXT_TXT = ? and SERVLET_TXT = ?";
    private static final String PREPAREDSTATEMENT_DELETE_OBJECT_TYPE_URL_BY_ID = "delete from SAS_SERVICE_URL where SERVICEURL_ID = ?";
    private static final String PREPAREDSTATEMENT_UPDATE = "update SAS_SERVICE_URL set OBJECT_TYPE_TXT = ?, SERVICE_TXT = ?, SERVLETCONTEXT_TXT = ?, SERVLET_TXT = ?, UPDATED_DTTM = ? where SERVICEURL_ID = ?";
    private static final String STATEMENT_GET_ALL = "select * from SAS_SERVICE_URL";
    private static final String STATEMENT_DELETE_ALL = "delete from SAS_SERVICE_URL";
    private static final int DEFAULT_BATCH_SIZE = 100;
    private static final String ATTRIBUTE_SERVICE = "[service=";
    private static final String ATTRIBUTE_SERVICE2 = "][service=";
    private int _batchSize = 100;
    private DatabaseVendor _dbVendor;
    private final JdbcTemplate _jdbcTemplate;

    public ServiceURLDAO() {
        this(new JdbcTemplate());
    }

    public ServiceURLDAO(JdbcTemplate jdbcTemplate) {
        if (null == jdbcTemplate) {
            throw new IllegalArgumentException("A JdbcTemplate must be specified.");
        }
        this._jdbcTemplate = jdbcTemplate;
    }

    public ServiceURLDAO(DataSource dataSource) {
        this();
        this.setDataSource(dataSource);
    }

    public final void setDataSource(DataSource dataSource) {
        this._jdbcTemplate.setDataSource(dataSource);
    }

    public void setDatabaseVendor(DatabaseVendor dbVendor) {
        this._dbVendor = dbVendor;
    }

    public DatabaseVendor getDatabaseVendor() {
        return this._dbVendor;
    }

    public final JdbcTemplate getJdbcTemplate() {
        DataSource dataSource;
        if (null == this._dbVendor && null != this._jdbcTemplate && null != (dataSource = this._jdbcTemplate.getDataSource())) {
            try {
                this._dbVendor = DatabaseVendorUtils.getVendor((DataSource)dataSource);
            }
            catch (SQLException e) {
                LogManager.getLogger(ServiceURLDAO.class).error("Unable to determine the database vendor.");
            }
        }
        return this._jdbcTemplate;
    }

    public ServiceURL getServiceURLForObjectType(ServiceURL request) {
        ServiceURL serviceURL;
        block3: {
            serviceURL = null;
            if (null != request) {
                try {
                    serviceURL = (ServiceURL)this.getJdbcTemplate().queryForObject(PREPAREDSTATEMENT_GET_URL_FOR_OBJECT_TYPE, new Object[]{request.getServletContext(), request.getServlet(), request.getService(), request.getContext(), request.getObjectType()}, (RowMapper)new ServiceURLRowMapper());
                }
                catch (EmptyResultDataAccessException e) {
                    Logger logger = LogManager.getLogger(ServiceURLDAO.class);
                    if (!logger.isDebugEnabled()) break block3;
                    int stringLength = 256;
                    StringBuilder sb = new StringBuilder(256).append("A service URL is not available for ").append(ATTRIBUTE_SERVICE).append(request.getService()).append("][servletContext=").append(request.getServletContext()).append("][servlet=").append(request.getServlet()).append("][context=").append(request.getContext()).append("][objectType=").append(request.getObjectType()).append(']');
                    logger.debug(sb.toString());
                }
            }
        }
        return serviceURL;
    }

    public ServiceURL getServiceURL(ServiceURL request) {
        ServiceURL serviceURL;
        block3: {
            serviceURL = null;
            if (null != request) {
                try {
                    serviceURL = (ServiceURL)this.getJdbcTemplate().queryForObject(PREPAREDSTATEMENT_GET_URL, new Object[]{request.getService(), request.getServletContext(), request.getServlet()}, (RowMapper)new ServiceURLRowMapper());
                }
                catch (EmptyResultDataAccessException e) {
                    Logger logger = LogManager.getLogger(ServiceURLDAO.class);
                    if (!logger.isDebugEnabled()) break block3;
                    int stringLength = 256;
                    StringBuilder sb = new StringBuilder(256).append("A service URL is not available for [context=").append(request.getContext()).append(ATTRIBUTE_SERVICE2).append(request.getService()).append("][servlet=").append(request.getServlet()).append(']');
                    logger.debug(sb.toString());
                }
            }
        }
        return serviceURL;
    }

    public List<ServiceURL> getServiceURLsForContextService(ServiceURL request) {
        List list;
        block6: {
            list = null;
            if (null != request) {
                if (null != request.getObjectType()) {
                    list = this.getServiceURLsForContextServiceObjectType(request);
                } else {
                    try {
                        list = this.getJdbcTemplate().query(PREPAREDSTATEMENT_GET_URLS_FOR_CONTEXT_SERVICE, new Object[]{request.getContext(), request.getService()}, (RowMapper)new ServiceURLRowMapper());
                    }
                    catch (EmptyResultDataAccessException e) {
                        Logger logger = LogManager.getLogger(ServiceURLDAO.class);
                        if (!logger.isDebugEnabled()) break block6;
                        int stringLength = 256;
                        StringBuilder sb = new StringBuilder(256).append("No service URLs are available for [context=").append(request.getContext()).append(ATTRIBUTE_SERVICE2).append(request.getService()).append(']');
                        logger.debug(sb.toString());
                    }
                }
            }
        }
        if (null == list) {
            list = new ArrayList<ServiceURL>(0);
        }
        return list;
    }

    public List<ServiceURL> getServiceURLsForContextServiceObjectType(ServiceURL request) {
        List list;
        block4: {
            list = null;
            if (null != request) {
                try {
                    list = this.getJdbcTemplate().query(PREPAREDSTATEMENT_GET_URLS_FOR_CONTEXT_OBJECTTYPE_SERVICE, new Object[]{request.getContext(), request.getObjectType(), request.getService()}, (RowMapper)new ServiceURLRowMapper());
                }
                catch (EmptyResultDataAccessException e) {
                    Logger logger = LogManager.getLogger(ServiceURLDAO.class);
                    if (!logger.isDebugEnabled()) break block4;
                    int stringLength = 256;
                    StringBuilder sb = new StringBuilder(256).append("No service URLs are available for [context=").append(request.getContext()).append("][objecttype=").append(request.getObjectType()).append(ATTRIBUTE_SERVICE2).append(request.getService()).append(']');
                    logger.debug(sb.toString());
                }
            }
        }
        if (null == list) {
            list = new ArrayList(0);
        }
        return list;
    }

    public List<ServiceURL> getServiceURLsForContextObjectType(ServiceURL request) {
        List list;
        block4: {
            list = null;
            if (null != request) {
                try {
                    list = this.getJdbcTemplate().query(PREPAREDSTATEMENT_GET_URLS_FOR_CONTEXT_OBJECTTYPE, new Object[]{request.getContext(), request.getObjectType()}, (RowMapper)new ServiceURLRowMapper());
                }
                catch (EmptyResultDataAccessException e) {
                    Logger logger = LogManager.getLogger(ServiceURLDAO.class);
                    if (!logger.isDebugEnabled()) break block4;
                    int stringLength = 256;
                    StringBuilder sb = new StringBuilder(256).append("No service URLs are available for [context=").append(request.getContext()).append("][objecttype=").append(request.getObjectType()).append(']');
                    logger.debug(sb.toString());
                }
            }
        }
        if (null == list) {
            list = new ArrayList(0);
        }
        return list;
    }

    public List<ServiceURL> getAllServiceURLs() {
        ArrayList list;
        block3: {
            list = null;
            try {
                list = this.getJdbcTemplate().query(STATEMENT_GET_ALL, (RowMapper)new ServiceURLRowMapper());
            }
            catch (EmptyResultDataAccessException e) {
                Logger logger = LogManager.getLogger(ServiceURLDAO.class);
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("No service URLs are available.");
            }
        }
        if (null == list) {
            list = new ArrayList(0);
        }
        return list;
    }

    public List<ServiceURL> getServiceURLsForService(ServiceURL request) {
        List list;
        block4: {
            list = null;
            if (null != request) {
                try {
                    list = this.getJdbcTemplate().query(PREPAREDSTATEMENT_GET_URLS_FOR_SERVICE, new Object[]{request.getService()}, (RowMapper)new ServiceURLRowMapper());
                }
                catch (EmptyResultDataAccessException e) {
                    Logger logger = LogManager.getLogger(ServiceURLDAO.class);
                    if (!logger.isDebugEnabled()) break block4;
                    int stringLength = 256;
                    StringBuilder sb = new StringBuilder(256).append("No service URLs are available for ").append(ATTRIBUTE_SERVICE).append(request.getService()).append(']');
                    logger.debug(sb.toString());
                }
            }
        }
        if (null == list) {
            list = new ArrayList(0);
        }
        return list;
    }

    public List<ServiceURL> getServiceURLsForServletContext(ServiceURL request) {
        List list;
        block4: {
            list = null;
            if (null != request) {
                try {
                    list = this.getJdbcTemplate().query(PREPAREDSTATEMENT_GET_URLS_FOR_CONTEXT, new Object[]{request.getService(), request.getServletContext()}, (RowMapper)new ServiceURLRowMapper());
                }
                catch (EmptyResultDataAccessException e) {
                    Logger logger = LogManager.getLogger(ServiceURLDAO.class);
                    if (!logger.isDebugEnabled()) break block4;
                    int stringLength = 256;
                    StringBuilder sb = new StringBuilder(256).append("No service URLs are available for ").append("[servletcontext=").append(request.getServletContext()).append(ATTRIBUTE_SERVICE2).append(request.getService()).append(']');
                    logger.debug(sb.toString());
                }
            }
        }
        if (null == list) {
            list = new ArrayList(0);
        }
        return list;
    }

    public int getBatchSize() {
        return this._batchSize;
    }

    public void setBatchSize(int batchSize) {
        this._batchSize = Math.max(1, batchSize);
    }

    public boolean deleteAllServiceURLs() {
        int numRows = 0;
        try {
            numRows = this.getJdbcTemplate().update(STATEMENT_DELETE_ALL);
        }
        catch (DataAccessException e) {
            numRows = 0;
        }
        return 0 < numRows;
    }

    public boolean deleteContextObjectTypeURLs(String context, String objectType) {
        int numRows = this.getJdbcTemplate().update(PREPAREDSTATEMENT_DELETE_CONTEXT_OBJECTTYPE, new Object[]{context, objectType});
        return 0 < numRows;
    }

    public boolean deleteContextServiceURLs(String context) {
        int numRows = this.getJdbcTemplate().update(PREPAREDSTATEMENT_DELETE_CONTEXT_SERVICES, new Object[]{context});
        return 0 < numRows;
    }

    public boolean deleteService(String service) {
        int numRows = 0;
        if (null != service) {
            numRows = this.getJdbcTemplate().update(PREPAREDSTATEMENT_DELETE_SERVICE, new Object[]{service});
        }
        return 0 < numRows;
    }

    public boolean delete(ServiceURL serviceURL) {
        int numRows = 0;
        if (null != serviceURL) {
            long id = serviceURL.getID();
            numRows = 0L != id ? this.getJdbcTemplate().update("delete from SAS_SERVICE_URL where SERVICEURL_ID = ?", new Object[]{id}) : this.getJdbcTemplate().update(PREPAREDSTATEMENT_DELETE_SERVICE_URL, new Object[]{serviceURL.getService(), serviceURL.getServletContext(), serviceURL.getServlet()});
        }
        return 0 < numRows;
    }

    public boolean[] deleteServiceURLs(List<ServiceURL> items) {
        int[] rowCounts = this.batchUpdate("delete from SAS_SERVICE_URL where SERVICEURL_ID = ?", items, new ServiceURLBatchDeletePreparedStatementSetter());
        int numItems = rowCounts.length;
        boolean[] wasDeleted = new boolean[numItems];
        for (int i = 0; i < numItems; ++i) {
            wasDeleted[i] = 0 < rowCounts[i];
        }
        return wasDeleted;
    }

    public int deleteServletContext(String servletContext) {
        if (null != servletContext) {
            return this.getJdbcTemplate().update(PREPAREDSTATEMENT_DELETE_SERVICE_SERVLETCONTEXT, new Object[]{"%" + servletContext + "%"});
        }
        return 0;
    }

    public boolean deleteObjectTypeURL(ServiceURL serviceURL) {
        int numRows = 0;
        if (null != serviceURL) {
            long id = serviceURL.getID();
            numRows = 0L != id ? this.getJdbcTemplate().update("delete from SAS_SERVICE_URL where SERVICEURL_ID = ?", new Object[]{id}) : this.getJdbcTemplate().update(PREPAREDSTATEMENT_DELETE_OBJECT_TYPE_URL, new Object[]{serviceURL.getObjectType(), serviceURL.getServletContext(), serviceURL.getServlet()});
        }
        return 0 < numRows;
    }

    public boolean[] deleteObjectTypeURLs(List<ServiceURL> items) {
        int[] rowCounts = this.batchUpdate("delete from SAS_SERVICE_URL where SERVICEURL_ID = ?", items, new ServiceURLBatchDeletePreparedStatementSetter());
        int numItems = rowCounts.length;
        boolean[] wasDeleted = new boolean[numItems];
        for (int i = 0; i < numItems; ++i) {
            wasDeleted[i] = 0 < rowCounts[i];
        }
        return wasDeleted;
    }

    public boolean addServiceURL(ServiceURL item) {
        int numUpdatedRows = 0;
        if (null != item) {
            numUpdatedRows = this.getJdbcTemplate().update(PREPAREDSTATEMENT_ADD, new Object[]{item.getService(), item.getServletContext(), item.getServlet(), new Date(), item.getContext(), item.getObjectType()});
        }
        return 0 < numUpdatedRows;
    }

    public int[] addServiceURLs(List<ServiceURL> items) {
        return this.batchUpdate(PREPAREDSTATEMENT_ADD, items, new ServiceURLBatchInsertPreparedStatementSetter());
    }

    public boolean updateServiceURL(ServiceURL item) {
        int numRows = 0;
        if (null != item) {
            numRows = this.getJdbcTemplate().update(PREPAREDSTATEMENT_UPDATE, new Object[]{item.getObjectType(), item.getService(), item.getServletContext(), item.getServlet(), new Date(), item.getID()});
        }
        return 0 < numRows;
    }

    public int[] updateServiceURLs(List<ServiceURL> items) {
        return this.batchUpdate(PREPAREDSTATEMENT_UPDATE, items, new ServiceURLBatchInsertPreparedStatementSetter());
    }

    public boolean addAlias(ServiceAlias item) {
        int numUpdatedRows = 0;
        if (null != item) {
            numUpdatedRows = this.getJdbcTemplate().update(PREPAREDSTATEMENT_ADD_ALIAS, new Object[]{item.getServiceInterface(), item.getAliasType(), item.getObjectType(), new Date(), item.getContext()});
        }
        return 0 < numUpdatedRows;
    }

    public int[] addAliases(List<ServiceAlias> items) {
        return this.batchUpdateServiceAlias(PREPAREDSTATEMENT_ADD_ALIAS, items, new ServiceAliasBatchInsertPreparedStatementSetter());
    }

    public boolean deleteAlias(ServiceAlias serviceAlias) {
        boolean wasDeleted = false;
        if (null != serviceAlias) {
            int numRows;
            Long id = serviceAlias.getID();
            wasDeleted = null == id ? 0 < (numRows = this.getJdbcTemplate().update(PREPAREDSTATEMENT_DELETE_ALIAS, new Object[]{serviceAlias.getServiceInterface(), serviceAlias.getAliasType(), serviceAlias.getObjectType(), serviceAlias.getContext()})) : this.deleteAliasByID(id);
        }
        return wasDeleted;
    }

    public boolean deleteAliasByID(Long id) {
        int numRows = null == id ? 0 : this.getJdbcTemplate().update(PREPAREDSTATEMENT_DELETE_ALIAS_BY_ID, new Object[]{id});
        return 0 < numRows;
    }

    public boolean deleteAliasByContext(String context) {
        boolean wasDeleted = false;
        if (null != context) {
            int numRows = this.getJdbcTemplate().update(PREPAREDSTATEMENT_DELETE_ALIASES_BY_CONTEXT, new Object[]{context});
            wasDeleted = 0 < numRows;
        }
        return wasDeleted;
    }

    public boolean deleteAllAliases() {
        int numRows = 0;
        try {
            numRows = this.getJdbcTemplate().update(STATEMENT_DELETE_ALL_ALIASES);
        }
        catch (DataAccessException e) {
            numRows = 0;
        }
        return 0 < numRows;
    }

    public boolean[] deleteAliases(List<ServiceAlias> items) {
        int[] rowCounts = this.batchUpdateServiceAlias(PREPAREDSTATEMENT_DELETE_ALIAS_BY_ID, items, new ServiceAliasBatchDeletePreparedStatementSetter());
        int numItems = rowCounts.length;
        boolean[] wasDeleted = new boolean[numItems];
        for (int i = 0; i < numItems; ++i) {
            wasDeleted[i] = 0 < rowCounts[i];
        }
        return wasDeleted;
    }

    public ServiceAlias getAliasByID(Long id) {
        ServiceAlias value = null;
        if (null != id) {
            try {
                value = (ServiceAlias)this.getJdbcTemplate().queryForObject(PREPAREDSTATEMENT_GET_ALIAS_BY_ID, new Object[]{id}, (RowMapper)new ServiceAliasRowMapper());
            }
            catch (EmptyResultDataAccessException e) {
                value = null;
            }
        }
        return value;
    }

    public ServiceAlias getAlias(ServiceAlias serviceAlias) {
        ServiceAlias value = null;
        if (null != serviceAlias) {
            try {
                Long id = serviceAlias.getID();
                value = null == id ? (ServiceAlias)this.getJdbcTemplate().queryForObject(PREPAREDSTATEMENT_GET_ALIAS, new Object[]{serviceAlias.getServiceInterface(), serviceAlias.getObjectType(), serviceAlias.getContext()}, (RowMapper)new ServiceAliasRowMapper()) : this.getAliasByID(id);
            }
            catch (EmptyResultDataAccessException e) {
                value = null;
            }
        }
        return value;
    }

    public List<ServiceAlias> getAliases() {
        ArrayList<ServiceAlias> list = null;
        try {
            list = this.getJdbcTemplate().query(STATEMENT_GET_ALIASES, (RowMapper)new ServiceAliasRowMapper());
        }
        catch (EmptyResultDataAccessException e) {
            list = new ArrayList(0);
        }
        return list;
    }

    public List<ServiceAlias> getAliasesByServiceContext(ServiceAlias serviceAlias) {
        List<ServiceAlias> list = null;
        try {
            list = this.getJdbcTemplate().query(PREPAREDSTATEMENT_GET_ALIASES_BY_SERVICE_CONTEXT, new Object[]{serviceAlias.getServiceInterface(), serviceAlias.getContext()}, (RowMapper)new ServiceAliasRowMapper());
        }
        catch (EmptyResultDataAccessException e) {
            list = new ArrayList<ServiceAlias>(0);
        }
        return list;
    }

    public boolean updateAlias(ServiceAlias item) {
        int numRows = 0;
        if (null != item) {
            numRows = this.getJdbcTemplate().update(PREPAREDSTATEMENT_UPDATE_ALIAS, new Object[]{item.getServiceInterface(), item.getAliasType(), item.getObjectType(), new Date(), item.getContext(), item.getID()});
        }
        return 0 < numRows;
    }

    public int[] updateAliases(List<ServiceAlias> items) {
        return this.batchUpdateServiceAlias(PREPAREDSTATEMENT_UPDATE_ALIAS, items, new ServiceAliasBatchInsertPreparedStatementSetter());
    }

    private int[] batchUpdateServiceAlias(String preparedStatement, List<ServiceAlias> items, BatchUpdatePreparedStatementSetter<ServiceAlias> batchPreparedStatementSetter) {
        int size = null == items ? 0 : items.size();
        int[] updatedRowCounts = new int[size];
        if (0 < size) {
            int idx;
            int batchSize = this.getBatchSizeForRequest(size);
            int rowIndex = 0;
            int numBatches = size / batchSize * batchSize;
            for (idx = 0; idx < numBatches; idx += batchSize) {
                batchPreparedStatementSetter.set(items.subList(idx, idx + batchSize));
                for (int updatedRowCounts[rowIndex++] : this.getJdbcTemplate().batchUpdate(preparedStatement, batchPreparedStatementSetter)) {
                }
            }
            int rest = size - numBatches;
            if (0 < rest) {
                batchPreparedStatementSetter.set(items.subList(idx, idx + rest));
                for (int updatedRowCounts[rowIndex++] : this.getJdbcTemplate().batchUpdate(preparedStatement, batchPreparedStatementSetter)) {
                }
            }
        }
        return updatedRowCounts;
    }

    private int[] batchUpdate(String preparedStatement, List<ServiceURL> items, BatchUpdatePreparedStatementSetter<ServiceURL> batchPreparedStatementSetter) {
        int size = null == items ? 0 : items.size();
        int[] updatedRowCounts = new int[size];
        if (0 < size) {
            int idx;
            int batchSize = this.getBatchSizeForRequest(size);
            int rowIndex = 0;
            int numBatches = size / batchSize * batchSize;
            for (idx = 0; idx < numBatches; idx += batchSize) {
                batchPreparedStatementSetter.set(items.subList(idx, idx + batchSize));
                for (int updatedRowCounts[rowIndex++] : this.getJdbcTemplate().batchUpdate(preparedStatement, batchPreparedStatementSetter)) {
                }
            }
            int rest = size - numBatches;
            if (0 < rest) {
                batchPreparedStatementSetter.set(items.subList(idx, idx + rest));
                for (int updatedRowCounts[rowIndex++] : this.getJdbcTemplate().batchUpdate(preparedStatement, batchPreparedStatementSetter)) {
                }
            }
        }
        return updatedRowCounts;
    }

    private int getBatchSizeForRequest(int size) {
        DatabaseVendor databaseVendor = this.getDatabaseVendor();
        return null == databaseVendor ? 1 : (databaseVendor.hasBulkInsert() ? Math.min(size, this._batchSize) : 1);
    }
}

