/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.services.config.dao;

import java.util.Date;

public final class ServiceURL {
    private static final String URL_TOKEN = "/";
    private long _id;
    private String _service;
    private String _servletContext;
    private String _servlet;
    private String _context;
    private String _objectType;
    private Date _updatedDTTM;

    public ServiceURL() {
    }

    public ServiceURL(String service, String servletContext, String servlet) {
        this.setService(service);
        this.setServletContext(servletContext);
        this.setServlet(servlet);
    }

    public ServiceURL(String service, String servletContext, String servlet, Date updatedDTTM, String context) {
        this.setService(service);
        this.setServletContext(servletContext);
        this.setServlet(servlet);
        this.setUpdatedDTTM(updatedDTTM);
        this.setContext(context);
    }

    public ServiceURL(long id, String service, String servletContext, String servlet, Date updatedDTTM, String context) {
        this.setID(id);
        this.setService(service);
        this.setServletContext(servletContext);
        this.setServlet(servlet);
        this.setUpdatedDTTM(updatedDTTM);
        this.setContext(context);
    }

    public ServiceURL(long id, String service, String servletContext, String servlet, Date updatedDTTM, String context, String objectType) {
        this.setID(id);
        this.setService(service);
        this.setServletContext(servletContext);
        this.setServlet(servlet);
        this.setUpdatedDTTM(updatedDTTM);
        this.setContext(context);
        this.setObjectType(objectType);
    }

    public long getID() {
        return this._id;
    }

    public void setID(long id) {
        this._id = id;
    }

    public String getContext() {
        return this._context;
    }

    public void setContext(String context) {
        this._context = context;
    }

    public String getObjectType() {
        return this._objectType;
    }

    public void setObjectType(String objectType) {
        this._objectType = objectType;
    }

    public String getService() {
        return this._service;
    }

    public void setService(String service) {
        this._service = service;
    }

    public String getServletContext() {
        return this._servletContext;
    }

    public void setServletContext(String servletContext) {
        this._servletContext = servletContext;
    }

    public String getServlet() {
        return this._servlet;
    }

    public void setServlet(String servlet) {
        this._servlet = servlet;
    }

    public Date getUpdatedDTTM() {
        return this._updatedDTTM;
    }

    public void setUpdatedDTTM(Date updatedDTTM) {
        this._updatedDTTM = updatedDTTM;
    }

    public String getURL() {
        int size = null == this._servletContext ? 0 : this._servletContext.length();
        StringBuilder sb = new StringBuilder(size);
        if (null != this._servletContext) {
            sb.append(this._servletContext);
            if (!this._servletContext.endsWith(URL_TOKEN) && !this._servlet.startsWith(URL_TOKEN)) {
                sb.append(URL_TOKEN);
            }
            sb.append(this._servlet);
        }
        return sb.toString();
    }

    public String getContextServiceObjectType() {
        int sizeContext = null == this._context ? 0 : this._context.length();
        int sizeService = null == this._service ? 0 : this._service.length();
        int sizeObjectType = null == this._objectType ? 0 : this._objectType.length() + 1;
        int stringLength = sizeContext + sizeService + sizeObjectType;
        StringBuilder sb = new StringBuilder(stringLength).append(this._context).append(this._service);
        if (null != this._objectType && !this._service.startsWith("com.sas.svcs.content.streaming.spi.StreamSupportService-")) {
            sb.append('-').append(this._objectType);
        }
        return sb.toString();
    }

    public String toString() {
        int stringLength = 256;
        StringBuilder builder = new StringBuilder(256).append(super.toString()).append("[service=").append(this._service).append("][servletContext=").append(this._servletContext).append("][servlet=").append(this._servlet).append("][updated=").append(this._updatedDTTM).append("][context=").append(this._context).append("][objectType=").append(this._objectType).append("][ID=").append(this._id).append(']');
        return builder.toString();
    }
}

