/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.services.config.dao;

import com.sas.framework.services.config.dao.AppProperty;
import com.sas.framework.services.config.dao.PropertySetAdminInterface;
import com.sas.framework.services.metadata.BaseAssociationFilter;
import com.sas.framework.services.metadata.BrowseMetadataUtil;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.metadata.PropertyInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.util.Strings;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PropertySetMetadataDAO
implements PropertySetAdminInterface {
    private static final Logger LOGGER = LogManager.getLogger(PropertySetMetadataDAO.class);
    private static final String UNCHECKED = "unchecked";
    private static final List<String> PROTOCOLS = Arrays.asList("omi");
    private static final String OMR_TEMPLATE = "<Templates><PropertySet><SetProperties /></PropertySet><Property Name=\"\" PropertyName=\"\" DefaultValue=\"\" /></Templates>";
    private UserContextInterface _user;
    private InformationServiceInterface _informationService;

    public void setUser(UserContextInterface user) {
        this._user = user;
    }

    public void setInformationService(InformationServiceInterface informationService) {
        this._informationService = informationService;
    }

    @Override
    public Boolean getBooleanPropertyValue(String propertySetName, String propertyName) {
        String value = this.getPropertyValue(propertySetName, propertyName);
        return null == value ? null : Boolean.valueOf(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPropertyValue(String propertySetName, String propertyName) {
        String value = null;
        Throwable exception = null;
        try {
            List objects = this._informationService.browseSearchProtocols(this._user, PROTOCOLS, PropertySetMetadataDAO.newSearchFilter(propertySetName, propertyName));
            if (!objects.isEmpty()) {
                BrowseMetadataInterface property = (BrowseMetadataInterface)objects.get(0);
                value = BrowseMetadataUtil.getAttribute(property, "DefaultValue");
            }
        }
        catch (RemoteException e) {
            exception = e;
        }
        catch (ServiceException e) {
            exception = e;
        }
        finally {
            if (null != exception) {
                LOGGER.error("Received exception when retrieving property value; propertySetName=" + propertySetName + ", " + propertyName + '=' + propertyName, exception);
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateProperty(AppProperty appProperty) {
        boolean wasUpdated = false;
        Throwable exception = null;
        String propertySetName = appProperty.getPropertySetName();
        String propertyName = appProperty.getName();
        String propertyValue = appProperty.getValue();
        try {
            List props = this._informationService.searchProtocols(this._user, PROTOCOLS, (FilterInterface)PropertySetMetadataDAO.newSearchFilter(propertySetName, propertyName));
            if (props.isEmpty()) {
                LOGGER.info("Property '" + propertyName + "' was not found in property set '" + propertySetName);
            } else {
                PropertyInterface prop = (PropertyInterface)props.get(0);
                if (Strings.equal((String)propertyValue, (String)prop.getAttribute("DefaultValue"), (boolean)false, (boolean)false)) {
                    prop.setValue(propertyValue);
                    prop.update();
                }
                wasUpdated = true;
            }
        }
        catch (RemoteException e) {
            exception = e;
        }
        catch (ServiceException e) {
            exception = e;
        }
        finally {
            if (null != exception) {
                LOGGER.error("Unable to update property '" + propertyName + "' in property set '" + propertySetName + "'.", exception);
            }
        }
        return wasUpdated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getPropertyMap(String propertySetName) {
        String applicationName = null;
        String applicationClassID = null;
        Map<String, String> propertyMap = null;
        Throwable exception = null;
        try {
            List objects = this._informationService.browseSearchProtocols(this._user, PROTOCOLS, PropertySetMetadataDAO.newPropertySetSearchFilter(propertySetName, applicationName, applicationClassID));
            Iterator iterator = objects.iterator();
            if (iterator.hasNext()) {
                BrowseMetadataInterface set = (BrowseMetadataInterface)iterator.next();
                List properties = BrowseMetadataUtil.getAssociation(set, "SetProperties");
                propertyMap = new HashMap<String, String>(properties.size());
                for (BrowseMetadataInterface property : properties) {
                    String name = BrowseMetadataUtil.getAttribute(property, "PropertyName");
                    if (null == name) {
                        name = property.getName();
                    }
                    String value = BrowseMetadataUtil.getAttribute(property, "DefaultValue");
                    if (null == name || null == value) continue;
                    propertyMap.put(name, value);
                }
            }
        }
        catch (ServiceException e) {
            exception = e;
        }
        catch (RemoteException e) {
            exception = e;
        }
        finally {
            if (null != exception) {
                LOGGER.error("Received exception when reading the property set '" + propertySetName + "'.", exception);
            }
        }
        if (null == propertyMap) {
            propertyMap = Collections.emptyMap();
        }
        return propertyMap;
    }

    private static String getXMLSelect(String aPropertySetName, String applicationName, String applicationClassID) {
        StringBuilder buffer = new StringBuilder(250);
        buffer.append("<XMLSelect search=\"PropertySet[@PropertySetName='" + aPropertySetName + "']");
        PropertySetMetadataDAO.getXMLSelectOwningObject(buffer, applicationName, applicationClassID);
        buffer.append("\" />");
        return buffer.toString();
    }

    private static String getPropertyXMLSelect(String propertySetName, String propertyName) {
        StringBuilder buffer = new StringBuilder(250);
        buffer.append("<XMLSelect search=\"Property[@PropertyName='" + propertyName + "'][AssociatedPropertySet/PropertySet[@PropertySetName='" + propertySetName + "']");
        String applicationName = null;
        String applicationClassID = null;
        PropertySetMetadataDAO.getXMLSelectOwningObject(buffer, applicationName, applicationClassID);
        buffer.append("\" />");
        return buffer.toString();
    }

    private static void getXMLSelectOwningObject(StringBuilder buffer, String applicationName, String applicationClassID) {
        boolean hasAppClassID;
        boolean hasAppName = null != applicationName;
        boolean bl = hasAppClassID = null != applicationClassID;
        if (hasAppName || hasAppClassID) {
            buffer.append("[OwningObject/SoftwareComponent[");
            if (hasAppName) {
                buffer.append("@Name='");
                buffer.append(applicationName);
                buffer.append('\'');
            }
            if (hasAppClassID) {
                if (hasAppName) {
                    buffer.append(" AND ");
                }
                buffer.append("@ClassIdentifier='");
                buffer.append(applicationClassID);
                buffer.append('\'');
            }
            buffer.append("]]");
        }
    }

    @Override
    public int[] addProperties(List<AppProperty> appProperties) {
        return new int[0];
    }

    @Override
    public void addProperty(AppProperty appProperty) {
    }

    @Override
    public int[] updateProperties(List<AppProperty> appProperties) {
        int numItems = null == appProperties ? 0 : appProperties.size();
        int[] rowUpdateCounts = new int[numItems];
        for (int i = 0; i < numItems; ++i) {
            if (!this.updateProperty(appProperties.get(i))) continue;
            rowUpdateCounts[i] = 1;
        }
        return rowUpdateCounts;
    }

    private static Filter newSearchFilter(String propertySetName, String propertyName) {
        BaseAssociationFilter filter = new BaseAssociationFilter();
        filter.setType("Property");
        filter.setXMLSelect(PropertySetMetadataDAO.getPropertyXMLSelect(propertySetName, propertyName));
        filter.setOMRTemplate(OMR_TEMPLATE);
        return filter;
    }

    private static Filter newPropertySetSearchFilter(String propertySetName, String applicationName, String applicationClassID) {
        BaseAssociationFilter filter = new BaseAssociationFilter();
        filter.setType("PropertySet");
        filter.setXMLSelect(PropertySetMetadataDAO.getXMLSelect(propertySetName, applicationName, applicationClassID));
        filter.setOMRTemplate(OMR_TEMPLATE);
        return filter;
    }
}

