/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.services.config.dao;

import com.sas.framework.services.config.dao.AppProperty;
import com.sas.framework.services.config.dao.AppPropertyRowMapper;
import com.sas.framework.services.config.dao.PropertySetInterface;
import com.sas.svcs.data.vendor.DatabaseVendor;
import com.sas.svcs.data.vendor.DatabaseVendorUtils;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class PropertySetDatabaseDAO
implements PropertySetInterface {
    private static final String PREPAREDSTATEMENT_GET_PROPERTIES = "select * from SAS_APPLICATION_PROPERTY where PROPERTYSET_NM = ?";
    private static final String PREPAREDSTATEMENT_GET_PROPERTY = "select * from SAS_APPLICATION_PROPERTY where PROPERTYSET_NM= ? and PROPERTY_NM= ?";
    private static final String PREPAREDSTATEMENT_GET_PROPERTY_VALUE = "select PROPERTY_VALUE_TXT from SAS_APPLICATION_PROPERTY where PROPERTYSET_NM= ? and PROPERTY_NM= ?";
    private final JdbcTemplate _jdbcTemplate;
    private DatabaseVendor _dbVendor;

    public PropertySetDatabaseDAO() {
        this._jdbcTemplate = new JdbcTemplate();
    }

    public PropertySetDatabaseDAO(JdbcTemplate jdbcTemplate) {
        if (null == jdbcTemplate) {
            throw new IllegalArgumentException("A JdbcTemplate must be specified.");
        }
        this._jdbcTemplate = jdbcTemplate;
    }

    public PropertySetDatabaseDAO(DataSource dataSource) {
        this();
        this.setDataSource(dataSource);
    }

    public final void setDataSource(DataSource dataSource) {
        this._jdbcTemplate.setDataSource(dataSource);
    }

    public void setDatabaseVendor(DatabaseVendor dbVendor) {
        this._dbVendor = dbVendor;
    }

    public DatabaseVendor getDatabaseVendor() {
        return this._dbVendor;
    }

    public AppProperty getProperty(String propertySetName, String propertyName) {
        AppProperty value = null;
        try {
            value = (AppProperty)this.getJdbcTemplate().queryForObject(PREPAREDSTATEMENT_GET_PROPERTY, new Object[]{propertySetName, propertyName}, (RowMapper)new AppPropertyRowMapper());
        }
        catch (EmptyResultDataAccessException e) {
            value = null;
        }
        return value;
    }

    public List<AppProperty> getProperties(String propertySetName) {
        List list = null;
        try {
            list = this.getJdbcTemplate().query(PREPAREDSTATEMENT_GET_PROPERTIES, new Object[]{propertySetName}, (RowMapper)new AppPropertyRowMapper());
        }
        catch (EmptyResultDataAccessException e) {
            list = Collections.emptyList();
        }
        return list;
    }

    @Override
    public String getPropertyValue(String propertySetName, String propertyName) {
        String value = null;
        try {
            value = (String)this.getJdbcTemplate().queryForObject(PREPAREDSTATEMENT_GET_PROPERTY_VALUE, new Object[]{propertySetName, propertyName}, String.class);
        }
        catch (EmptyResultDataAccessException e) {
            value = null;
        }
        return value;
    }

    @Override
    public Boolean getBooleanPropertyValue(String propertySetName, String propertyName) {
        String value = this.getPropertyValue(propertySetName, propertyName);
        return null == value ? null : Boolean.valueOf(value);
    }

    @Override
    public Map<String, String> getPropertyMap(String propertySetName) {
        List<AppProperty> list = this.getProperties(propertySetName);
        HashMap<String, String> propertyMap = new HashMap<String, String>(list.size());
        for (AppProperty stringProperty : list) {
            String name = stringProperty.getName();
            String value = stringProperty.getValue();
            if (null == name || null == value) continue;
            propertyMap.put(name, value);
        }
        return propertyMap;
    }

    public final JdbcTemplate getJdbcTemplate() {
        DataSource dataSource;
        if (null == this._dbVendor && null != this._jdbcTemplate && null != (dataSource = this._jdbcTemplate.getDataSource())) {
            try {
                this._dbVendor = DatabaseVendorUtils.getVendor((DataSource)dataSource);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this._jdbcTemplate;
    }
}

