/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.services.config.dao;

import com.sas.framework.services.config.dao.AppProperty;
import com.sas.framework.services.config.dao.AppPropertyBatchDeletePreparedStatementSetter;
import com.sas.framework.services.config.dao.AppPropertyBatchInsertPreparedStatementSetter;
import com.sas.framework.services.config.dao.BatchUpdatePreparedStatementSetter;
import com.sas.framework.services.config.dao.PropertySetAdminInterface;
import com.sas.framework.services.config.dao.PropertySetDatabaseDAO;
import com.sas.svcs.data.vendor.DatabaseVendor;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;

public class PropertySetDatabaseAdminDAO
extends PropertySetDatabaseDAO
implements PropertySetAdminInterface {
    private static final String PREPAREDSTATEMENT_ADD_PROPERTY = "insert into SAS_APPLICATION_PROPERTY (PROPERTY_VALUE_TXT, PROPERTYSET_NM, PROPERTY_NM) values (?, ?, ?)";
    private static final String PREPAREDSTATEMENT_DELETE_PROPERTY = "delete from SAS_APPLICATION_PROPERTY where PROPERTYSET_NM = ? and PROPERTY_NM = ?";
    private static final String PREPAREDSTATEMENT_DELETE_PROPERTYSET = "delete from SAS_APPLICATION_PROPERTY where PROPERTYSET_NM = ?";
    private static final String PREPAREDSTATEMENT_UPDATE_PROPERTY = "update SAS_APPLICATION_PROPERTY set PROPERTY_VALUE_TXT = ? where PROPERTYSET_NM = ? and PROPERTY_NM= ?";
    private static final String PREPAREDSTATEMENT_SELECT_PROPERTYSET = "select PROPERTYSET_NM, PROPERTY_NM, PROPERTY_VALUE_TXT from SAS_APPLICATION_PROPERTY where PROPERTYSET_NM = ?";
    private static final int DEFAULT_BATCH_SIZE = 100;
    private int _batchSize = 100;

    public PropertySetDatabaseAdminDAO() {
    }

    public PropertySetDatabaseAdminDAO(JdbcTemplate jdbcTemplate) {
        super(jdbcTemplate);
    }

    public PropertySetDatabaseAdminDAO(DataSource dataSource) {
        this.setDataSource(dataSource);
    }

    public int getBatchSize() {
        return this._batchSize;
    }

    public void setBatchSize(int batchSize) {
        this._batchSize = Math.max(1, batchSize);
    }

    public int deletePropertySet(String propertySetName) {
        return this.getJdbcTemplate().update(PREPAREDSTATEMENT_DELETE_PROPERTYSET, new Object[]{propertySetName});
    }

    public int deleteProperty(AppProperty appProperty) {
        int numRows = 0;
        if (null != appProperty) {
            numRows = this.getJdbcTemplate().update(PREPAREDSTATEMENT_DELETE_PROPERTY, new Object[]{appProperty.getPropertySetName(), appProperty.getName()});
        }
        return numRows;
    }

    public int[] deleteProperties(List<AppProperty> appProperties) {
        int[] updatedRowCounts = this.batchUpdate(PREPAREDSTATEMENT_DELETE_PROPERTY, appProperties, new AppPropertyBatchDeletePreparedStatementSetter());
        return updatedRowCounts;
    }

    @Override
    public void addProperty(AppProperty appProperty) {
        this.getJdbcTemplate().update(PREPAREDSTATEMENT_ADD_PROPERTY, new Object[]{appProperty.getValue(), appProperty.getPropertySetName(), appProperty.getName()});
    }

    @Override
    public int[] addProperties(List<AppProperty> appProperties) {
        return this.batchUpdate(PREPAREDSTATEMENT_ADD_PROPERTY, appProperties, new AppPropertyBatchInsertPreparedStatementSetter());
    }

    @Override
    public boolean updateProperty(AppProperty appProperty) {
        int numRows = this.getJdbcTemplate().update(PREPAREDSTATEMENT_UPDATE_PROPERTY, new Object[]{appProperty.getValue(), appProperty.getPropertySetName(), appProperty.getName()});
        return 0 < numRows;
    }

    @Override
    public int[] updateProperties(List<AppProperty> appProperties) {
        int[] updatedRowCounts = this.batchUpdate(PREPAREDSTATEMENT_UPDATE_PROPERTY, appProperties, new AppPropertyBatchInsertPreparedStatementSetter());
        return updatedRowCounts;
    }

    private int[] batchUpdate(String preparedStatement, List<AppProperty> entries, BatchUpdatePreparedStatementSetter<AppProperty> batchPreparedStatementSetter) {
        int size = entries.size();
        int[] updatedRowCounts = new int[size];
        int batchSize = this.getBatchSizeForRequest(size);
        int rowIndex = 0;
        if (0 < batchSize) {
            int idx;
            int numBatches = size / batchSize * batchSize;
            for (idx = 0; idx < numBatches; idx += batchSize) {
                batchPreparedStatementSetter.set(entries.subList(idx, idx + batchSize));
                for (int updatedRowCounts[rowIndex++] : this.getJdbcTemplate().batchUpdate(preparedStatement, batchPreparedStatementSetter)) {
                }
            }
            int rest = size - numBatches;
            if (0 < rest) {
                batchPreparedStatementSetter.set(entries.subList(idx, idx + rest));
                for (int updatedRowCounts[rowIndex++] : this.getJdbcTemplate().batchUpdate(preparedStatement, batchPreparedStatementSetter)) {
                }
            }
        }
        return updatedRowCounts;
    }

    public List<Map<String, Object>> selectProperties(String propertySetName) {
        return this.getJdbcTemplate().queryForList(PREPAREDSTATEMENT_SELECT_PROPERTYSET, new Object[]{propertySetName});
    }

    private int getBatchSizeForRequest(int size) {
        DatabaseVendor databaseVendor = this.getDatabaseVendor();
        return null == databaseVendor ? 1 : (databaseVendor.hasBulkInsert() ? Math.min(size, this._batchSize) : 1);
    }
}

