/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.services.config.dao;

import com.sas.framework.annotation.ReadOperation;
import com.sas.framework.annotation.WriteOperation;
import com.sas.framework.config.Application;
import com.sas.framework.config.ApplicationConfiguration;
import com.sas.framework.config.ApplicationRegistration;
import com.sas.framework.config.dao.ApplicationDAOInterface;
import com.sas.framework.services.metadata.BaseAssociationFilter;
import com.sas.framework.services.metadata.BrowseMetadataUtil;
import com.sas.services.information.Filter;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.user.UserContextInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Deprecated
public class MetadataApplicationDAO
implements ApplicationDAOInterface {
    private static final Logger LOGGER = LogManager.getLogger(MetadataApplicationDAO.class);
    private static final String LOCALHOST = "localhost";
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String SAS_MIDTIER_MACHINE = "sas.midtier.machine";
    private static final String SAS_MIDTIER_PORT = "sas.midtier.port";
    private static final String SAS_DEVELOPER_MACHINE = "sas.developer.machine";
    private static final String CONFIGURATION_PROPERTY_SET = "Application Configuration";
    private static final String PARENT = "PARENT";
    private static final String HISTORY_IDENTIFIER = "HistoryIdentifier";
    private static final String IS_DEFAULT_INSTANCE = "IsDefaultInstance";
    private static final String ASSOCIATED_APPLICATIONS = "AssociatedApplication";
    private InformationServiceInterface info;
    private UserContextInterface user;
    private final List protocols = new ArrayList();
    private static Map map = new HashMap();
    private static final String CONFIGURATION_TEMPLATE = "<Templates><SoftwareComponent Name=\"\" Desc=\"\" ProductIdentifier=\"\" ProductName=\"\" SoftwareVersion=\"\" SpecVendor=\"\" SpecVersion=\"\" Vendor=\"\" VendorIdentifier=\"\"><ImplementedObjects /><PropertySets search=\"@PropertySetName='Application Configuration'\"/><Properties /></SoftwareComponent><Property Name=\"\" Desc=\"\" PropertyName=\"\" DefaultValue=\"\"/><PropertySet><SetProperties/></PropertySet></Templates>";
    private static final String CONFIGURATION_SEARCH = "<XMLSelect search=\"SoftwareComponent[PropertySets/PropertySet[@PropertySetName='Application Configuration']]\" />";
    private static final String REGISTRATION_TEMPLATE = "<Templates><SoftwareComponent Name=\"\"><DeployedComponents search=\"@Name='Registered SAS Solution' or @Name='SAS Presentation Theme' or @Name='Registered SAS Application'\"/><SourceConnections search=\"@Name='Connection URI'\"/></SoftwareComponent><TCPIPConnection Name=\"\" CommunicationProtocol=\"\" HostName=\"\" Port=\"\" Service=\"\"/></Templates>";
    private static final String REGISTRATION_SEARCH = "<XMLSelect search=\"SoftwareComponent[DeployedComponents/DeployedComponent[@Name='Registered SAS Solution' or @Name='SAS Presentation Theme' or @Name='Registered SAS Application']]\" />";
    private static final String CONFIGURATION_REGISTRATION_TEMPLATE = "<Templates><SoftwareComponent Name=\"\" Desc=\"\" ProductIdentifier=\"\" ProductName=\"\" SoftwareVersion=\"\" SpecVendor=\"\" SpecVersion=\"\" Vendor=\"\" VendorIdentifier=\"\"><DeployedComponents search=\"@Name='Registered SAS Solution' or @Name='SAS Presentation Theme' or @Name='Registered SAS Application'\"/><ImplementedObjects /><PropertySets search=\"@PropertySetName='Application Configuration'\"/><Properties /><SourceConnections search=\"@Name='Connection URI'\"/></SoftwareComponent><Property Name=\"\" Desc=\"\" PropertyName=\"\" DefaultValue=\"\"/><PropertySet><SetProperties/></PropertySet><TCPIPConnection Name=\"\" CommunicationProtocol=\"\" HostName=\"\" Port=\"\" Service=\"\"/><DeployedComponent><SourceConnections search=\"@Name='Connection URI'\"/></DeployedComponent></Templates>";

    public MetadataApplicationDAO() {
        this.protocols.add("omi");
    }

    public void setInformationService(InformationServiceInterface info) {
        this.info = info;
    }

    public void setUser(UserContextInterface user) {
        this.user = user;
    }

    public void setProtocols(List p) {
        for (Object next : p) {
            if (this.protocols.contains(next)) continue;
            this.protocols.add(next);
        }
    }

    @WriteOperation
    public void reload() {
        this.init();
    }

    @WriteOperation
    public void init() {
        map.clear();
        this.loadConfigurations();
        this.loadRegistrations();
    }

    @ReadOperation
    public List getAll() {
        if (map.isEmpty()) {
            this.init();
        }
        ArrayList list = new ArrayList();
        Iterator it = map.values().iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReadOperation
    public Application getApplication(String name) {
        if (map.isEmpty()) {
            this.init();
        }
        MetadataApplicationDAO metadataApplicationDAO = this;
        synchronized (metadataApplicationDAO) {
            Application app = (Application)map.get(name);
            if (null != app) {
                return app;
            }
            Filter f = new Filter("Name", 0, name);
            f.setOMRTemplate(CONFIGURATION_REGISTRATION_TEMPLATE);
            f.setOMRFlags(512);
            f.setType("SoftwareComponent");
            try {
                List l = this.info.browseSearchProtocols(this.user, this.protocols, f);
                if (l.isEmpty()) {
                    return null;
                }
                if (l.size() > 1) {
                    LOGGER.warn("Found more than one SoftwareComponent for the name: " + name + ". The first one will be processed and used.");
                }
                BrowseMetadataInterface bmi = (BrowseMetadataInterface)l.get(0);
                String scName = bmi.getName();
                app = new Application();
                app.setName(scName);
                app.setConfiguration(this.createConfiguration(bmi));
                app.setRegistration(this.createRegistration(bmi));
                app.setSettings(this.createSettings(bmi));
                this.mergeSettings(app);
                map.put(name, app);
                return app;
            }
            catch (Exception e) {
                LOGGER.error("Unable to load application information due to exception: " + e.getMessage(), (Throwable)e);
                return null;
            }
        }
    }

    private void mergeSettings(Application app) {
        Properties settings = app.getSettings();
        String parent = settings.getProperty(PARENT);
        while (null != parent) {
            Application daddy = this.getApplication(parent);
            if (null == daddy) {
                LOGGER.warn("Unable to find parent, " + parent + ", for application, " + app.getName() + ". The settings will not be merged.");
                return;
            }
            Properties daddySettings = daddy.getSettings();
            for (String string : daddySettings.keySet()) {
                if (settings.containsKey(string)) continue;
                settings.setProperty(string, daddySettings.getProperty(string));
            }
            parent = daddySettings.getProperty(PARENT);
        }
    }

    private void loadConfigurations() {
        BaseAssociationFilter filter = new BaseAssociationFilter();
        filter.setXMLSelect(CONFIGURATION_SEARCH);
        filter.setOMRTemplate(CONFIGURATION_TEMPLATE);
        filter.setOMRFlags(512);
        try {
            List list = this.info.browseSearchProtocols(this.user, this.protocols, (Filter)filter);
            for (BrowseMetadataInterface bmi : list) {
                String name = bmi.getName();
                LOGGER.info("Loading configuration for: " + name);
                Application app = new Application();
                app.setName(name);
                app.setConfiguration(this.createConfiguration(bmi));
                app.setSettings(this.createSettings(bmi));
                map.put(name, app);
            }
            for (Application app : map.values()) {
                this.mergeSettings(app);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to load application configurations due to exception: " + e.getMessage(), (Throwable)e);
        }
    }

    private ApplicationConfiguration createConfiguration(BrowseMetadataInterface bmi) {
        try {
            ApplicationConfiguration config = new ApplicationConfiguration();
            config.setName(bmi.getName());
            config.setDescription(bmi.getDescription());
            config.setVendor(BrowseMetadataUtil.getAttribute(bmi, "Vendor"));
            config.setVendorId(BrowseMetadataUtil.getAttribute(bmi, "VendorIdentifier"));
            config.setProductName(BrowseMetadataUtil.getAttribute(bmi, "ProductName"));
            config.setProductId(BrowseMetadataUtil.getAttribute(bmi, "ProductIdentifier"));
            config.setSpecVendor(BrowseMetadataUtil.getAttribute(bmi, "SpecVendor"));
            config.setSpecVersion(BrowseMetadataUtil.getAttribute(bmi, "SpecVersion"));
            config.setSoftwareVersion(BrowseMetadataUtil.getAttribute(bmi, "SoftwareVersion"));
            Boolean defaultInstance = BrowseMetadataUtil.getBooleanProperty(bmi, IS_DEFAULT_INSTANCE);
            if (null == defaultInstance) {
                defaultInstance = Boolean.FALSE;
            }
            config.setDefaultInstance(defaultInstance);
            String associatedApps = BrowseMetadataUtil.getStringProperty(bmi, ASSOCIATED_APPLICATIONS);
            if (null == associatedApps || "".equals(associatedApps)) {
                associatedApps = "";
            }
            config.setAssociatedApplications(associatedApps);
            String historyId = BrowseMetadataUtil.getStringProperty(bmi, HISTORY_IDENTIFIER);
            config.setHistoryId(null == historyId ? "-1" : String.valueOf(historyId));
            return config;
        }
        catch (Exception e) {
            LOGGER.error("Unable to load configuration for application '" + bmi.getName() + "' due to exception: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private Properties createSettings(BrowseMetadataInterface bmi) {
        try {
            String parent;
            Properties props = new Properties();
            BrowseMetadataInterface group = BrowseMetadataUtil.getBrowseMetadataObjectByName(bmi, "PropertySets", CONFIGURATION_PROPERTY_SET);
            List setProperties = BrowseMetadataUtil.getAssociation(group, "SetProperties");
            if (null != setProperties) {
                for (BrowseMetadataInterface property : setProperties) {
                    String name = BrowseMetadataUtil.getAttribute(property, "PropertyName");
                    if (null == name) {
                        name = property.getName();
                    }
                    props.setProperty(name, BrowseMetadataUtil.getAttribute(property, "DefaultValue"));
                }
            }
            if (null != (parent = this.getParent(bmi))) {
                props.setProperty(PARENT, parent);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Settings: " + props);
            }
            return props;
        }
        catch (Exception e) {
            LOGGER.error("Unable to load settings for application '" + bmi.getName() + "' due to exception: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private String getParent(BrowseMetadataInterface bmi) {
        List list = BrowseMetadataUtil.getAssociation(bmi, "ImplementedObjects");
        if (null == list || list.isEmpty()) {
            return null;
        }
        BrowseMetadataInterface parent = (BrowseMetadataInterface)list.get(0);
        if ("SoftwareComponent".equals(parent.getNativeType())) {
            return parent.getName();
        }
        return null;
    }

    public void loadRegistrations() {
        BaseAssociationFilter filter = new BaseAssociationFilter();
        filter.setXMLSelect(REGISTRATION_SEARCH);
        filter.setOMRTemplate(REGISTRATION_TEMPLATE);
        filter.setOMRFlags(512);
        try {
            List list = this.info.browseSearchProtocols(this.user, this.protocols, (Filter)filter);
            for (BrowseMetadataInterface bmi : list) {
                ApplicationRegistration registration;
                String name = bmi.getName();
                LOGGER.info("Loading registration for: " + name);
                Application app = (Application)map.get(name);
                if (null == app) {
                    app = new Application();
                    app.setName(name);
                    map.put(name, app);
                }
                if (null == (registration = this.createRegistration(bmi))) {
                    LOGGER.error("Found invalid registration for: " + name);
                    continue;
                }
                app.setRegistration(registration);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to load application registrations due to exception: " + e.getMessage(), (Throwable)e);
        }
    }

    private ApplicationRegistration createRegistration(BrowseMetadataInterface bmi) {
        try {
            int port;
            List list = (List)bmi.get("DeployedComponents");
            if (null == list || list.isEmpty()) {
                return null;
            }
            BrowseMetadataInterface component = (BrowseMetadataInterface)list.get(0);
            if (null == (list = (List)component.get("SourceConnections")) || list.isEmpty()) {
                return null;
            }
            BrowseMetadataInterface connection = (BrowseMetadataInterface)list.get(0);
            String name = bmi.getName();
            ApplicationRegistration registration = new ApplicationRegistration();
            registration.setName(name);
            String protocol = BrowseMetadataUtil.getAttribute(connection, "CommunicationProtocol");
            registration.setProtocol(protocol);
            String host = BrowseMetadataUtil.getAttribute(connection, "HostName");
            String developerSystemProperty = System.getProperty(SAS_DEVELOPER_MACHINE);
            String midtierSystemProperty = System.getProperty(SAS_MIDTIER_MACHINE);
            if (null != midtierSystemProperty && !"".equals(midtierSystemProperty)) {
                host = midtierSystemProperty;
            } else if (null != developerSystemProperty && !"".equals(developerSystemProperty)) {
                host = LOCALHOST;
            }
            registration.setHost(host);
            String portStr = BrowseMetadataUtil.getAttribute(connection, "Port");
            String portSystemProperty = System.getProperty(SAS_MIDTIER_PORT);
            if (null != portSystemProperty && !"".equals(portSystemProperty)) {
                portStr = portSystemProperty;
            }
            if (null != portStr && !"".equals(portStr)) {
                port = Integer.parseInt(portStr);
            } else {
                int defaultHTTPPort = 80;
                int defaultHTTPSPort = 443;
                port = HTTPS.equals(protocol) ? 443 : 80;
            }
            registration.setPort(port);
            registration.setContext(BrowseMetadataUtil.getAttribute(connection, "Service"));
            if (!HTTPS.equals(protocol) && !HTTP.equals(protocol)) {
                LOGGER.error("The application protocol must be 'http' or 'https'. Found: '" + protocol + "' for '" + name + "'. Defaulting to HTTP.");
                registration.setProtocol(HTTP);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Registration: " + registration);
            }
            return registration;
        }
        catch (Exception e) {
            LOGGER.error("Unable to parse registration for '" + bmi.getName() + "' due to exception: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

