/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.services.bootstrap;

import com.sas.services.ServiceException;
import com.sas.services.deployment.MetadataSourceFactory;
import com.sas.services.deployment.MetadataSourceInterface;
import com.sas.services.deployment.PlatformServices;
import com.sas.services.deployment.PlatformServicesConfiguration;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.RepositoryDef;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Deprecated
public class ServiceInitializer {
    private boolean verbose = false;
    private Properties properties;
    private Date startTime = new Date();
    private DiscoveryServiceInterface discoveryService = DiscoveryService.defaultInstance();

    public void setVerbose(boolean flag) {
        this.verbose = flag;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setProperties(Properties props) {
        this.properties = props;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getStartTime() {
        DateFormat df = DateFormat.getDateTimeInstance(0, 0, Locale.getDefault());
        return df.format(this.startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deployServices() {
        MetadataSourceInterface metadataSource = null;
        try {
            if (this.isVerbose()) {
                System.out.println();
                System.out.println("Using properties: [");
                Enumeration<Object> keys = this.properties.keys();
                ArrayList<String> l = new ArrayList<String>(this.properties.size());
                while (keys.hasMoreElements()) {
                    String next = (String)keys.nextElement();
                    l.add(next);
                }
                Collections.sort(l);
                for (String next : l) {
                    String value = this.properties.getProperty(next);
                    if (next.indexOf("password") != -1) {
                        value = "******";
                    }
                    System.out.println("\t" + next + "=" + value);
                }
                System.out.println("]");
            }
            metadataSource = MetadataSourceFactory.newMetadataSource((Properties)this.properties);
            PlatformServicesConfiguration config = new PlatformServicesConfiguration(new MetadataSourceInterface[]{metadataSource}, null);
            PlatformServices.setServicesConfiguration((PlatformServicesConfiguration)config);
        }
        catch (Exception e) {
            System.err.println("Error: Cannot create a new metadata source to initialize the service(s).");
            if (this.isVerbose()) {
                e.printStackTrace(System.err);
            }
            if (null != metadataSource) {
                metadataSource.destroy();
            }
            return false;
        }
        try {
            PlatformServices.startServices();
            if (this.isVerbose()) {
                this.printInfo();
            }
        }
        catch (ServiceException se) {
            System.err.println("Error: Cannot deploy the service(s).");
            if (this.isVerbose()) {
                se.printStackTrace(System.err);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != metadataSource) {
                metadataSource.destroy();
            }
        }
        return true;
    }

    public boolean testLoggingService() {
        Object serviceTemp = null;
        Logger logger = LogManager.getLogger(this.getClass());
        logger.info("The logging service is deployed.");
        return true;
    }

    public void printInfo() {
        block4: {
            System.out.println();
            System.out.println("--- Foundation Service information ---");
            try {
                Iterator it = this.discoveryService.getLocalServices();
                while (it.hasNext()) {
                    Object o = it.next();
                    if (!(o instanceof InformationServiceInterface)) continue;
                    System.out.println(InformationServiceInterface.class.getName() + "[ ");
                    InformationServiceInterface info = (InformationServiceInterface)o;
                    List l = info.getReposDefs();
                    for (RepositoryDef def : l) {
                        System.out.println("\tRepositoryDef: [");
                        System.out.println("\t  name=" + def.getName());
                        System.out.println("\t  base=" + def.getBase());
                        System.out.println("\t  host=" + def.getHost());
                        System.out.println("\t  port=" + def.getPort());
                        System.out.println("\t  type=" + def.getProtocol());
                        System.out.println("\t  auto=" + def.getAuto());
                        System.out.println("\t]");
                    }
                    System.out.println("]");
                }
            }
            catch (Exception e) {
                if (!this.isVerbose()) break block4;
                e.printStackTrace(System.err);
            }
        }
    }

    public String getVersion() {
        return ServiceInitializer.class.getPackage().getImplementationVersion();
    }
}

