/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.services;

import com.sas.services.ServiceException;
import com.sas.services.deployment.MetadataSourceFactory;
import com.sas.services.deployment.MetadataSourceInterface;
import com.sas.services.deployment.PlatformServices;
import com.sas.services.deployment.PlatformServicesConfiguration;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.DiscoveryServiceInterface;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Deprecated
public class ServiceInitializer {
    private boolean verbose = false;
    private Properties properties;
    private final Date startTime = new Date();
    private final DiscoveryServiceInterface discoveryService = DiscoveryService.defaultInstance();

    protected ServiceInitializer() {
    }

    protected void setVerbose(boolean flag) {
        this.verbose = flag;
    }

    protected void setVerbose(String verb) {
        if ("-verbose".equalsIgnoreCase(verb)) {
            this.setVerbose(true);
        } else {
            this.setVerbose(false);
        }
    }

    protected boolean isVerbose() {
        return this.verbose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean loadMetadataProperties(String filename) {
        FileInputStream fileStream = null;
        try {
            fileStream = new FileInputStream(filename);
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("Error: Cannot find the metadata properties file \"" + filename + "\".");
            if (this.isVerbose()) {
                System.err.println(fnfe.getMessage());
            }
            return false;
        }
        try {
            this.properties = new Properties();
            this.properties.load(fileStream);
        }
        catch (IOException ioe) {
            System.err.println("Error: Cannot load the metadata properties file \"" + filename + "\".");
            if (this.isVerbose()) {
                System.err.println(ioe.getMessage());
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                fileStream.close();
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    protected void setMetadataProperties(Properties props) {
        this.properties = new Properties(props);
    }

    protected Properties getMetadataProperties() {
        return this.properties;
    }

    protected String getMetadataProperty(String key) {
        return this.properties.getProperty(key);
    }

    protected String getStartTime() {
        DateFormat df = DateFormat.getDateTimeInstance(0, 0, Locale.getDefault());
        return df.format(this.startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean deployServices() {
        MetadataSourceInterface metadataSource = null;
        try {
            metadataSource = MetadataSourceFactory.newMetadataSource((Properties)this.getMetadataProperties());
            PlatformServicesConfiguration config = new PlatformServicesConfiguration(new MetadataSourceInterface[]{metadataSource}, null);
            PlatformServices.setServicesConfiguration((PlatformServicesConfiguration)config);
        }
        catch (Exception e) {
            System.err.println("Error: Cannot create a new metadata source to initialize the service(s).");
            if (this.isVerbose()) {
                System.err.println(e.getMessage());
            }
            if (null != metadataSource) {
                metadataSource.destroy();
            }
            return false;
        }
        try {
            PlatformServices.startServices();
            if (this.isVerbose()) {
                System.out.println("discoveryService: " + this.discoveryService);
            }
        }
        catch (ServiceException se) {
            System.err.println("Error: Cannot deploy the service(s).");
            if (this.isVerbose()) {
                System.err.println(se.getMessage());
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != metadataSource) {
                metadataSource.destroy();
            }
        }
        return true;
    }

    protected boolean testLoggingService() {
        Logger logger = LogManager.getLogger(this.getClass());
        logger.info("The logging service is deployed.");
        return true;
    }

    public static void main(String[] args) {
        int maxNumArgs = 2;
        if (null != args && args.length > 0 && args.length <= 2) {
            boolean rc;
            ServiceInitializer si = new ServiceInitializer();
            String filename = args[0];
            System.out.println();
            System.out.println("SAS Foundation Services - Remote Deployment");
            System.out.println("Initializing for SAS Svcs Services");
            System.out.println("Version " + ServiceInitializer.getVersion());
            System.out.println("Starting at " + si.getStartTime() + "...");
            System.out.println();
            if (2 == args.length) {
                si.setVerbose(args[1]);
            }
            if (!(rc = si.loadMetadataProperties(filename))) {
                System.exit(-1);
            }
            if (!(rc = si.deployServices())) {
                System.exit(-1);
            }
            if (si.isVerbose() && !(rc = si.testLoggingService())) {
                System.exit(-1);
            }
            System.out.println();
            System.out.println("Services are deployed and running. Press CTRL-C to stop.");
            System.out.println();
        } else {
            System.out.println();
            System.out.println("SAS Foundation Services - Remote Deployment");
            System.out.println("Version " + ServiceInitializer.getVersion());
            System.out.println();
            System.out.println("Usage: java ServiceInitializer <propertiesFile> [-verbose]");
            System.out.println();
            System.out.println("<propertiesFile>");
            System.out.println("   the metadata properties file");
            System.out.println("-verbose");
            System.out.println("   (optional) enables more descriptive messages");
            System.out.println();
            System.out.println("This application deploys the services defined in the <propertiesFile>.");
        }
    }

    private static String getVersion() {
        return ServiceInitializer.class.getPackage().getImplementationVersion();
    }
}

