/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.services;

import com.sas.framework.services.ConnectionServiceResourceManager;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.deployment.CorePlatformServices;
import com.sas.services.deployment.MetadataSourceFactory;
import com.sas.services.deployment.MetadataSourceInterface;
import com.sas.services.deployment.PlatformServicesConfiguration;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.discovery.Services;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.RepositoryDef;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class PlatformDiscoveryServiceFactoryBean
implements FactoryBean<DiscoveryServiceInterface>,
InitializingBean,
DisposableBean {
    private static final String DEFAULT_DEPLOYMENT_NAME = "Platform Local Services";
    private static final String SOFTWARE_COMPONENT_KEY = "software_component";
    private static final Logger LOGGER = LogManager.getLogger(PlatformDiscoveryServiceFactoryBean.class);
    private Properties remoteServiceProperties;
    private Properties localServiceProperties;
    private boolean isolated = true;
    private DiscoveryServiceInterface discoveryService;
    private final ConnectionServiceResourceManager cxServiceResourceManager = new ConnectionServiceResourceManager();

    public void setRemoteServiceProperties(Properties remoteServiceProperties) {
        this.remoteServiceProperties = remoteServiceProperties;
    }

    public void setLocalServiceProperties(Properties localServiceProperties) {
        this.localServiceProperties = localServiceProperties;
        if (null != this.localServiceProperties && !this.localServiceProperties.containsKey(SOFTWARE_COMPONENT_KEY)) {
            LOGGER.info("No default deployment was specified; using Platform Local Services");
            this.localServiceProperties.setProperty(SOFTWARE_COMPONENT_KEY, DEFAULT_DEPLOYMENT_NAME);
        }
    }

    public void setIsolated(boolean isolated) {
        this.isolated = isolated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        this.cxServiceResourceManager.afterPropertiesSet();
        MetadataSourceInterface[] remoteSourceArray = null;
        MetadataSourceInterface[] localSourceArray = null;
        try {
            if (null != this.remoteServiceProperties && !this.remoteServiceProperties.isEmpty()) {
                this.printPropertyInformation(this.remoteServiceProperties);
                remoteSourceArray = new MetadataSourceInterface[]{MetadataSourceFactory.newMetadataSource((Properties)this.remoteServiceProperties)};
            }
            if (null != this.localServiceProperties && !this.localServiceProperties.isEmpty()) {
                this.printPropertyInformation(this.localServiceProperties);
                localSourceArray = new MetadataSourceInterface[]{MetadataSourceFactory.newMetadataSource((Properties)this.localServiceProperties)};
            }
            PlatformServicesConfiguration config = new PlatformServicesConfiguration(localSourceArray, remoteSourceArray);
            CorePlatformServices.setServicesConfiguration((PlatformServicesConfiguration)config);
            CorePlatformServices.startServices();
            this.discoveryService = CorePlatformServices.getDiscoveryService();
            if (this.isolated && null != this.localServiceProperties && !this.localServiceProperties.isEmpty()) {
                CorePlatformServices.getInformationService().setIsolated();
            }
            this.printServiceInformation();
        }
        finally {
            if (null != remoteSourceArray) {
                for (MetadataSourceInterface metadataSource : remoteSourceArray) {
                    metadataSource.destroy();
                }
            }
            if (null != localSourceArray) {
                for (MetadataSourceInterface metadataSource : localSourceArray) {
                    metadataSource.destroy();
                }
            }
        }
    }

    private void printServiceInformation() throws Exception {
        if (LOGGER.isDebugEnabled()) {
            Services services = CorePlatformServices.getServices();
            LOGGER.debug("Services available: ");
            for (RemoteServiceInterface next : services) {
                LOGGER.debug((Object)next);
            }
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("");
            LOGGER.info("--- Foundation Service information ---");
            Iterator it = this.discoveryService.getLocalServices();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof InformationServiceInterface)) continue;
                LOGGER.info(InformationServiceInterface.class.getName() + "[ ");
                InformationServiceInterface info = (InformationServiceInterface)o;
                List l = info.getReposDefs();
                for (RepositoryDef def : l) {
                    LOGGER.info("\tRepositoryDef: [");
                    LOGGER.info("\t  name=" + def.getName());
                    LOGGER.info("\t  base=" + def.getBase());
                    LOGGER.info("\t  host=" + def.getHost());
                    LOGGER.info("\t  port=" + def.getPort());
                    LOGGER.info("\t  type=" + def.getProtocol());
                    LOGGER.info("\t  auto=" + def.getAuto());
                    LOGGER.info("\t]");
                }
                LOGGER.info("]");
            }
        }
    }

    private void printPropertyInformation(Properties properties) {
        if (LOGGER.isInfoEnabled() && null != properties) {
            LOGGER.info("");
            LOGGER.info("Using properties: [");
            Enumeration<Object> keys = properties.keys();
            ArrayList<String> l = new ArrayList<String>(properties.size());
            while (keys.hasMoreElements()) {
                String next = (String)keys.nextElement();
                l.add(next);
            }
            Collections.sort(l);
            for (String next : l) {
                String value = properties.getProperty(next);
                if (next.indexOf("password") != -1) {
                    value = "******";
                }
                LOGGER.info("\t" + next + "=" + value);
            }
            LOGGER.info("]");
        }
    }

    public void destroy() throws Exception {
        DiscoveryServiceInterface discoveryService = CorePlatformServices.getDiscoveryService();
        Iterator it = discoveryService.getLocalServices();
        while (it.hasNext()) {
            ((RemoteServiceInterface)it.next()).destroy();
        }
        this.cxServiceResourceManager.destroy();
    }

    public DiscoveryServiceInterface getObject() throws Exception {
        return this.discoveryService;
    }

    public Class<DiscoveryServiceInterface> getObjectType() {
        return DiscoveryServiceInterface.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

