/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.services;

import com.sas.framework.services.config.dao.AppProperty;
import com.sas.framework.services.config.dao.PropertySetDatabaseAdminDAO;
import com.sas.services.ServiceException;
import com.sas.services.connection.HostPortSet;
import com.sas.services.information.OMIServer;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.EmptyResultDataAccessException;

public class MetadataClusterConfigurationBean
implements InitializingBean {
    private static final String PROPERTY_SET_NAME = "Environment.Properties";
    private static final String APP_PROPERTY_HOSTS = "omr_cluster_hosts";
    private static final String APP_PROPERTY_PORTS = "omr_cluster_ports";
    private static final Logger LOGGER = LogManager.getLogger(MetadataClusterConfigurationBean.class);
    private PropertySetDatabaseAdminDAO propertySetDatabaseAdminDAO;
    private UserContextInterface userContext;

    public void refreshMetadataClusterProperties() {
        block26: {
            if (null == this.propertySetDatabaseAdminDAO) {
                throw new IllegalStateException("PropertySetDatabaseAdminDAO is not available.");
            }
            if (null == this.userContext) {
                throw new IllegalStateException("UserContext is not available.");
            }
            try {
                AppProperty configHosts = null;
                try {
                    configHosts = this.propertySetDatabaseAdminDAO.getProperty(PROPERTY_SET_NAME, APP_PROPERTY_HOSTS);
                }
                catch (EmptyResultDataAccessException emptyResultDataAccessException) {
                    // empty catch block
                }
                AppProperty configPorts = null;
                try {
                    configPorts = this.propertySetDatabaseAdminDAO.getProperty(PROPERTY_SET_NAME, APP_PROPERTY_PORTS);
                }
                catch (EmptyResultDataAccessException emptyResultDataAccessException) {
                    // empty catch block
                }
                OMIServer metadataServer = (OMIServer)this.userContext.getAuthServer();
                HostPortSet liveCluster = metadataServer.getClusterConnections();
                if (LOGGER.isDebugEnabled()) {
                    if (configHosts != null) {
                        LOGGER.debug("omr_cluster_hosts is " + configHosts.getValue());
                    }
                    if (configPorts != null) {
                        LOGGER.debug("omr_cluster_ports is " + configPorts.getValue());
                    }
                    if (liveCluster != null) {
                        LOGGER.debug("Live cluster is " + liveCluster.toString());
                    }
                }
                if (liveCluster == null || liveCluster.isEmpty()) {
                    LOGGER.error("Unable to find cluster configuration for cluster application properties.");
                    return;
                }
                if (configHosts == null || configPorts == null) {
                    if (configHosts != null) {
                        LOGGER.warn("Application property omr_cluster_ports is missing.  Unmatched omr_cluster_hosts property (" + configHosts.getValue() + ") deleted.");
                        this.propertySetDatabaseAdminDAO.deleteProperty(configHosts);
                        configHosts = null;
                    } else if (configPorts != null) {
                        LOGGER.warn("Application property omr_cluster_hosts is missing.  Unmatched omr_cluster_ports property (" + configPorts.getValue() + ") deleted.");
                        this.propertySetDatabaseAdminDAO.deleteProperty(configPorts);
                        configPorts = null;
                    }
                    if (liveCluster.size() <= 1) {
                        return;
                    }
                    configHosts = new AppProperty(PROPERTY_SET_NAME, APP_PROPERTY_HOSTS, liveCluster.getHosts());
                    configPorts = new AppProperty(PROPERTY_SET_NAME, APP_PROPERTY_PORTS, liveCluster.getPorts());
                    ArrayList<AppProperty> appProperties = new ArrayList<AppProperty>(2);
                    appProperties.add(configHosts);
                    appProperties.add(configPorts);
                    this.propertySetDatabaseAdminDAO.addProperties(appProperties);
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Cluster application properties created for " + liveCluster.toString());
                    }
                    break block26;
                }
                if (liveCluster.size() == 1) {
                    ArrayList<AppProperty> appProperties = new ArrayList<AppProperty>(2);
                    appProperties.add(configHosts);
                    appProperties.add(configPorts);
                    this.propertySetDatabaseAdminDAO.deleteProperties(appProperties);
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Cluster application properties deleted for " + liveCluster.toString());
                    }
                    break block26;
                }
                HostPortSet configuredCluster = null;
                try {
                    configuredCluster = HostPortSet.newInstance((String)configHosts.getValue(), (String)configPorts.getValue());
                }
                catch (IllegalArgumentException e) {
                    LOGGER.warn("Unexpected cluster application properties will be ignored.  Hosts: " + configHosts.getValue() + ", Ports: " + configPorts.getValue());
                }
                if (!liveCluster.equals((Object)configuredCluster)) {
                    ArrayList<AppProperty> appProperties = new ArrayList<AppProperty>(2);
                    appProperties.add(configHosts);
                    appProperties.add(configPorts);
                    this.propertySetDatabaseAdminDAO.deleteProperties(appProperties);
                    configHosts.setValue(liveCluster.getHosts());
                    configPorts.setValue(liveCluster.getPorts());
                    this.propertySetDatabaseAdminDAO.addProperties(appProperties);
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Cluster application properties updated for " + liveCluster.toString());
                    }
                }
            }
            catch (ServiceException e) {
                LOGGER.error("Cluster application property check failed", (Throwable)e);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.refreshMetadataClusterProperties();
    }

    public void setPropertySetDatabaseAdminDAO(PropertySetDatabaseAdminDAO propertySetDatabaseAdminDAO) {
        this.propertySetDatabaseAdminDAO = propertySetDatabaseAdminDAO;
    }

    public void setUserContext(UserContextInterface userContext) {
        this.userContext = userContext;
    }
}

