/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.services;

import com.sas.services.RemoteServiceInterface;
import com.sas.services.ServiceException;
import com.sas.services.deployment.CorePlatformServices;
import com.sas.services.deployment.Environment;
import com.sas.services.deployment.MetadataSourceFactory;
import com.sas.services.deployment.MetadataSourceInterface;
import com.sas.services.deployment.PlatformServicesConfiguration;
import com.sas.services.deployment.ServicesDeploymentEvent;
import com.sas.services.deployment.ServicesDeploymentEventListenerInterface;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.discovery.Services;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.RepositoryDef;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class LocalDiscoveryServiceFactoryBean
implements FactoryBean<DiscoveryServiceInterface>,
InitializingBean,
DisposableBean,
ServicesDeploymentEventListenerInterface {
    private static final Logger LOGGER = LogManager.getLogger(LocalDiscoveryServiceFactoryBean.class);
    private Properties localServiceProperties;
    private boolean isolated = true;
    private int deploymentState = 0;
    private DiscoveryServiceInterface discoveryService;

    public void setLocalServiceProperties(Properties localServiceProperties) {
        this.localServiceProperties = localServiceProperties;
    }

    public void setEnvironment(Environment environment) {
        CorePlatformServices.setEnvironment((Environment)environment);
    }

    public void setIsolated(boolean isolated) {
        this.isolated = isolated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        CorePlatformServices.addServicesDeploymentListener((ServicesDeploymentEventListenerInterface)this);
        MetadataSourceInterface[] localSourceArray = null;
        try {
            if (null != this.localServiceProperties && !this.localServiceProperties.isEmpty()) {
                this.printPropertyInformation(this.localServiceProperties);
                localSourceArray = new MetadataSourceInterface[]{MetadataSourceFactory.newMetadataSource((Properties)this.localServiceProperties)};
            }
            if (this.deploymentState != 8) {
                PlatformServicesConfiguration config = new PlatformServicesConfiguration(localSourceArray, null);
                CorePlatformServices.setServicesConfiguration((PlatformServicesConfiguration)config);
                CorePlatformServices.startServices();
            }
            this.discoveryService = CorePlatformServices.getDiscoveryService();
            if (this.isolated && null != this.localServiceProperties && !this.localServiceProperties.isEmpty()) {
                CorePlatformServices.getInformationService().setIsolated();
            }
            this.printServiceInformation();
        }
        finally {
            if (null != localSourceArray) {
                for (MetadataSourceInterface metadataSource : localSourceArray) {
                    metadataSource.destroy();
                }
            }
        }
    }

    private static void printServices() throws ServiceException {
        if (LOGGER.isDebugEnabled()) {
            Services services = CorePlatformServices.getServices();
            LOGGER.debug("Services available: ");
            for (Object next : services) {
                LOGGER.debug(next);
            }
        }
    }

    private void printServiceInformation() throws Exception {
        LocalDiscoveryServiceFactoryBean.printServices();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("");
            LOGGER.info("--- Foundation Service information ---");
            Iterator it = this.discoveryService.getLocalServices();
            while (it.hasNext()) {
                RemoteServiceInterface o = (RemoteServiceInterface)it.next();
                if (!(o instanceof InformationServiceInterface)) continue;
                LOGGER.info(InformationServiceInterface.class.getName() + "[ ");
                InformationServiceInterface info = (InformationServiceInterface)o;
                List l = info.getReposDefs();
                for (RepositoryDef def : l) {
                    LOGGER.info("\tRepositoryDef: [");
                    LOGGER.info("\t  name=" + def.getName());
                    LOGGER.info("\t  base=" + def.getBase());
                    LOGGER.info("\t  host=" + def.getHost());
                    LOGGER.info("\t  port=" + def.getPort());
                    LOGGER.info("\t  type=" + def.getProtocol());
                    LOGGER.info("\t  auto=" + def.getAuto());
                    LOGGER.info("\t]");
                }
                LOGGER.info("]");
            }
        }
    }

    private void printPropertyInformation(Properties properties) {
        if (LOGGER.isInfoEnabled() && null != properties) {
            LOGGER.info("");
            LOGGER.info("Using properties: [");
            Enumeration<Object> keys = properties.keys();
            ArrayList<String> l = new ArrayList<String>(properties.size());
            while (keys.hasMoreElements()) {
                String next = (String)keys.nextElement();
                l.add(next);
            }
            Collections.sort(l);
            for (String next : l) {
                String value = properties.getProperty(next);
                if (next.indexOf("password") != -1) {
                    value = "******";
                }
                LOGGER.info("\t" + next + "=" + value);
            }
            LOGGER.info("]");
        }
    }

    public void destroy() throws Exception {
        DiscoveryServiceInterface discoveryService = CorePlatformServices.getDiscoveryService();
        Iterator it = discoveryService.getLocalServices();
        while (it.hasNext()) {
            ((RemoteServiceInterface)it.next()).destroy();
        }
    }

    public DiscoveryServiceInterface getObject() throws Exception {
        return this.discoveryService;
    }

    public Class<DiscoveryServiceInterface> getObjectType() {
        return DiscoveryServiceInterface.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void handleServicesDeploymentEvent(ServicesDeploymentEvent servicesDeploymentEvent) throws RemoteException {
        this.deploymentState = servicesDeploymentEvent.getServicesDeploymentState();
    }
}

