/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.xom;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.option.xom.NodeWrapper;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentWrapper
extends NodeWrapper
implements DocumentInfo {
    protected Configuration config;
    protected String baseURI;
    protected long documentNumber;
    private HashMap<String, NodeInfo> idIndex;
    private HashMap<String, Object> userData;

    public DocumentWrapper(Node root, String baseURI, Configuration config) {
        super(root, null, 0);
        if (root.getParent() != null) {
            throw new IllegalArgumentException("root node must not have a parent node");
        }
        this.baseURI = baseURI;
        this.docWrapper = this;
        this.setConfiguration(config);
    }

    public NodeInfo wrap(Node node) {
        if (node == this.node) {
            return this;
        }
        return this.makeWrapper(node, this);
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
        this.documentNumber = config.getDocumentNumberAllocator().allocateDocumentNumber();
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    @Override
    public long getDocumentNumber() {
        return this.documentNumber;
    }

    @Override
    public NodeInfo selectID(String id, boolean getParent) {
        if (this.idIndex == null) {
            Element elem;
            switch (this.nodeKind) {
                case 9: {
                    elem = ((Document)this.node).getRootElement();
                    break;
                }
                case 1: {
                    elem = (Element)this.node;
                    break;
                }
                default: {
                    return null;
                }
            }
            this.idIndex = new HashMap(50);
            this.buildIDIndex(elem);
        }
        return this.idIndex.get(id);
    }

    private void buildIDIndex(Element elem) {
        int i = elem.getChildCount();
        while (--i >= 0) {
            Node child = elem.getChild(i);
            if (!(child instanceof Element)) continue;
            this.buildIDIndex((Element)child);
        }
        i = elem.getAttributeCount();
        while (--i >= 0) {
            Attribute att = elem.getAttribute(i);
            if (att.getType() != Attribute.Type.ID) continue;
            this.idIndex.put(att.getValue(), this.wrap((Node)elem));
        }
    }

    @Override
    public Iterator<String> getUnparsedEntityNames() {
        return Collections.EMPTY_LIST.iterator();
    }

    @Override
    public String[] getUnparsedEntity(String name) {
        return null;
    }

    @Override
    public int getTypeAnnotation() {
        return 630;
    }

    @Override
    public void setUserData(String key, Object value) {
        if (this.userData == null) {
            this.userData = new HashMap(4);
        }
        if (value == null) {
            this.userData.remove(key);
        } else {
            this.userData.put(key, value);
        }
    }

    @Override
    public Object getUserData(String key) {
        if (this.userData == null) {
            return null;
        }
        return this.userData.get(key);
    }
}

