/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.local;

import net.sf.saxon.expr.number.Numberer_en;
import net.sf.saxon.expr.number.NumericGroupFormatter;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.tree.util.FastStringBuffer;

public class Numberer_he
extends Numberer_en {
    private static String[] hebrewUnits = new String[]{"", "\u05d0", "\u05d1", "\u05d2", "\u05d3", "\u05d4", "\u05d5", "\u05d6", "\u05d7", "\u05d8", "\u05d9"};
    private static String[] hebrewTens = new String[]{"", "\u05d9", "\u05db", "\u05dc", "\u05de", "\u05e0", "\u05e1", "\u05e2", "\u05e4", "\u05e6"};
    private static String[] hebrewHundreds = new String[]{"", "\u05e7", "\u05e8", "\u05e9", "\u05ea", "\u05ea\u05e7", "\u05ea\u05e8", "\u05ea\u05e9", "\u05ea\u05ea", "\u05ea\u05ea\u05e7"};

    public String format(long number, String picture, NumericGroupFormatter numGroupFormatter, String letterValue, String ordinal) {
        FastStringBuffer sb = new FastStringBuffer(16);
        int formchar = picture.charAt(0);
        if (UTF16CharacterSet.isHighSurrogate(formchar)) {
            formchar = UTF16CharacterSet.combinePair((char)formchar, picture.charAt(1));
        }
        if (!"traditional".equals(letterValue)) {
            return super.format(number, picture, numGroupFormatter, letterValue, ordinal);
        }
        switch (formchar) {
            case 1488: {
                if (number == 0L) {
                    return "0";
                }
                sb.append(this.toTraditionalSequence(number, numGroupFormatter.getSeparator()));
                break;
            }
            default: {
                return super.format(number, picture, numGroupFormatter, letterValue, ordinal);
            }
        }
        return sb.toString();
    }

    protected String toTraditionalSequence(long number, String groupSeparator) {
        String result = "";
        if (groupSeparator == null || groupSeparator.length() == 0) {
            groupSeparator = "\u05f3";
        }
        long originalNumber = number;
        while (number > 0L) {
            String thisThousandString;
            int thisTriplet = (int)(number % 1000L);
            number /= 1000L;
            if (thisTriplet == 344) {
                thisThousandString = "\u05e9\u05d3\u05de";
            } else {
                int thisUnit = thisTriplet % 10;
                int thisTen = thisTriplet / 10 % 10;
                int thisTeen = thisTriplet % 100;
                int thisHundred = thisTriplet / 100;
                thisThousandString = hebrewHundreds[thisHundred] + (thisTeen == 15 || thisTeen == 16 ? "\u05d8" + (thisTeen == 15 ? "\u05d5" : "\u05d6") : hebrewTens[thisTen] + hebrewUnits[thisUnit]);
            }
            result = thisThousandString + (result.length() > 0 ? groupSeparator : "") + result;
        }
        int len = result.length();
        int minGershayimLength = 2;
        if (originalNumber > 1000L) {
            minGershayimLength = 4;
        }
        if (len == 1) {
            result = result + (number > 1000L ? (char)'\u05f4' : '\u05f3');
        } else if (len >= minGershayimLength) {
            result = result.substring(0, len - 1) + '\u05f4' + result.charAt(len - 1);
        }
        return result;
    }
}

