/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import net.sf.saxon.Configuration;

public final class Version {
    private static final int[] STRUCTURED_VERSION = new int[]{9, 3, 0, 11};
    private static final String VERSION = "9.3.0.11";
    private static final String BUILD = "102012";
    private static final String RELEASE_DATE = "2011-11-17";
    private static final String MAJOR_RELEASE_DATE = "2010-11-17";

    private Version() {
    }

    public static String getProductName() {
        return "SAXON";
    }

    public static String getProductVariantAndVersion(Configuration config) {
        String edition = config.getEditionCode();
        if ((edition.equals("PE") || edition.equals("EE")) && !config.isLicensedFeature(64)) {
            edition = edition + " (unlicensed)";
        }
        return edition + " " + Version.getProductVersion();
    }

    public static String getProductVersion() {
        return VERSION;
    }

    public static int[] getStructuredVersionNumber() {
        return STRUCTURED_VERSION;
    }

    public static String getReleaseDate() {
        return RELEASE_DATE;
    }

    public static String getMajorReleaseDate() {
        return MAJOR_RELEASE_DATE;
    }

    public static String getXSLVersionString() {
        return "2.0";
    }

    public static String getProductTitle() {
        return Version.getProductName() + ' ' + Version.getProductVersion() + " from Saxonica";
    }

    public static String getWebSiteAddress() {
        return "http://www.saxonica.com/";
    }

    public static void main(String[] args) {
        System.err.println(Version.getProductTitle() + " (build " + BUILD + ')');
    }
}

