/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xsltextn;

import com.saxonica.expr.CopyRuleSet;
import com.saxonica.expr.DiscardRuleSet;
import com.saxonica.expr.FailRuleSet;
import com.saxonica.expr.RuleSetWithWarnings;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.BuiltInRuleSet;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.StringifyRuleSet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class XSLMode
extends StyleElement {
    private boolean prepared = false;
    private boolean streamable = false;
    private boolean failOnMultipleMatch = false;
    private boolean warningOnNoMatch = false;
    private boolean warningOnMultipleMatch = true;
    private BuiltInRuleSet defaultRules = StringifyRuleSet.getInstance();

    public boolean isDeclaration() {
        return true;
    }

    public boolean isInstruction() {
        return false;
    }

    protected void index(Declaration decl, PrincipalStylesheetModule top) throws XPathException {
        super.index(decl, top);
    }

    public void prepareAttributes() throws XPathException {
        if (this.prepared) {
            return;
        }
        this.prepared = true;
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            String att;
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f.equals("streamable")) {
                String streamableAtt = Whitespace.trim(atts.getValue(a));
                if (streamableAtt.equals("yes")) {
                    this.streamable = true;
                    continue;
                }
                if (streamableAtt.equals("no")) {
                    this.streamable = false;
                    continue;
                }
                this.compileError("Value of streamable must be 'yes' or 'no'", "XTSE0020");
                continue;
            }
            if (f.equals("name")) {
                String nameAtt = Whitespace.trim(atts.getValue(a));
                if (nameAtt.equals("#default")) continue;
                try {
                    this.setObjectName(this.makeQName(nameAtt));
                }
                catch (NamespaceException err) {
                    this.compileError(err.getMessage(), "XTSE0280");
                }
                catch (XPathException err) {
                    this.compileError(err);
                }
                continue;
            }
            if (f.equals("on-multiple-match")) {
                att = Whitespace.trim(atts.getValue(a));
                if (att.equals("fail")) {
                    this.failOnMultipleMatch = true;
                    continue;
                }
                if (att.equals("use-last")) {
                    this.failOnMultipleMatch = false;
                    continue;
                }
                this.compileError("Value of on-multiple-match must be 'fail' or 'use-last'", "XTSE0020");
                continue;
            }
            if (f.equals("on-no-match")) {
                String value = Whitespace.trim(atts.getValue(a));
                if (value.equals("stringify")) continue;
                if (value.equals("copy")) {
                    this.defaultRules = CopyRuleSet.getInstance();
                    continue;
                }
                if (value.equals("discard")) {
                    this.defaultRules = DiscardRuleSet.getInstance();
                    continue;
                }
                if (value.equals("fail")) {
                    this.defaultRules = FailRuleSet.getInstance();
                    continue;
                }
                this.compileError("Value of on-no-match must be stringify|copy|discard|fail", "XTSE0030");
                continue;
            }
            if (f.equals("warning-on-multiple-match")) {
                att = Whitespace.trim(atts.getValue(a));
                if (att.equals("yes")) {
                    this.warningOnMultipleMatch = true;
                    continue;
                }
                if (att.equals("no")) {
                    this.warningOnMultipleMatch = false;
                    continue;
                }
                this.compileError("Value of warning-on-multiple-match must be 'yes' or 'no'", "XTSE0020");
                continue;
            }
            if (f.equals("warning-on-no-match")) {
                att = Whitespace.trim(atts.getValue(a));
                if (att.equals("yes")) {
                    this.warningOnNoMatch = true;
                    continue;
                }
                if (att.equals("no")) {
                    this.warningOnNoMatch = false;
                    continue;
                }
                this.compileError("Value of warning-on-no-match must be 'yes' or 'no'", "XTSE0020");
                continue;
            }
            this.checkUnknownAttribute(nc);
        }
        Mode mode = this.getObjectName() == null ? this.getPreparedStylesheet().getRuleManager().getUnnamedMode() : this.getPreparedStylesheet().getRuleManager().getMode(this.getObjectName(), true);
        mode.setStreamable(this.streamable);
        if (this.warningOnNoMatch) {
            this.defaultRules = new RuleSetWithWarnings(this.defaultRules);
        }
        mode.setBuiltInRuleSet(this.defaultRules);
        int recoveryPolicy = this.failOnMultipleMatch ? 2 : (this.warningOnMultipleMatch ? 1 : 0);
        mode.setRecoveryPolicy(recoveryPolicy);
    }

    public void validate(Declaration decl) throws XPathException {
    }

    public Expression compile(Executable exec, Declaration decl) throws XPathException {
        return null;
    }
}

