/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xsltextn;

import com.saxonica.expr.IterateInstr;
import com.saxonica.xsltextn.XSLOnCompletion;
import java.util.ArrayList;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.LocalParam;
import net.sf.saxon.expr.instruct.LocalParamBlock;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLParam;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.type.ItemType;

public class XSLIterate
extends StyleElement {
    Expression select = null;

    public boolean isInstruction() {
        return true;
    }

    protected boolean isPermittedChild(StyleElement child) {
        return child instanceof XSLParam || child instanceof XSLOnCompletion;
    }

    protected ItemType getReturnedItemType() {
        return this.getCommonChildItemType();
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    protected boolean mayContainParam(String attName) {
        return !"required".equals(attName);
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String selectAtt = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f.equals("select")) {
                selectAtt = atts.getValue(a);
                continue;
            }
            this.checkUnknownAttribute(nc);
        }
        if (selectAtt == null) {
            this.reportAbsence("select");
        } else {
            this.select = this.makeExpression(selectAtt);
        }
    }

    public void validate(Declaration decl) throws XPathException {
        this.select = this.typeCheck("select", this.select);
        if (!this.hasChildNodes()) {
            this.compileWarning("An empty saxon:iterate instruction has no effect", "SXWN9009");
        }
    }

    public Expression compile(Executable exec, Declaration decl) throws XPathException {
        NodeInfo node;
        AxisIterator children = this.iterateAxis((byte)3);
        ArrayList<NodeInfo> nonFinallyChildren = new ArrayList<NodeInfo>();
        Expression finallyExp = null;
        ArrayList<XSLParam> params = new ArrayList<XSLParam>();
        while ((node = (NodeInfo)children.next()) != null) {
            if (node instanceof XSLParam) {
                params.add((XSLParam)node);
                continue;
            }
            if (node instanceof XSLOnCompletion) {
                finallyExp = ((XSLOnCompletion)node).compile(exec, decl);
                continue;
            }
            nonFinallyChildren.add(node);
        }
        LocalParam[] compiledParams = new LocalParam[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            compiledParams[i] = (LocalParam)((XSLParam)params.get(i)).compile(exec, decl);
        }
        LocalParamBlock paramBlock = new LocalParamBlock(compiledParams);
        Expression action = this.compileSequenceConstructor(exec, decl, new ListIterator(nonFinallyChildren), false);
        if (action == null) {
            return Literal.makeEmptySequence();
        }
        try {
            action = this.makeExpressionVisitor().simplify(action);
            return new IterateInstr(this.select, paramBlock, action, finallyExp);
        }
        catch (XPathException err) {
            this.compileError(err);
            return null;
        }
    }
}

