/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xsltextn;

import com.saxonica.expr.EvaluateInstr;
import java.io.Serializable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLParam;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class XSLEvaluate
extends StyleElement {
    Expression xpath = null;
    SequenceType requiredType = SequenceType.ANY_SEQUENCE;
    Expression namespaceContext = null;
    Expression baseUri = null;
    Expression schemaAware = null;

    public boolean isInstruction() {
        return true;
    }

    protected boolean isPermittedChild(StyleElement child) {
        return child instanceof XSLParam;
    }

    protected ItemType getReturnedItemType() {
        return this.getCommonChildItemType();
    }

    public boolean mayContainSequenceConstructor() {
        return false;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String xpathAtt = null;
        String asAtt = null;
        String baseUriAtt = null;
        String namespaceContextAtt = null;
        String schemaAwareAtt = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f.equals("xpath")) {
                xpathAtt = atts.getValue(a);
                continue;
            }
            if (f.equals("as")) {
                asAtt = atts.getValue(a);
                continue;
            }
            if (f.equals("base-uri")) {
                baseUriAtt = atts.getValue(a);
                continue;
            }
            if (f.equals("namespace-context")) {
                namespaceContextAtt = atts.getValue(a);
                continue;
            }
            if (f.equals("schema-aware")) {
                schemaAwareAtt = atts.getValue(a);
                continue;
            }
            this.checkUnknownAttribute(nc);
        }
        if (xpathAtt == null) {
            this.reportAbsence("xpath");
        } else {
            try {
                this.xpath = this.makeExpression(xpathAtt);
            }
            catch (XPathException e) {
                this.xpath = StringLiteral.makeLiteral(new StringValue("."));
                throw e;
            }
        }
        if (asAtt != null) {
            this.requiredType = this.makeSequenceType(asAtt);
        }
        if (baseUriAtt != null) {
            this.baseUri = this.makeAttributeValueTemplate(baseUriAtt);
        }
        if (namespaceContextAtt != null) {
            this.namespaceContext = this.makeExpression(namespaceContextAtt);
        }
        if (schemaAwareAtt == null) {
            this.schemaAware = StringLiteral.makeLiteral(new StringValue("no"));
        } else {
            String t;
            this.schemaAware = this.makeAttributeValueTemplate(schemaAwareAtt);
            if (this.schemaAware instanceof StringLiteral && !(t = ((StringLiteral)this.schemaAware).getStringValue()).equals("yes") && !t.equals("no")) {
                this.compileError("schema-aware must be 'yes' or 'no'", "XTSE0020");
            }
        }
    }

    public void validate(Declaration decl) throws XPathException {
        NodeInfo child;
        this.xpath = this.typeCheck("select", this.xpath);
        this.baseUri = this.typeCheck("base-uri", this.baseUri);
        this.namespaceContext = this.typeCheck("namespace-context", this.namespaceContext);
        this.schemaAware = this.typeCheck("schema-aware", this.schemaAware);
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = (NodeInfo)kids.next()) != null) {
            if (child instanceof XSLWithParam || child instanceof XSLFallback) continue;
            if (child.getNodeKind() == 3) {
                if (Whitespace.isWhite(child.getStringValueCS())) continue;
                this.compileError("No character data is allowed within xsl:evaluate", "XTSE0010");
                continue;
            }
            this.compileError("Child element " + Err.wrap(child.getDisplayName(), 1) + " is not allowed as a child of xsl:evaluate", "XTSE0010");
        }
        try {
            ExpressionVisitor visitor = this.makeExpressionVisitor();
            RoleLocator role = new RoleLocator(4, (Serializable)((Object)"xsl:evaluate/xpath"), 0);
            this.xpath = TypeChecker.staticTypeCheck(this.xpath, SequenceType.SINGLE_STRING, false, role, visitor);
            role = new RoleLocator(4, (Serializable)((Object)"xsl:analyze-string/namespace-context"), 0);
            if (this.namespaceContext != null) {
                this.namespaceContext = TypeChecker.staticTypeCheck(this.namespaceContext, SequenceType.SINGLE_NODE, false, role, visitor);
            }
        }
        catch (XPathException err) {
            this.compileError(err);
        }
    }

    public Expression compile(Executable exec, Declaration decl) throws XPathException {
        EvaluateInstr eval = new EvaluateInstr(this.xpath, this.requiredType, this.baseUri, this.namespaceContext, this.schemaAware);
        eval.setActualParameters(this.getWithParamInstructions(exec, decl, false, eval));
        return eval;
    }
}

