/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xsltextn;

import com.saxonica.config.ProfessionalConfiguration;
import com.saxonica.xsltextn.ExtensionElementFactory;
import com.saxonica.xsltextn.XSLBreak;
import com.saxonica.xsltextn.XSLCatch;
import com.saxonica.xsltextn.XSLEvaluate;
import com.saxonica.xsltextn.XSLFork;
import com.saxonica.xsltextn.XSLIterate;
import com.saxonica.xsltextn.XSLMode;
import com.saxonica.xsltextn.XSLNextIteration;
import com.saxonica.xsltextn.XSLOnCompletion;
import com.saxonica.xsltextn.XSLTry;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.sort.IntHashMap;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.AbsentExtensionElement;
import net.sf.saxon.style.DataElement;
import net.sf.saxon.style.LiteralResultElement;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.ElementImpl;
import net.sf.saxon.tree.linked.NodeFactory;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.value.DecimalValue;

public class StyleNodeFactoryPE
extends StyleNodeFactory
implements NodeFactory {
    protected IntHashMap<Class> userStyles = new IntHashMap(4);
    protected boolean allowExtensions;

    public StyleNodeFactoryPE(Configuration config) {
        super(config);
        this.allowExtensions = config.isAllowExternalFunctions();
    }

    public ElementImpl makeElementNode(NodeInfo parent, int nameCode, int typeCode, AttributeCollectionImpl attlist, int[] namespaces, int namespacesUsed, PipelineConfiguration pipe, int locationId, int sequence) {
        StyleElement node;
        StyleElement temp;
        boolean toplevel = parent instanceof XSLStylesheet;
        short uriCode = this.namePool.getURICode(nameCode);
        if (uriCode == 2 || !this.allowExtensions || parent instanceof DataElement || toplevel && uriCode != 3) {
            return super.makeElementNode(parent, nameCode, typeCode, attlist, namespaces, namespacesUsed, pipe, locationId, sequence);
        }
        Class<? extends StyleElement> extensionClass = null;
        String uri = this.namePool.getURIFromURICode(uriCode);
        ExtensionElementFactory eef = ((ProfessionalConfiguration)this.config).getExtensionElementFactory(uri);
        if (eef != null) {
            String localName = this.namePool.getLocalName(nameCode);
            extensionClass = eef.getExtensionClass(localName);
        }
        if (extensionClass == null) {
            return super.makeElementNode(parent, nameCode, typeCode, attlist, namespaces, namespacesUsed, pipe, locationId, sequence);
        }
        String baseURI = null;
        int lineNumber = -1;
        int columnNumber = -1;
        LocationProvider locator = pipe.getLocationProvider();
        if (locator != null) {
            baseURI = locator.getSystemId(locationId);
            lineNumber = locator.getLineNumber(locationId);
            columnNumber = locator.getColumnNumber(locationId);
        }
        String localname = this.namePool.getLocalName(nameCode);
        Class<? extends StyleElement> requiredClass = extensionClass;
        if (this.allowExtensions) {
            try {
                temp = extensionClass.newInstance();
            }
            catch (InstantiationException e1) {
                throw new IllegalStateException(e1);
            }
            catch (IllegalAccessException e1) {
                throw new IllegalStateException(e1);
            }
        } else {
            temp = new AbsentExtensionElement();
            XPathException reason = new XPathException("Extension instructions are disabled");
            temp.setValidationError(reason, 3);
            requiredClass = AbsentExtensionElement.class;
        }
        temp.setNamespaceDeclarations(namespaces, namespacesUsed);
        try {
            temp.initialise(nameCode, typeCode, attlist, parent, sequence);
            temp.setLocation(baseURI, lineNumber, columnNumber);
            temp.processStandardAttributes("http://www.w3.org/1999/XSL/Transform");
        }
        catch (XPathException err) {
            temp.setValidationError(err, 1);
        }
        if (uriCode == 3 && !toplevel && !temp.isExtensionNamespace(uriCode)) {
            try {
                XPathException te = new XPathException("saxon:" + localname + " is not being treated as an extension instruction because the namespace " + " http://saxon.sf.net/ has not been declared in extension-element-prefixes");
                te.setLocator(temp);
                te.setErrorCode("SXWN9008");
                pipe.getErrorListener().warning(te);
            }
            catch (TransformerException e1) {
                // empty catch block
            }
            requiredClass = LiteralResultElement.class;
        }
        if (requiredClass.equals(temp.getClass())) {
            node = temp;
        } else {
            try {
                node = requiredClass.newInstance();
            }
            catch (InstantiationException err1) {
                throw new TransformerFactoryConfigurationError(err1, "Failed to create instance of " + requiredClass.getName());
            }
            catch (IllegalAccessException err2) {
                throw new TransformerFactoryConfigurationError(err2, "Failed to access class " + requiredClass.getName());
            }
            node.substituteFor(temp);
        }
        return node;
    }

    protected StyleElement makeXSLElement(int f) {
        if (this.getXsltProcessorVersion().compareTo(DecimalValue.THREE) >= 0) {
            switch (f) {
                case 133: {
                    return new XSLBreak();
                }
                case 135: {
                    return new XSLCatch();
                }
                case 148: {
                    return new XSLEvaluate();
                }
                case 152: {
                    return new XSLFork();
                }
                case 164: {
                    return new XSLIterate();
                }
                case 174: {
                    return new XSLMode();
                }
                case 177: {
                    return new XSLNextIteration();
                }
                case 182: {
                    return new XSLOnCompletion();
                }
                case 207: {
                    return new XSLTry();
                }
            }
            return super.makeXSLElement(f);
        }
        return super.makeXSLElement(f);
    }

    public boolean isElementAvailable(String uri, String localName) {
        boolean b = super.isElementAvailable(uri, localName);
        if (b) {
            return true;
        }
        if (!this.allowExtensions) {
            return false;
        }
        ExtensionElementFactory factory = ((ProfessionalConfiguration)this.config).getExtensionElementFactory(uri);
        if (factory == null) {
            return false;
        }
        try {
            Class<? extends StyleElement> actualClass = factory.getExtensionClass(localName);
            StyleElement s = actualClass.newInstance();
            return s.isInstruction();
        }
        catch (Exception e) {
            return false;
        }
    }
}

