/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xsltextn;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.While;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;

public class SaxonWhile
extends StyleElement {
    private Expression test;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        String testAtt = null;
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f == "test") {
                testAtt = atts.getValue(a);
                continue;
            }
            this.checkUnknownAttribute(nc);
        }
        if (testAtt == null) {
            this.reportAbsence("test");
            return;
        }
        this.test = this.makeExpression(testAtt);
    }

    public void validate(Declaration decl) throws XPathException {
        if (!this.getConfiguration().isLicensedFeature(64)) {
            throw new XPathException("saxon:while is not licensed in this Configuration");
        }
        this.test = this.typeCheck("test", this.test);
    }

    public Expression compile(Executable exec, Declaration decl) throws XPathException {
        Expression action = this.compileSequenceConstructor(exec, decl, this.iterateAxis((byte)3), true);
        if (action == null) {
            action = Literal.makeEmptySequence();
        }
        return new While(this.test, action);
    }
}

