/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xsltextn;

import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class SaxonImportQuery
extends StyleElement {
    private String href;
    private String moduleURI;

    public void prepareAttributes() throws XPathException {
        if (this.href != null || this.moduleURI != null) {
            return;
        }
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f.equals("href")) {
                this.href = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("namespace")) {
                this.moduleURI = Whitespace.trim(atts.getValue(a));
                continue;
            }
            this.checkUnknownAttribute(nc);
            this.moduleURI = "";
        }
        if (this.href == null && this.moduleURI == null) {
            this.compileError("At least one of href or namespace must be specified");
            this.moduleURI = "";
        }
    }

    protected void index(Declaration decl, PrincipalStylesheetModule top) throws XPathException {
        this.prepareAttributes();
        if (this.href == null && this.moduleURI == null) {
            return;
        }
        try {
            PrincipalStylesheetModule top1 = this.getPrincipalStylesheetModule();
            QueryModule importedModule = this.loadModule();
            Iterator<XQueryFunction> it = importedModule.getGlobalFunctionLibrary().getFunctionDefinitions();
            while (it.hasNext()) {
                XQueryFunction def = it.next();
                if (!def.getFunctionName().getNamespaceURI().equals(this.moduleURI)) continue;
                top1.declareXQueryFunction(def);
            }
        }
        catch (XPathException err) {
            this.compileError(err);
        }
    }

    public void validate(Declaration decl) throws XPathException {
        this.checkEmpty();
        this.checkTopLevel(null);
        if (!this.getConfiguration().isLicensedFeature(64)) {
            throw new XPathException("saxon:import-query is not licensed in this Configuration");
        }
    }

    private QueryModule loadModule() throws XPathException {
        StaticQueryContext sqc = this.getConfiguration().newStaticQueryContext();
        sqc.setBaseURI(this.getBaseURI());
        String mainModule = "import module namespace m = \"" + this.moduleURI + "\" at \"" + this.href + "\"; ()";
        XQueryExpression exp = sqc.compileQuery(mainModule);
        return exp.getStaticContext();
    }

    public Expression compile(Executable exec, Declaration decl) throws XPathException {
        this.getPreparedStylesheet().setReasonUnableToCompile("Cannot compile a stylesheet that imports an XQuery library module");
        return null;
    }
}

