/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xsltextn;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.Collator;
import java.util.Locale;
import java.util.Properties;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.CollationDeclaration;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class SaxonCollation
extends StyleElement
implements CollationDeclaration {
    private String collationName;
    private StringCollator collator;

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String nameAtt = null;
        String defaultAtt = null;
        Properties props = new Properties();
        for (int a = 0; a < atts.getLength(); ++a) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f.equals("name")) {
                nameAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("class")) {
                props.setProperty("class", Whitespace.trim(atts.getValue(a)));
                continue;
            }
            if (f.equals("strength")) {
                props.setProperty("strength", Whitespace.trim(atts.getValue(a)));
                continue;
            }
            if (f.equals("decomposition")) {
                props.setProperty("decomposition", Whitespace.trim(atts.getValue(a)));
                continue;
            }
            if (f.equals("lang")) {
                props.setProperty("lang", Whitespace.trim(atts.getValue(a)));
                continue;
            }
            if (f.equals("rules")) {
                props.setProperty("rules", Whitespace.trim(atts.getValue(a)));
                continue;
            }
            if (f.equals("case-order")) {
                props.setProperty("case-order", Whitespace.trim(atts.getValue(a)));
                continue;
            }
            if (f.equals("alphanumeric")) {
                props.setProperty("alphanumeric", Whitespace.trim(atts.getValue(a)));
                continue;
            }
            if (f.equals("ignore-case")) {
                props.setProperty("ignore-case", Whitespace.trim(atts.getValue(a)));
                continue;
            }
            if (f.equals("ignore-modifiers")) {
                props.setProperty("ignore-modifiers", Whitespace.trim(atts.getValue(a)));
                continue;
            }
            if (f.equals("ignore-symbols")) {
                props.setProperty("ignore-modifiers", Whitespace.trim(atts.getValue(a)));
                continue;
            }
            if (f.equals("ignore-width")) {
                props.setProperty("ignore-width", Whitespace.trim(atts.getValue(a)));
                continue;
            }
            if (f.equals("default")) {
                defaultAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            this.checkUnknownAttribute(nc);
        }
        if (nameAtt != null) {
            this.collationName = Whitespace.trim(nameAtt);
            try {
                URI collationURI = new URI(this.collationName);
                if (!collationURI.isAbsolute()) {
                    URI base = new URI(this.getBaseURI());
                    collationURI = base.resolve(collationURI);
                    this.collationName = collationURI.toString();
                }
            }
            catch (URISyntaxException err) {
                this.compileError("Collation name '" + this.collationName + "' is not a valid URI");
                this.collationName = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
            }
        }
        if (defaultAtt != null) {
            this.compileWarning("The 'default' attribute no longer has any effect. Use [xsl:]default-collation instead", "SXWN9005");
            if (!defaultAtt.equals("yes") && !defaultAtt.equals("no")) {
                this.compileError("default attribute must be yes or no");
            }
        }
        if (this.collator == null) {
            Configuration config = this.getConfiguration();
            this.collator = Configuration.getPlatform().makeCollation(config, props, "");
        }
        this.getPrincipalStylesheetModule().setCollation(this.collationName, this.collator);
    }

    public void validate(Declaration decl) throws XPathException {
        this.checkTopLevel(null);
        this.checkEmpty();
        if (!this.getConfiguration().isLicensedFeature(64)) {
            throw new XPathException("saxon:collation is not licensed in this Configuration");
        }
    }

    public Expression compile(Executable exec, Declaration decl) throws XPathException {
        this.getPrincipalStylesheetModule().setCollation(this.collationName, this.collator);
        this.getPreparedStylesheet().setReasonUnableToCompile("Cannot compile a stylesheet that uses saxon:collation (because the Java class java.text.RuleBasedCollator is not serializable)");
        return null;
    }

    public String getCollationName() {
        if (this.collationName == null) {
            try {
                this.prepareAttributes();
            }
            catch (XPathException err) {
                return null;
            }
        }
        return this.collationName;
    }

    public StringCollator getCollator() {
        return this.collator;
    }

    public static void main(String[] args) {
        System.err.println("The following locales have collations available:");
        Locale[] loc = Collator.getAvailableLocales();
        for (int i = 0; i < loc.length; ++i) {
            Locale l = loc[i];
            System.err.println("Locale:" + ("".equals(l.getCountry()) ? "" : " country='" + l.getCountry() + "' (" + l.getDisplayCountry() + ')') + ("".equals(l.getLanguage()) ? "" : " language='" + l.getLanguage() + "' (" + l.getDisplayLanguage() + ')') + ("".equals(l.getVariant()) ? "" : " variant='" + l.getVariant() + "' (" + l.getDisplayVariant() + ')'));
        }
    }
}

