/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xsltextn;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.Assign;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.XSLGeneralVariable;
import net.sf.saxon.style.XSLVariableDeclaration;
import net.sf.saxon.trans.XPathException;

public class SaxonAssign
extends XSLGeneralVariable {
    private Assign instruction = new Assign();

    public boolean isInstruction() {
        return true;
    }

    public boolean isAssignable() {
        return true;
    }

    protected boolean allowsAsAttribute() {
        return false;
    }

    public void validate(Declaration decl) throws XPathException {
        XSLVariableDeclaration declaration;
        super.validate(decl);
        if (!this.getConfiguration().isLicensedFeature(64)) {
            throw new XPathException("saxon:assign is not licensed in this Configuration");
        }
        try {
            declaration = this.bindVariable(this.getVariableQName());
            if (declaration == null) {
                XPathException err = new XPathException("Variable " + this.getVariableQName().getDisplayName() + " has not been declared");
                err.setErrorCode("XPST0008");
                err.setIsStaticError(true);
                throw err;
            }
            declaration.registerReference(this.instruction);
            this.requiredType = declaration.getRequiredType();
        }
        catch (XPathException err) {
            this.compileError(err.getMessage());
            return;
        }
        if (!declaration.isAssignable()) {
            this.compileError("Variable " + this.getVariableDisplayName() + " is not marked as assignable");
        }
        if (!declaration.isGlobal()) {
            this.compileError("saxon:assign now works only with global variables");
        }
    }

    public Expression compile(Executable exec, Declaration decl) throws XPathException {
        this.initializeInstruction(exec, decl, this.instruction);
        return this.instruction;
    }
}

