/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.validate;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.validate.StartTagBufferEE;
import com.saxonica.validate.ValidatingFilter;
import com.saxonica.validate.ValidationStack;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class XSIAttributeHandler
extends ValidatingFilter {
    private StartTagBufferEE startTagBuffer;
    private HashSet<String> namespacesEncountered;
    private HashMap<String, URI> schemaDocumentsRead;
    private boolean useXsiSchemaLocation = true;
    private List<ValidationException> xsiValidationErrors = new ArrayList<ValidationException>(4);

    public XSIAttributeHandler(StartTagBufferEE buffer, ValidationStack out) {
        this.startTagBuffer = buffer;
        this.namespacesEncountered = new HashSet(10);
        this.schemaDocumentsRead = new HashMap(10);
        this.setUnderlyingReceiver(out);
    }

    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        super.setPipelineConfiguration(pipe);
        this.useXsiSchemaLocation = pipe.getParseOptions().isUseXsiSchemaLocation();
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        boolean nilled = false;
        this.xsiValidationErrors.clear();
        if (this.startTagBuffer.hasAttributes()) {
            String value;
            if (this.useXsiSchemaLocation) {
                value = this.startTagBuffer.getAttribute(644);
                if (value != null) {
                    this.processXsiNoNamespaceSchemaLocation(locationId, value);
                }
                if ((value = this.startTagBuffer.getAttribute(643)) != null) {
                    this.processXsiSchemaLocation(value, locationId);
                }
            }
            if ((value = this.startTagBuffer.getAttribute(641)) != null) {
                this.processXsiType(value);
            }
            if ((value = this.startTagBuffer.getAttribute(642)) != null) {
                nilled = this.processXsiNil(value);
            }
        }
        if (this.nextReceiver instanceof ValidationStack) {
            ((ValidationStack)this.nextReceiver).setStartTagBuffer(this.startTagBuffer);
            ((ValidationStack)this.nextReceiver).setIsNilled(nilled);
            ((ValidationStack)this.nextReceiver).setXsiValidationErrors(this.xsiValidationErrors);
        }
        this.namespacesEncountered.add(this.getNamePool().getURI(nameCode));
        this.nextReceiver.startElement(nameCode, typeCode, locationId, properties);
    }

    private void processXsiSchemaLocation(String value, int locationId) throws XPathException {
        String tok;
        StringTokenizer tokenizer = new StringTokenizer(value, " \t\n\r", false);
        String targetNS = null;
        while (tokenizer.hasMoreTokens()) {
            boolean ignore;
            tok = tokenizer.nextToken();
            if (targetNS == null) {
                targetNS = tok;
                continue;
            }
            try {
                URI abs = ResolveURI.makeAbsolute(tok, this.getSystemId());
                ignore = abs.equals(this.schemaDocumentsRead.get(targetNS));
                this.schemaDocumentsRead.put(targetNS, abs);
            }
            catch (URISyntaxException err) {
                ignore = false;
            }
            if (!ignore) {
                if (this.namespacesEncountered.contains(targetNS) && this.getConfiguration().getXsdVersion() != 11) {
                    String message = "xsi:schemaLocation namespace " + Err.wrap(targetNS) + " has already appeared earlier in the instance document";
                    ValidationException ve = new ValidationException(message);
                    ve.setConstraintReference(1, "schema-loc", "4");
                    this.reportValidationError(ve, false, locationId, 1);
                }
                this.loadSchema(tok, targetNS);
            }
            targetNS = null;
        }
        if (targetNS != null) {
            String message = "xsi:schemaLocation must contain an even number of URIs";
            ValidationException ve = new ValidationException(message);
            this.reportValidationError(ve, false, locationId, 1);
        }
        tokenizer = new StringTokenizer(value, " \t\n\r", false);
        targetNS = null;
        while (tokenizer.hasMoreTokens()) {
            tok = tokenizer.nextToken();
            if (targetNS == null) {
                targetNS = tok;
                continue;
            }
            this.getConfiguration().sealNamespace(targetNS);
            targetNS = null;
        }
    }

    private void processXsiNoNamespaceSchemaLocation(int locationId, String value) throws XPathException {
        boolean ignore;
        try {
            URI abs = ResolveURI.makeAbsolute(value, this.getSystemId());
            ignore = abs.equals(this.schemaDocumentsRead.get(""));
            this.schemaDocumentsRead.put("", abs);
        }
        catch (URISyntaxException err) {
            ignore = false;
        }
        if (!ignore) {
            if (this.namespacesEncountered.contains("")) {
                String message = "xsi:noNamespaceSchemaLocation cannot appear after the first no-namespace element or attribute";
                ValidationException ve = new ValidationException(message);
                ve.setConstraintReference(1, "schema-loc", "4");
                this.reportValidationError(ve, false, locationId, 1);
            }
            this.loadSchema(value, "");
        }
    }

    private boolean processXsiNil(String value) throws XPathException {
        ConversionResult v = StringValue.convertStringToBuiltInType(value, BuiltInAtomicType.BOOLEAN, this.getConfiguration().getConversionRules());
        if (v instanceof ValidationFailure) {
            String message = "The value of xsi:nil must be a boolean";
            ValidationException ve = new ValidationException(message);
            this.xsiValidationErrors.add(ve);
        }
        return v == BooleanValue.TRUE;
    }

    private void processXsiType(String value) throws XPathException {
        Configuration config = this.getConfiguration();
        try {
            int fingerprint = config.getNamePool().allocateLexicalQName(value, true, this.startTagBuffer, config.getNameChecker()) & 0xFFFFF;
            SchemaType type = config.getSchemaType(fingerprint);
            if (type == null) {
                String message = "Unknown type " + Err.wrap(value) + " specified in xsi:type attribute";
                ValidationException ve = new ValidationException(message);
                ve.setConstraintReference(1, "cvc-elt", "4.2");
                this.xsiValidationErrors.add(ve);
            } else if (type instanceof ComplexType && ((ComplexType)type).isAbstract()) {
                String message = "Type " + Err.wrap(value) + " specified in xsi:type attribute is abstract";
                ValidationException ve = new ValidationException(message);
                ve.setConstraintReference(1, "cvc-type", "2");
                this.xsiValidationErrors.add(ve);
            } else if (this.getUnderlyingReceiver() instanceof ValidationStack) {
                ((ValidationStack)this.getUnderlyingReceiver()).setXSIType(type);
            }
        }
        catch (XPathException de) {
            String message = "Invalid QName " + Err.wrap(value) + " specified in xsi:type attribute: " + de.getMessage();
            ValidationException ve = new ValidationException(message);
            ve.setConstraintReference(1, "cvc-elt", "4.1");
            this.xsiValidationErrors.add(ve);
        }
    }

    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        int fp = nameCode & 0xFFFFF;
        if (fp == 644) {
            typeCode = 529;
        } else if (fp == 643) {
            typeCode = 645;
        } else if (fp == 641) {
            typeCode = 530;
        } else if (fp == 642) {
            typeCode = 514;
        }
        if (nameCode >> 20 != 0) {
            this.namespacesEncountered.add(this.getNamePool().getURI(nameCode));
        } else {
            this.namespacesEncountered.add("");
        }
        this.nextReceiver.attribute(nameCode, typeCode, value, locationId, properties);
    }

    public void endDocument() throws XPathException {
        super.endDocument();
        this.reportIfInvalid();
    }

    private void loadSchema(String value, String targetNS) throws XPathException {
        int status = ((EnterpriseConfiguration)this.getConfiguration()).getNamespaceStatus(targetNS);
        if (status != 1 && status != 2) {
            return;
        }
        String href = Whitespace.trim(value);
        String base = this.getSystemId();
        PipelineConfiguration pipe = null;
        try {
            pipe = new PipelineConfiguration(this.getPipelineConfiguration());
            EnterpriseConfiguration config = (EnterpriseConfiguration)pipe.getConfiguration();
            config.readSchema(pipe, base, href, targetNS);
        }
        catch (SchemaException e) {
            try {
                pipe.getErrorListener().warning(e);
                pipe.getErrorListener().warning(new SchemaException("Validation will continue without the schema at " + value));
            }
            catch (TransformerException e1) {
                throw XPathException.makeXPathException(e1);
            }
        }
    }
}

