/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.validate;

import java.util.Stack;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.tree.util.AttributeCollectionImpl;

public class StartTagBufferEE
extends StartTagBuffer {
    private Stack<AttributeCollection> stack = new Stack();
    private boolean empty = true;
    private NodeInfo elementNode;

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        this.stack.push(AttributeCollectionImpl.EMPTY_ATTRIBUTE_COLLECTION);
        this.elementNode = null;
        super.startElement(nameCode, typeCode, locationId, properties);
    }

    public void endElement() throws XPathException {
        this.stack.pop();
        super.endElement();
    }

    public void notifyInheritableAttribute(int nameCode, String value, int location, int properties) {
        AttributeCollection atts = this.stack.peek();
        if (atts == AttributeCollectionImpl.EMPTY_ATTRIBUTE_COLLECTION) {
            this.stack.pop();
            atts = new AttributeCollectionImpl(this.getConfiguration());
            this.stack.push(atts);
        }
        ((AttributeCollectionImpl)atts).addAttribute(nameCode, 631, value, location, properties);
        this.empty = false;
    }

    public void gatherInheritedAttributes(AttributeCollectionImpl atts) {
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            AttributeCollection ac = (AttributeCollection)this.stack.get(i);
            for (int j = 0; j < ac.getLength(); ++j) {
                int nc = ac.getNameCode(j);
                if (atts.getIndexByFingerprint(nc & 0xFFFFF) >= 0) continue;
                atts.addAttribute(nc, 631, ac.getValue(j), ac.getLocationId(j), ac.getProperties(j));
            }
        }
    }

    public boolean hasInheritedAttributes() {
        return !this.empty;
    }

    public NodeInfo createSkeletonElementNode() throws XPathException {
        if (this.elementNode == null) {
            int len = this.bufferedAttributes.getLength();
            TinyBuilder builder = new TinyBuilder();
            builder.setSizeParameters(new int[]{2, len + 2, this.namespacesSize + 2, 16});
            builder.setPipelineConfiguration(this.getPipelineConfiguration());
            builder.open();
            builder.startElement(this.elementNameCode, 630, 0, 0);
            for (int i = 0; i < this.namespacesSize; ++i) {
                builder.namespace(this.namespaces[i], 0);
            }
            AttributeCollectionImpl allAttributes = this.bufferedAttributes;
            if (this.hasInheritedAttributes()) {
                allAttributes = this.bufferedAttributes.getLength() == 0 ? new AttributeCollectionImpl(this.getConfiguration()) : AttributeCollectionImpl.copy(this.bufferedAttributes);
                this.gatherInheritedAttributes(allAttributes);
            }
            for (int i = 0; i < allAttributes.getLength(); ++i) {
                builder.attribute(allAttributes.getNameCode(i), 631, allAttributes.getValue(i), 0, 0);
            }
            builder.startContent();
            builder.endElement();
            this.elementNode = builder.getCurrentRoot();
        }
        return this.elementNode;
    }
}

