/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.validate;

import com.saxonica.schema.ElementDecl;
import java.util.Set;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.sort.IntHashMap;
import net.sf.saxon.expr.sort.IntSet;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.SchemaNodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.type.SchemaComponentVisitor;
import net.sf.saxon.type.SchemaType;

public class SchemaElementTest
extends NodeTest
implements SchemaNodeTest {
    private Configuration config;
    private ElementDecl head;
    private IntHashMap<ElementDecl> group;

    public SchemaElementTest(ElementDecl element) {
        this.config = element.getConfiguration();
        this.head = element;
        Set<ElementDecl> subsGroup = element.getSubstitutionGroupMembers();
        this.group = new IntHashMap(subsGroup.size());
        for (ElementDecl decl : subsGroup) {
            this.group.put(decl.getFingerprint(), decl);
        }
    }

    public ElementDecl getElementDeclaration() {
        return this.head;
    }

    public boolean matches(int nodeKind, int nameCode, int annotation) {
        if (nodeKind != 1) {
            return false;
        }
        ElementDecl decl = this.group.get(nameCode & 0xFFFFF);
        return decl != null && SchemaElementTest.matchesAnnotation(this.config, decl.getType(), annotation);
    }

    public boolean matches(TinyTree tree, int nodeNr) {
        if (tree.getNodeKind(nodeNr) != 1) {
            return false;
        }
        ElementDecl decl = this.group.get(tree.getNameCode(nodeNr) & 0xFFFFF);
        return decl != null && (!tree.isNilled(nodeNr) || decl.isNillable()) && SchemaElementTest.matchesAnnotation(this.config, decl.getType(), tree.getTypeAnnotation(nodeNr));
    }

    public boolean matches(NodeInfo node) {
        if (node.getNodeKind() != 1) {
            return false;
        }
        ElementDecl decl = this.group.get(node.getFingerprint() & 0xFFFFF);
        return decl != null && (!node.isNilled() || decl.isNillable()) && SchemaElementTest.matchesAnnotation(this.config, decl.getType(), node.getTypeAnnotation());
    }

    public static boolean matchesAnnotation(Configuration config, SchemaType required, int annotation) {
        int requiredType = required.getFingerprint();
        if (requiredType == 572) {
            return true;
        }
        if (annotation == -1) {
            annotation = 630;
        }
        if (annotation == requiredType) {
            return true;
        }
        for (SchemaType actual = config.getSchemaType(annotation); actual != null; actual = actual.getBaseType()) {
            if (actual != required) continue;
            return true;
        }
        return false;
    }

    public final double getDefaultPriority() {
        return 0.0;
    }

    public int getPrimitiveType() {
        return 1;
    }

    public int getNodeKindMask() {
        return 2;
    }

    public IntSet getRequiredNodeNames() {
        return this.group.keySet();
    }

    public SchemaType getContentType() {
        return this.head.getType();
    }

    public int getHeadFingerprint() {
        return this.head.getFingerprint();
    }

    public void visitNamedSchemaComponents(SchemaComponentVisitor visitor) throws XPathException {
        visitor.visitSchemaComponent(this.head);
    }

    public String toString() {
        return "schema-element(" + this.head.getDisplayName() + ')';
    }

    public String toString(NamePool pool) {
        return this.toString();
    }

    public int hashCode() {
        return this.head.getFingerprint();
    }

    public boolean equals(Object other) {
        return other instanceof SchemaElementTest && ((SchemaElementTest)other).head == this.head;
    }
}

