/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.validate;

import com.saxonica.validate.ConstraintChecker;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.SaxonLocator;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.instruct.DummyNamespaceResolver;
import net.sf.saxon.expr.number.Numberer_en;
import net.sf.saxon.expr.sort.IntHashMap;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Whitespace;

public class IdValidator
extends ProxyReceiver {
    private ConstraintChecker constraintChecker;
    private Set<String>[] stack = new HashSet[20];
    private int level = 0;
    private HashSet<String> idValues = new HashSet(100);
    private HashSet<String> unresolvedRefs = new HashSet(100);
    private IdValueChecker currentElementChecker = null;
    private FastStringBuffer buffer = new FastStringBuffer(64);
    private long textLocationId = 0L;
    private IntHashMap<IdValueChecker> checkerMap = new IntHashMap(10);
    private static NonIdChecker SINGLETON_NON_ID_CHECKER = new NonIdChecker();

    public void setConstraintChecker(ConstraintChecker checker) {
        this.constraintChecker = checker;
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        this.currentElementChecker = this.checkerMap.get(typeCode);
        if (this.currentElementChecker == null) {
            this.currentElementChecker = this.allocateChecker(typeCode & 0xFFFFF);
            this.checkerMap.put(typeCode, this.currentElementChecker);
        }
        if (this.currentElementChecker == SINGLETON_NON_ID_CHECKER) {
            this.currentElementChecker = null;
        }
        if (this.stack.length <= this.level) {
            HashSet[] s2 = new HashSet[this.stack.length * 2];
            System.arraycopy(this.stack, 0, s2, 0, this.stack.length);
            this.stack = s2;
        }
        if (this.stack[this.level] == null) {
            this.stack[this.level] = new HashSet<String>(4);
        } else {
            this.stack[this.level].clear();
        }
        ++this.level;
        this.nextReceiver.startElement(nameCode, typeCode, locationId, properties);
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.currentElementChecker != null) {
            this.buffer.append(chars);
        }
        this.nextReceiver.characters(chars, locationId, properties);
        this.textLocationId = locationId;
    }

    public void endElement() throws XPathException {
        --this.level;
        if (this.currentElementChecker != null) {
            this.currentElementChecker.checkValue(this.buffer, this.textLocationId);
        }
        this.buffer.setLength(0);
        this.currentElementChecker = null;
        this.nextReceiver.endElement();
    }

    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        IdValueChecker checker = this.checkerMap.get(typeCode);
        if (checker == null) {
            checker = this.allocateChecker(typeCode & 0xFFFFF);
            this.checkerMap.put(typeCode, checker);
        }
        checker.checkValue(value, locationId);
        this.nextReceiver.attribute(nameCode, typeCode, value, locationId, properties);
    }

    private IdValueChecker allocateChecker(int fingerprint) {
        switch (fingerprint) {
            case 560: {
                return new SimpleIdChecker();
            }
            case 561: {
                return new SimpleIdrefChecker();
            }
            case 562: {
                return new IdrefListChecker();
            }
        }
        if (fingerprint < 1023) {
            return SINGLETON_NON_ID_CHECKER;
        }
        Configuration config = this.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        SchemaType stype = config.getSchemaType(fingerprint);
        if (stype.isComplexType()) {
            return SINGLETON_NON_ID_CHECKER;
        }
        SimpleType type = (SimpleType)stype;
        if (type.isAtomicType()) {
            if (type.isIdType()) {
                return new SimpleIdChecker();
            }
            if (type.isIdRefType()) {
                return new SimpleIdrefChecker();
            }
            return SINGLETON_NON_ID_CHECKER;
        }
        if (type.isListType()) {
            SimpleType componentType = ((ListType)type).getItemType();
            if (componentType instanceof AtomicType && th.isSubType((AtomicType)componentType, BuiltInAtomicType.ID)) {
                return new IdListChecker();
            }
            if (componentType instanceof AtomicType && th.isSubType((AtomicType)componentType, BuiltInAtomicType.IDREF)) {
                return new IdrefListChecker();
            }
            if (type.isIdType() || type.isIdRefType()) {
                return new UnionChecker(type);
            }
            return SINGLETON_NON_ID_CHECKER;
        }
        if (type.isIdType() || type.isIdRefType()) {
            return new UnionChecker(type);
        }
        return SINGLETON_NON_ID_CHECKER;
    }

    public void close() throws XPathException {
        if (!this.unresolvedRefs.isEmpty()) {
            String value;
            String howMany;
            int count = this.unresolvedRefs.size();
            if (count == 1) {
                howMany = " is one";
                value = "value";
            } else {
                Numberer_en num = new Numberer_en();
                num.setTensUnitsSeparatorCardinal("-");
                howMany = " are " + num.toWords(count, 1);
                value = "values";
            }
            StringBuffer err = new StringBuffer("There" + howMany + " IDREF " + value + " with no corresponding ID");
            if (count > 10) {
                err.append(". First ten:");
            } else {
                err.append(':');
            }
            int i = 0;
            for (String id : this.unresolvedRefs) {
                err.append("\n    ");
                err.append(id);
                if (i++ <= 9) continue;
                break;
            }
            ValidationException ve = new ValidationException(err.toString());
            int hostLanguage = this.getPipelineConfiguration().getHostLanguage();
            if (hostLanguage == 50) {
                ve.setErrorCode("XTTE1555");
            } else if (hostLanguage == 51) {
                ve.setErrorCode("XQDY0027");
            }
            ve.setConstraintReference(1, "cvc-id", "1");
            this.reportValidationError(ve, 0L);
            throw ve;
        }
        this.nextReceiver.close();
    }

    public boolean usesTypeAnnotations() {
        return true;
    }

    protected void reportValidationError(ValidationException err, long locationId) throws ValidationException {
        PipelineConfiguration pipe = this.getPipelineConfiguration();
        int language = pipe.getHostLanguage();
        StructuredQName errorCode = language == 50 ? new StructuredQName("err", "http://www.w3.org/2005/xqt-errors", "XTTE1555") : (language == 51 ? new StructuredQName("err", "http://www.w3.org/2005/xqt-errors", "XQDY0027") : new StructuredQName("err", "http://www.w3.org/2005/xqt-errors", "XSD99999"));
        this.constraintChecker.setErrorCode(errorCode);
        SaxonLocator locator = ExpressionLocation.getSourceLocator(locationId, pipe.getLocationProvider());
        err.setSourceLocator(locator);
        ErrorListener listener = pipe.getErrorListener();
        try {
            listener.fatalError(err);
            err.setHasBeenReported(true);
        }
        catch (TransformerException e) {
            err.setHasBeenReported(true);
            if (e instanceof ValidationException) {
                throw (ValidationException)e;
            }
            if (e.getException() instanceof ValidationException) {
                throw (ValidationException)e.getException();
            }
            throw new ValidationException(e);
        }
    }

    private void processId(String id, long locationId) throws XPathException {
        if (this.level == 0) {
            ValidationException ve = new ValidationException("An element of type xs:ID must have a parent element within the tree being validated");
            int hostLanguage = this.getPipelineConfiguration().getHostLanguage();
            if (hostLanguage == 50) {
                ve.setErrorCode("XTTE1555");
            } else if (hostLanguage == 51) {
                ve.setErrorCode("XQDY0027");
            }
            ve.setConstraintReference(1, "cvc-id", "2");
            this.reportValidationError(ve, locationId);
            throw ve;
        }
        if (this.idValues.contains(id)) {
            Set<String> idsForElement = this.stack[this.level - 1];
            if (this.getConfiguration().getXsdVersion() == 10 || !idsForElement.contains(id)) {
                ValidationException ve = new ValidationException("ID value '" + id + "' is not unique");
                int hostLanguage = this.getPipelineConfiguration().getHostLanguage();
                if (hostLanguage == 50) {
                    ve.setErrorCode("XTTE1555");
                } else if (hostLanguage == 51) {
                    ve.setErrorCode("XQDY0027");
                }
                ve.setConstraintReference(1, "cvc-id", "2");
                this.reportValidationError(ve, locationId);
                throw ve;
            }
        } else {
            this.idValues.add(id);
            if (this.level >= 1) {
                this.stack[this.level - 1].add(id);
            }
        }
        this.unresolvedRefs.remove(id);
    }

    private static class NonIdChecker
    implements IdValueChecker {
        private NonIdChecker() {
        }

        public void checkValue(CharSequence value, long locationId) throws XPathException {
        }
    }

    private class UnionChecker
    implements IdValueChecker {
        private SimpleType type;

        public UnionChecker(SimpleType type) {
            this.type = type;
        }

        public void checkValue(CharSequence value, long locationId) throws XPathException {
            AtomicValue val;
            Configuration config = IdValidator.this.getConfiguration();
            TypeHierarchy th = config.getTypeHierarchy();
            SequenceIterator iter = this.type.getTypedValue(value, DummyNamespaceResolver.getInstance(), config.getConversionRules());
            while ((val = (AtomicValue)iter.next()) != null) {
                AtomicType itemType = val.getTypeLabel();
                if (th.isSubType(itemType, BuiltInAtomicType.ID)) {
                    IdValidator.this.processId(val.getStringValue(), locationId);
                    continue;
                }
                if (!th.isSubType(itemType, BuiltInAtomicType.IDREF)) continue;
                String idref = val.getStringValue();
                if (IdValidator.this.idValues.contains(idref)) continue;
                IdValidator.this.unresolvedRefs.add(idref);
            }
        }
    }

    private class IdrefListChecker
    implements IdValueChecker {
        private IdrefListChecker() {
        }

        public void checkValue(CharSequence value, long locationId) throws XPathException {
            String ids = ((Object)value).toString();
            StringTokenizer tok = new StringTokenizer(ids, " \t\n\r", false);
            while (tok.hasMoreTokens()) {
                String id = tok.nextToken();
                if (IdValidator.this.idValues.contains(id)) continue;
                IdValidator.this.unresolvedRefs.add(id);
            }
        }
    }

    private class IdListChecker
    implements IdValueChecker {
        private IdListChecker() {
        }

        public void checkValue(CharSequence value, long locationId) throws XPathException {
            String ids = ((Object)value).toString();
            StringTokenizer tok = new StringTokenizer(ids, " \t\n\r", false);
            while (tok.hasMoreTokens()) {
                String id = tok.nextToken();
                IdValidator.this.processId(id, locationId);
            }
        }
    }

    private class SimpleIdrefChecker
    implements IdValueChecker {
        private SimpleIdrefChecker() {
        }

        public void checkValue(CharSequence value, long locationId) throws XPathException {
            String id = ((Object)Whitespace.trimWhitespace(value)).toString();
            if (!IdValidator.this.idValues.contains(id)) {
                IdValidator.this.unresolvedRefs.add(id);
            }
        }
    }

    private class SimpleIdChecker
    implements IdValueChecker {
        private SimpleIdChecker() {
        }

        public void checkValue(CharSequence value, long locationId) throws XPathException {
            String id = ((Object)Whitespace.trimWhitespace(value)).toString();
            IdValidator.this.processId(id, locationId);
        }
    }

    private static interface IdValueChecker {
        public void checkValue(CharSequence var1, long var2) throws XPathException;
    }
}

