/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.validate;

import com.saxonica.schema.ElementDecl;
import com.saxonica.schema.IdentityConstraint;
import com.saxonica.schema.IdentityConstraintReference;
import com.saxonica.schema.Key;
import com.saxonica.schema.KeyRef;
import com.saxonica.schema.Unique;
import com.saxonica.stream.watch.Watch;
import com.saxonica.stream.watch.WatchManager;
import com.saxonica.validate.KeySelectorWatch;
import com.saxonica.validate.RefSelectorWatch;
import com.saxonica.validate.SelectorWatch;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.expr.MultiIterator;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;

public class ConstraintChecker
extends WatchManager {
    private StructuredQName errorCode = null;
    private List<Watch> prearrangedWatches = new ArrayList<Watch>(4);

    public ConstraintChecker(StartTagBuffer startTagBuffer, Configuration config) {
        super(startTagBuffer, config);
        Controller controller = startTagBuffer.getPipelineConfiguration().getController();
        if (controller == null) {
            controller = new Controller(config, new Executable(config));
            startTagBuffer.getPipelineConfiguration().setController(controller);
        }
        XPathContextMajor context = controller.newXPathContext();
        this.setXPathContext(context);
    }

    public void setElementDeclaration(ElementDecl decl) throws XPathException {
        SelectorWatch watch;
        IdentityConstraint constraint;
        Iterator<IdentityConstraintReference> iter = decl.getIdentityConstraints();
        while (iter.hasNext()) {
            constraint = iter.next().getTarget();
            if (!(constraint instanceof KeyRef)) continue;
            watch = new RefSelectorWatch(this, (KeyRef)constraint);
            this.prearrangedWatches.add(watch);
        }
        iter = decl.getIdentityConstraints();
        while (iter.hasNext()) {
            constraint = iter.next().getTarget();
            if (!(constraint instanceof Unique) && !(constraint instanceof Key)) continue;
            watch = new KeySelectorWatch(this, constraint);
            this.prearrangedWatches.add(watch);
            MultiIterator watches = new MultiIterator(new Iterator[]{this.watchList.iterator(), this.prearrangedWatches.iterator()});
            while (watches.hasNext()) {
                int reffp;
                Watch ref = (Watch)watches.next();
                if (!(ref instanceof RefSelectorWatch) || (reffp = ((KeyRef)((RefSelectorWatch)ref).getIdentityConstraint()).getReferFingerprint()) != constraint.getFingerprint()) continue;
                ((KeySelectorWatch)watch).addKeyRef((RefSelectorWatch)ref);
            }
        }
    }

    protected void addPrearrangedWatches() throws XPathException {
        Iterator<Watch> watches = this.prearrangedWatches.iterator();
        while (watches.hasNext()) {
            this.addWatch(watches.next());
        }
        this.prearrangedWatches.clear();
    }

    public void setErrorCode(StructuredQName errorCode) {
        this.errorCode = errorCode;
    }

    public StructuredQName getErrorCode() {
        return this.errorCode;
    }

    public boolean isInvalid() {
        return this.errorCode != null;
    }
}

