/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.validate;

import com.saxonica.schema.ElementDecl;
import com.saxonica.validate.LaxValidator;
import com.saxonica.validate.SkipValidator;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Value;

public class AnyTypeValidator
extends LaxValidator {
    String fixedValue = null;
    String defaultValue = null;
    boolean foundChildren = false;
    FastStringBuffer buffer;

    public AnyTypeValidator() {
    }

    public AnyTypeValidator(ElementDecl elementDecl) {
        if (elementDecl != null) {
            Value fixed = elementDecl.getFixedValue();
            if (fixed != null) {
                this.fixedValue = ((AtomicValue)fixed).getStringValue();
            }
            this.defaultValue = elementDecl.getDefaultValue();
        }
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        if (this.isInvalid()) {
            this.childValidator = new SkipValidator();
            this.nextReceiver.startElement(nameCode, 572, locationId, properties);
            return;
        }
        NamePool pool = this.getConfiguration().getNamePool();
        if (this.fixedValue != null) {
            String message = "Element " + Err.wrap(pool.getDisplayName(nameCode), 1) + " cannot appear here, because the containing " + this.getContainingElementName() + " element has fixed content";
            ValidationException ve = new ValidationException(message);
            ve.setConstraintReference(1, "cvc-elt", "5.2.2.1");
            this.reportValidationError(ve, true, locationId, 1);
        }
        this.foundChildren = true;
        super.startElement(nameCode, typeCode, locationId, properties);
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.fixedValue != null || this.defaultValue != null) {
            if (this.buffer == null) {
                this.buffer = new FastStringBuffer(chars.length());
            }
            this.buffer.append(chars);
        }
        super.characters(chars, locationId, properties);
    }

    public void endElement() throws XPathException {
        if (this.fixedValue != null) {
            if (this.buffer == null || this.buffer.length() == 0) {
                this.characters(this.fixedValue, 0, 0);
            } else if (!this.buffer.toString().equals(this.fixedValue)) {
                String message = "The content of " + this.getContainingElementName() + " differs from the fixed value defined in the schema. Fixed value is " + Err.wrap(this.fixedValue, 4) + ", actual value is " + Err.wrap(this.buffer, 4);
                ValidationException ve = new ValidationException(message);
                ve.setConstraintReference(1, "cvc-elt", "5.2.2.2");
                this.reportValidationError(ve, true, this.getContainingElementLocationId(), 1);
            }
        }
        if (!(this.defaultValue == null || this.foundChildren || this.buffer != null && this.buffer.length() != 0)) {
            this.characters(this.defaultValue, 0, 0);
        }
        super.endElement();
    }
}

