/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.update;

import com.saxonica.update.CopyModifyExpression;
import com.saxonica.update.DeleteExpression;
import com.saxonica.update.InsertExpression;
import com.saxonica.update.RenameExpression;
import com.saxonica.update.ReplaceNodeExpression;
import com.saxonica.update.ReplaceValueExpression;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.CopyOf;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.QueryParser;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;

public class UpdateParser
extends QueryParser {
    boolean foundRevalidationDeclaration = false;
    int revalidationMode = 4;

    public int getPermittedFunctions() {
        return 9;
    }

    protected void parseRevalidationDeclaration() throws XPathException {
        int val;
        if (this.foundRevalidationDeclaration) {
            this.grumble("declare revalidation appears more than once", "XUST0003");
        }
        this.foundRevalidationDeclaration = true;
        this.nextToken();
        this.expect(201);
        if ("strict".equals(this.t.currentTokenValue)) {
            val = 1;
        } else if ("lax".equals(this.t.currentTokenValue)) {
            val = 2;
        } else if ("skip".equals(this.t.currentTokenValue)) {
            val = 4;
        } else {
            this.grumble("revalidation mode must be 'strict', 'lax', or 'skip'");
            val = 4;
        }
        ((QueryModule)this.env).setRevalidationMode(val);
        this.nextToken();
    }

    protected void parseUpdatingFunctionDeclaration() throws XPathException {
        this.parseFunctionDeclaration(1);
    }

    public Expression parseExprSingle() throws XPathException {
        switch (this.t.currentToken) {
            case 219: {
                return this.parseTransformExpression();
            }
            case 111: {
                return this.parseInsertExpression();
            }
            case 112: {
                return this.parseDeleteExpression();
            }
            case 113: {
                return this.parseReplaceNodeExpression();
            }
            case 114: {
                return this.parseReplaceValueExpression();
            }
            case 115: {
                return this.parseRenameExpression();
            }
        }
        return super.parseExprSingle();
    }

    private Expression parseTransformExpression() throws XPathException {
        int i;
        CopyModifyExpression copyExp;
        int offset = this.t.currentTokenStartOffset;
        ArrayList clauseList = new ArrayList(4);
        while (this.t.currentToken == 219) {
            this.parseCopyClause(clauseList);
        }
        int modifyOffset = this.t.currentTokenStartOffset;
        this.expect(68);
        this.t.setState(0);
        this.nextToken();
        Expression updateExp = this.parseExprSingle();
        updateExp = this.makeTracer(modifyOffset, updateExp, 2027, null);
        int returnOffset = this.t.currentTokenStartOffset;
        this.expect(25);
        this.t.setState(0);
        this.nextToken();
        Expression returnExp = this.parseExprSingle();
        returnExp = this.makeTracer(returnOffset, returnExp, 2014, null);
        int revalidationMode = ((QueryModule)this.env).getRevalidationMode();
        Expression e = copyExp = new CopyModifyExpression(updateExp, returnExp, revalidationMode);
        ArrayList<Expression> copyBindings = new ArrayList<Expression>(clauseList.size());
        for (i = clauseList.size() - 1; i >= 0; --i) {
            CopyClause clause = (CopyClause)clauseList.get(i);
            LetExpression let = clause.binding;
            LocalVariableReference var = new LocalVariableReference(let);
            copyBindings.add(var);
            let.setAction(e);
            e = let;
        }
        copyExp.setCopyBindings(Block.makeBlock(copyBindings));
        for (i = clauseList.size() - 1; i >= 0; --i) {
            this.undeclareRangeVariable();
        }
        this.setLocation(e, offset);
        return this.makeTracer(offset, e, 2027, null);
    }

    private void parseCopyClause(List clauseList) throws XPathException {
        boolean first = true;
        do {
            CopyClause clause = new CopyClause();
            if (first) {
                clause.offset = this.t.currentTokenStartOffset;
            }
            clauseList.add(clause);
            this.nextToken();
            if (first) {
                first = false;
            } else {
                clause.offset = this.t.currentTokenStartOffset;
            }
            this.expect(21);
            this.nextToken();
            this.expect(201);
            String var = this.t.currentTokenValue;
            LetExpression v = new LetExpression();
            StructuredQName varQName = this.makeStructuredQName(var, false);
            v.setRequiredType(SequenceType.SINGLE_NODE);
            v.setVariableQName(varQName);
            clause.binding = v;
            this.nextToken();
            this.expect(58);
            this.nextToken();
            Expression rhs = this.parseExprSingle();
            RoleLocator role = new RoleLocator(10, (Serializable)((Object)"copyModify"), 0);
            role.setErrorCode("XUTY0013");
            rhs = new ItemChecker(rhs, AnyNodeTest.getInstance(), role);
            rhs = CardinalityChecker.makeCardinalityChecker(rhs, 16384, role);
            boolean preserve = ((QueryModule)this.env).isPreserveNamespaces();
            CopyOf copy = new CopyOf(rhs, preserve, 4, null, true);
            copy.setCopyForUpdate(true);
            v.setSequence(copy);
            this.declareRangeVariable(v);
        } while (this.t.currentToken == 7);
    }

    private Expression parseInsertExpression() throws XPathException {
        int op;
        int offset = this.t.currentTokenStartOffset;
        this.nextToken();
        Expression source = this.parseExprSingle();
        int position = op = this.t.currentToken;
        if (op == 71) {
            this.nextToken();
            op = this.t.currentToken;
            if (op == 116 || op == 117) {
                position = op;
            } else {
                this.grumble("Expected 'as first into' or 'as last into'");
            }
        } else if (op == 118 || op == 119 || op == 120) {
            position = op;
        } else {
            this.grumble("insert position must be one of: before | after | as first into | as last into | into");
        }
        this.nextToken();
        Expression target = this.parseExprSingle();
        int constructionMode = ((QueryModule)this.env).getConstructionMode();
        boolean inherit = ((QueryModule)this.env).isInheritNamespaces();
        InsertExpression e = new InsertExpression(source, target, position, constructionMode, inherit);
        return this.makeTracer(offset, e, 2028, null);
    }

    private Expression parseDeleteExpression() throws XPathException {
        int offset = this.t.currentTokenStartOffset;
        this.nextToken();
        Expression target = this.parseExprSingle();
        DeleteExpression e = new DeleteExpression(target);
        return this.makeTracer(offset, e, 2030, null);
    }

    private Expression parseReplaceNodeExpression() throws XPathException {
        int offset = this.t.currentTokenStartOffset;
        this.nextToken();
        Expression target = this.parseExprSingle();
        this.expect(121);
        this.nextToken();
        Expression replacement = this.parseExprSingle();
        ReplaceNodeExpression e = new ReplaceNodeExpression(target, replacement, ((QueryModule)this.env).getConstructionMode());
        return this.makeTracer(offset, e, 2029, null);
    }

    private Expression parseReplaceValueExpression() throws XPathException {
        int offset = this.t.currentTokenStartOffset;
        this.nextToken();
        Expression target = this.parseExprSingle();
        this.expect(121);
        this.nextToken();
        Expression replacement = this.parseExprSingle();
        ReplaceValueExpression e = new ReplaceValueExpression(target, replacement);
        return this.makeTracer(offset, e, 2029, null);
    }

    private Expression parseRenameExpression() throws XPathException {
        int offset = this.t.currentTokenStartOffset;
        this.nextToken();
        Expression target = this.parseExprSingle();
        this.expect(71);
        this.nextToken();
        Expression newName = this.parseExprSingle();
        RenameExpression e = new RenameExpression(target, newName, this.env.getNamespaceResolver(), this.env.getDefaultElementNamespace());
        return this.makeTracer(offset, e, 2031, null);
    }

    private static class CopyClause {
        public LetExpression binding;
        public int offset;

        private CopyClause() {
        }
    }
}

