/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.update;

import com.saxonica.update.BasicUpdatingExpression;
import com.saxonica.update.PendingUpdateListImpl;
import com.saxonica.update.RenameAction;
import java.io.Serializable;
import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameExpression
extends BasicUpdatingExpression {
    private Expression targetExpression;
    private Expression nameExpression;
    private NamespaceResolver nsContext;
    private String defaultNamespace;

    public RenameExpression(Expression target, Expression name, NamespaceResolver nsContext, String defaultNamespace) {
        this.targetExpression = target;
        this.nameExpression = name;
        this.nsContext = nsContext;
        this.defaultNamespace = defaultNamespace == null ? "" : defaultNamespace;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.targetExpression = visitor.simplify(this.targetExpression);
        this.nameExpression = visitor.simplify(this.nameExpression);
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.targetExpression = visitor.typeCheck(this.targetExpression, contextItemType);
        this.nameExpression = visitor.typeCheck(this.nameExpression, contextItemType);
        RoleLocator role0 = new RoleLocator(10, (Serializable)((Object)"insert"), 1);
        role0.setErrorCode("XUDY0027");
        this.targetExpression = TypeChecker.staticTypeCheck(this.targetExpression, SequenceType.NON_EMPTY_SEQUENCE, false, role0, visitor);
        role0 = new RoleLocator(10, (Serializable)((Object)"rename"), 0);
        role0.setErrorCode("XUTY0012");
        this.targetExpression = TypeChecker.staticTypeCheck(this.targetExpression, SequenceType.OPTIONAL_NODE, false, role0, visitor);
        RoleLocator role1 = new RoleLocator(10, (Serializable)((Object)"rename"), 1);
        role1.setErrorCode("XPTY0004");
        this.nameExpression = TypeChecker.staticTypeCheck(this.nameExpression, SequenceType.SINGLE_ATOMIC, false, role1, visitor);
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        ItemType supplied = this.nameExpression.getItemType(th);
        if (th.relationship(supplied, BuiltInAtomicType.STRING) == 4 && th.relationship(supplied, BuiltInAtomicType.UNTYPED_ATOMIC) == 4 && th.relationship(supplied, BuiltInAtomicType.QNAME) == 4) {
            XPathException de = new XPathException("The new name must be a string, QName, or untypedAtomic");
            de.setErrorCode("XPTY0004");
            de.setIsTypeError(true);
            de.setLocator(this);
            throw de;
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.targetExpression = visitor.optimize(this.targetExpression, contextItemType);
        this.nameExpression = visitor.optimize(this.nameExpression, contextItemType);
        return this;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new PairIterator(this.targetExpression, this.nameExpression);
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        this.targetExpression = this.doPromotion(this.targetExpression, offer);
        this.nameExpression = this.doPromotion(this.nameExpression, offer);
        return this;
    }

    @Override
    public Expression copy() {
        return new RenameExpression(this.targetExpression.copy(), this.nameExpression.copy(), this.nsContext, this.defaultNamespace);
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("rename");
        this.targetExpression.explain(out);
        this.nameExpression.explain(out);
        out.endElement();
    }

    @Override
    public void evaluatePendingUpdates(XPathContext context, PendingUpdateList pul) throws XPathException {
        InscopeNamespaceResolver nr;
        String existingURI;
        String uri;
        String localName;
        String prefix;
        NodeInfo node = (NodeInfo)this.targetExpression.evaluateItem(context);
        if (!(node instanceof MutableNodeInfo)) {
            XPathException err = new XPathException("Node to be renamed is not an updateable node", "SXUP0081");
            err.setLocator(this);
            throw err;
        }
        int nodeKind = node.getNodeKind();
        if (nodeKind != 1 && nodeKind != 2 && nodeKind != 7) {
            XPathException err = new XPathException("Node to be renamed is not an element, attribute, or processing-instruction", "XUTY0012");
            err.setLocator(this);
            throw err;
        }
        AtomicValue nameValue = (AtomicValue)this.nameExpression.evaluateItem(context);
        if (nameValue instanceof StringValue) {
            CharSequence rawName = nameValue.getStringValueCS();
            try {
                String[] parts = context.getConfiguration().getNameChecker().getQNameParts(rawName);
                prefix = parts[0];
                localName = parts[1];
            }
            catch (QNameException err11) {
                XPathException err1 = new XPathException("Invalid node name. " + err11.getMessage(), this);
                err1.setErrorCode("XQDY0074");
                err1.setXPathContext(context);
                err1.setLocator(this);
                throw err1;
            }
            if (prefix.length() == 0) {
                uri = nodeKind == 1 ? this.defaultNamespace : "";
            } else {
                uri = this.nsContext.getURIForPrefix(prefix, true);
                if (uri == null) {
                    XPathException err1 = new XPathException("Undeclared prefix in new node name: " + prefix, this);
                    err1.setErrorCode("XQDY0074");
                    err1.setXPathContext(context);
                    err1.setLocator(this);
                    throw err1;
                }
            }
        } else if (nameValue instanceof QNameValue) {
            localName = ((QNameValue)nameValue).getLocalName();
            uri = ((QNameValue)nameValue).getNamespaceURI();
            if (uri == null) {
                uri = "";
            }
            prefix = ((QNameValue)nameValue).getPrefix();
        } else {
            XPathException err1 = new XPathException("Computed element name has incorrect type");
            err1.setErrorCode("XPTY0004");
            err1.setIsTypeError(true);
            err1.setXPathContext(context);
            err1.setLocator(this);
            throw err1;
        }
        if (uri.length() == 0) {
            prefix = "";
        }
        if (prefix.equals("xmlns")) {
            prefix = "x-xmlns";
        }
        if (nodeKind == 7 && (prefix.length() > 0 || uri.length() > 0)) {
            XPathException err1 = new XPathException("Processing instruction cannot be in a namespace");
            err1.setErrorCode("XUDY0025");
            err1.setIsTypeError(true);
            err1.setXPathContext(context);
            err1.setLocator(this);
            throw err1;
        }
        int nameCode = context.getConfiguration().getNamePool().allocate(prefix, uri, localName);
        NodeInfo targetNode = node;
        if (nodeKind == 2) {
            targetNode = node.getParent();
        } else if (nodeKind == 7) {
            targetNode = null;
        }
        if (!(targetNode == null || nodeKind != 1 && prefix.length() == 0 || (existingURI = (nr = new InscopeNamespaceResolver(targetNode)).getURIForPrefix(prefix, true)) == null || existingURI.length() == 0 || existingURI.equals(uri))) {
            XPathException err1 = new XPathException("New name conflicts with existing namespace binding");
            err1.setErrorCode("XUDY0023");
            err1.setIsTypeError(true);
            err1.setXPathContext(context);
            err1.setLocator(this);
            throw err1;
        }
        try {
            RenameAction action = new RenameAction(node, nameCode);
            action.setOriginator(this);
            ((PendingUpdateListImpl)pul).add(action);
        }
        catch (XPathException e) {
            e.maybeSetLocation(this);
            e.maybeSetContext(context);
            throw e;
        }
    }
}

