/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.update;

import com.saxonica.update.BasicUpdatingExpression;
import com.saxonica.update.DeleteAction;
import com.saxonica.update.PendingUpdateListImpl;
import java.io.Serializable;
import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteExpression
extends BasicUpdatingExpression {
    private Expression targetExpression;

    public DeleteExpression(Expression target) {
        this.targetExpression = target;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new MonoIterator(this.targetExpression);
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.targetExpression = visitor.simplify(this.targetExpression);
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.targetExpression = visitor.typeCheck(this.targetExpression, contextItemType);
        RoleLocator role0 = new RoleLocator(10, (Serializable)((Object)"delete"), 0);
        role0.setErrorCode("XUTY0007");
        this.targetExpression = TypeChecker.staticTypeCheck(this.targetExpression, SequenceType.NODE_SEQUENCE, false, role0, visitor);
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.targetExpression = visitor.optimize(this.targetExpression, contextItemType);
        return this;
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        this.targetExpression = this.doPromotion(this.targetExpression, offer);
        return this;
    }

    @Override
    public Expression copy() {
        return new DeleteExpression(this.targetExpression.copy());
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("delete");
        this.targetExpression.explain(out);
        out.endElement();
    }

    @Override
    public void evaluatePendingUpdates(XPathContext context, PendingUpdateList pul) throws XPathException {
        NodeInfo node;
        SequenceIterator iter = this.targetExpression.iterate(context);
        while ((node = (NodeInfo)iter.next()) != null) {
            if (!(node instanceof MutableNodeInfo)) {
                XPathException err = new XPathException("Node to be deleted is not an updateable node", "SXUP0081");
                err.setLocator(this);
                throw err;
            }
            if (node.getParent() == null) continue;
            try {
                DeleteAction action = new DeleteAction(node);
                action.setOriginator(this);
                ((PendingUpdateListImpl)pul).add(action);
            }
            catch (XPathException e) {
                e.maybeSetLocation(this);
                e.maybeSetContext(context);
                throw e;
            }
        }
    }
}

