/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.update;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyModifyExpression
extends Expression {
    private Expression updateExp;
    private Expression returnExp;
    private Expression copyBindings;
    private int validationMode;

    public CopyModifyExpression(Expression updateExp, Expression returnExp, int validationMode) {
        this.updateExp = updateExp;
        this.returnExp = returnExp;
        this.validationMode = validationMode;
    }

    public void setCopyBindings(Expression copyBindings) {
        this.copyBindings = copyBindings;
    }

    @Override
    public int computeCardinality() {
        return this.returnExp.getCardinality();
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return this.returnExp.getItemType(th);
    }

    @Override
    public boolean isUpdatingExpression() {
        return false;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        Expression[] sub = new Expression[]{this.updateExp, this.returnExp, this.copyBindings};
        return Arrays.asList(sub).iterator();
    }

    @Override
    public void checkForUpdatingSubexpressions() throws XPathException {
        if (!ExpressionTool.isAllowedInUpdatingContext(this.updateExp)) {
            throw new XPathException("Expression in modify clause must be an updating expression (or () or error())", "XUST0002");
        }
        if (this.returnExp.isUpdatingExpression()) {
            throw new XPathException("Expression in return clause must not be an updating expression", "XUST0001");
        }
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        if (original == this.returnExp) {
            this.returnExp = replacement;
            return true;
        }
        if (original == this.copyBindings) {
            this.copyBindings = replacement;
            return true;
        }
        return false;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.copyBindings = visitor.simplify(this.copyBindings);
        this.updateExp = visitor.simplify(this.updateExp);
        this.returnExp = visitor.simplify(this.returnExp);
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.copyBindings = visitor.typeCheck(this.copyBindings, contextItemType);
        this.updateExp = visitor.typeCheck(this.updateExp, contextItemType);
        this.returnExp = visitor.typeCheck(this.returnExp, contextItemType);
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.copyBindings = visitor.optimize(this.copyBindings, contextItemType);
        this.updateExp = visitor.optimize(this.updateExp, contextItemType);
        this.returnExp = visitor.optimize(this.returnExp, contextItemType);
        return this;
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        this.updateExp = this.doPromotion(this.updateExp, offer);
        this.returnExp = this.doPromotion(this.returnExp, offer);
        this.copyBindings = this.doPromotion(this.copyBindings, offer);
        return this;
    }

    @Override
    public Expression copy() {
        CopyModifyExpression exp = new CopyModifyExpression(this.updateExp.copy(), this.returnExp.copy(), this.validationMode);
        exp.setCopyBindings(this.copyBindings.copy());
        return exp;
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("copyModify");
        out.startElement("copyBindings");
        this.copyBindings.explain(out);
        out.endElement();
        out.startElement("modify");
        this.updateExp.explain(out);
        out.endElement();
        out.startElement("return");
        this.returnExp.explain(out);
        out.endElement();
        out.endElement();
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        this.doUpdates(context);
        return this.returnExp.iterate(context);
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        this.doUpdates(context);
        return this.returnExp.evaluateItem(context);
    }

    @Override
    public EventIterator iterateEvents(XPathContext context) throws XPathException {
        this.doUpdates(context);
        return this.returnExp.iterateEvents(context);
    }

    @Override
    public void process(XPathContext context) throws XPathException {
        this.doUpdates(context);
        this.returnExp.process(context);
    }

    private void doUpdates(XPathContext context) throws XPathException {
        NodeInfo node;
        PendingUpdateList pul = context.getConfiguration().newPendingUpdateList();
        this.updateExp.evaluatePendingUpdates(context, pul);
        pul.apply(context, this.validationMode);
        HashSet<NodeInfo> copiedNodes = new HashSet<NodeInfo>();
        SequenceIterator copyIter = this.copyBindings.iterate(context);
        while ((node = (NodeInfo)copyIter.next()) != null) {
            copiedNodes.add(node);
        }
        if (!copiedNodes.containsAll(pul.getAffectedTrees())) {
            XPathException err = new XPathException("A node that was not created during the copy phase has been updated during the modify phase");
            err.setErrorCode("XUDY0014");
            err.setLocator(this);
            err.setXPathContext(context);
            throw err;
        }
    }
}

