/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.testdriver;

import com.saxonica.codegen.QueryCompiler;
import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.testdriver.CanonicalXML;
import com.saxonica.testdriver.XQTSCollectionURIResolver;
import com.saxonica.testdriver.XQTSModuleURIResolver;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.Version;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;
import org.w3c.tidy.Tidy;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XQueryTestSuiteDriver {
    private String testSuiteDir;
    private String saxonDir;
    private EnterpriseConfiguration saConfig;
    private XMLReader resultParser;
    private XMLReader fragmentParser;
    private boolean usePull = false;
    private Pattern testPattern = null;
    private boolean showWarnings = false;
    private boolean compile = false;
    private boolean onwards = false;
    private boolean unfolded = false;
    private boolean runCompiled = false;
    private String os = "win";
    private String javacomp = "%JAVA%\\bin\\javac -classpath %CLASSPATH% ";
    private Pattern javaTestPattern = null;
    private HashMap documentCache = new HashMap(50);
    private String catalogfile = "XQTSCatalog.xml";
    private TransformerFactory tfactory = new TransformerFactoryImpl();
    private XMLStreamWriter results;
    private Writer compileScript = null;
    private HashSet directories = new HashSet(200);
    private PrintStream monitor = System.err;
    private PrintStream log;
    private String indent = "yes";
    private String specVersion = "1.1";
    private String catalogVersion;
    private String javaPath;
    private String jarPath;
    static HashSet noCacheTests = new HashSet(30);
    static CanonicalXML canon;
    Templates xhtmlCanonizer;

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args[0].equals("-?")) {
            System.err.println("XQueryTestSuiteDriver testsuiteDir saxonDir [testNamePattern] [-cat:catalogfile] [-compile] [-runcomp] [-w] [-onwards] [-unfold] [-pull] [-indent:yes|no] [-spec:1.0|1.1]");
        }
        System.err.println("Testing Saxon " + Version.getProductVersion());
        new XQueryTestSuiteDriver().go(args);
    }

    private NameTest elementNameTest(NamePool pool, String local) {
        int nameFP = pool.allocate("", "http://www.w3.org/2005/02/query-test-XQTSCatalog", local) & 0xFFFFF;
        return new NameTest(1, nameFP, pool);
    }

    private NodeInfo getChildElement(NodeInfo parent, NameTest child) {
        return (NodeInfo)parent.iterateAxis((byte)3, child).next();
    }

    public void go(String[] args) throws SAXException, ParserConfigurationException {
        this.testSuiteDir = args[0];
        this.saxonDir = args[1];
        HashSet<Object> exceptions = new HashSet<Object>();
        for (int i = 2; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if (args[i].equals("-w")) {
                    this.showWarnings = true;
                    continue;
                }
                if (args[i].equals("-compile")) {
                    this.compile = true;
                    continue;
                }
                if (args[i].equals("-onwards")) {
                    this.onwards = true;
                    continue;
                }
                if (args[i].equals("-runcomp")) {
                    this.runCompiled = true;
                    continue;
                }
                if (args[i].equals("-unfold")) {
                    this.unfolded = true;
                    continue;
                }
                if (args[i].equals("-pull")) {
                    this.usePull = true;
                    continue;
                }
                if (args[i].startsWith("-indent:")) {
                    this.indent = args[i].substring(8);
                    continue;
                }
                if (args[i].startsWith("-spec:")) {
                    this.specVersion = args[i].substring(6);
                    continue;
                }
                if (!args[i].startsWith("-cat:")) continue;
                this.catalogfile = args[i].substring(5);
                continue;
            }
            this.testPattern = Pattern.compile(args[i]);
        }
        try {
            NodeInfo testCase;
            NodeInfo schemaElement;
            DocumentInfo exceptionsDoc;
            int specVersionAtt;
            int versionAtt;
            int assertAtt;
            int explainAtt;
            int scenarioAtt;
            int variableAtt;
            int compareAtt;
            int idAtt;
            int fileNameAtt;
            int filePathAtt;
            int nameAtt;
            int schemaAtt;
            NameTest optimizationNT;
            NameTest defaultCollectionNT;
            NameTest collectionNT;
            NameTest expectedErrorNT;
            NameTest schemaNT;
            NameTest sourceNT;
            NameTest outputFileNT;
            NameTest contextItemNT;
            NameTest inputQueryNT;
            NameTest queryNT;
            NameTest inputFileNT;
            NameTest inputUriNT;
            NameTest testCaseNT;
            NamePool pool;
            block83: {
                pool = new NamePool();
                this.saConfig = new EnterpriseConfiguration();
                this.saConfig.setNamePool(pool);
                this.saConfig.setHostLanguage(51);
                this.saConfig.setConfigurationProperty("http://saxon.sf.net/feature/xquerySchemaAware", true);
                XMLReader parser = this.saConfig.getSourceParser();
                boolean supports11 = false;
                try {
                    supports11 = parser.getFeature("http://xml.org/sax/features/xml-1.1");
                }
                catch (Exception err) {
                    // empty catch block
                }
                if (!supports11) {
                    this.monitor.println("Warning: XML parser does not support XML 1.1 - " + parser.getClass());
                }
                this.resultParser = this.saConfig.getSourceParser();
                this.resultParser.setEntityResolver(new EntityResolver(){

                    public InputSource resolveEntity(String publicId, String systemId) {
                        return new InputSource(new StringReader(""));
                    }
                });
                this.fragmentParser = this.saConfig.getSourceParser();
                this.log = new PrintStream(new FileOutputStream(new File(this.saxonDir, "/results" + Version.getProductVersion() + ".log")));
                MyErrorListener errorListener = new MyErrorListener(this.log);
                this.saConfig.setErrorListener(errorListener);
                testCaseNT = this.elementNameTest(pool, "test-case");
                inputUriNT = this.elementNameTest(pool, "input-URI");
                inputFileNT = this.elementNameTest(pool, "input-file");
                queryNT = this.elementNameTest(pool, "query");
                inputQueryNT = this.elementNameTest(pool, "input-query");
                contextItemNT = this.elementNameTest(pool, "contextItem");
                outputFileNT = this.elementNameTest(pool, "output-file");
                sourceNT = this.elementNameTest(pool, "source");
                schemaNT = this.elementNameTest(pool, "schema");
                expectedErrorNT = this.elementNameTest(pool, "expected-error");
                collectionNT = this.elementNameTest(pool, "collection");
                defaultCollectionNT = this.elementNameTest(pool, "defaultCollection");
                optimizationNT = this.elementNameTest(pool, "optimization");
                schemaAtt = pool.allocate("", "", "schema") & 0xFFFFF;
                nameAtt = pool.allocate("", "", "name") & 0xFFFFF;
                filePathAtt = pool.allocate("", "", "FilePath") & 0xFFFFF;
                fileNameAtt = pool.allocate("", "", "FileName") & 0xFFFFF;
                idAtt = pool.allocate("", "", "ID") & 0xFFFFF;
                compareAtt = pool.allocate("", "", "compare") & 0xFFFFF;
                variableAtt = pool.allocate("", "", "variable") & 0xFFFFF;
                scenarioAtt = pool.allocate("", "", "scenario") & 0xFFFFF;
                explainAtt = pool.allocate("", "", "explain") & 0xFFFFF;
                assertAtt = pool.allocate("", "", "assert") & 0xFFFFF;
                versionAtt = pool.allocate("", "", "version") & 0xFFFFF;
                specVersionAtt = pool.allocate("", "", "spec-version") & 0xFFFFF;
                exceptionsDoc = this.saConfig.buildDocument(new StreamSource(new File(this.saxonDir + "/exceptions.xml")));
                InputStreamReader fReader = null;
                try {
                    fReader = new FileReader(new File(new File(this.saxonDir), "compilePrefix.cmd"));
                    BufferedReader reader = new BufferedReader(fReader);
                    this.javaPath = reader.readLine();
                    this.jarPath = reader.readLine();
                    fReader.close();
                }
                catch (Exception e) {
                    this.javaPath = "c:\\Program Files\\java\\jdk1.6.0_18\\";
                    this.jarPath = "e:\\saxon-build\\9.3.0.1\\eej\\saxon9ee.jar;e:\\Javalib\\jsdk2.1\\servlet.jar";
                    if (fReader == null) break block83;
                    fReader.close();
                }
            }
            if (this.javaPath == null || this.jarPath == null) {
                throw new Exception("java path setup file does not exist");
            }
            boolean attSet = true;
            NameTest exceptionTestsNT = new NameTest(1, pool.allocate("", "", "tests"), pool);
            AxisIterator exceptionTestCases = exceptionsDoc.iterateAxis((byte)4, exceptionTestsNT);
            while (true) {
                NodeInfo testCase2 = (NodeInfo)exceptionTestCases.next();
                String attVal = null;
                if (testCase2 != null && (attVal = Navigator.getAttributeValue(testCase2, "", "apply-to")) != null) {
                    boolean bl = attSet = attVal.equals("runcomp") && this.runCompiled;
                }
                if (testCase2 == null || !attSet) break;
                String name = testCase2.getStringValue();
                StringTokenizer tok = new StringTokenizer(name);
                while (tok.hasMoreElements()) {
                    exceptions.add(tok.nextElement());
                }
                attSet = true;
            }
            DocumentInfo catalog = this.saConfig.buildDocument(new StreamSource(new File(this.testSuiteDir + "/" + this.catalogfile)));
            NodeInfo catalogTop = (NodeInfo)catalog.iterateAxis((byte)3, NodeKindTest.ELEMENT).next();
            this.catalogVersion = Navigator.getAttributeValue(catalogTop, "", "version");
            String date = DateTimeValue.getCurrentDateTime(null).getStringValue().substring(0, 10);
            this.writeResultFilePreamble(this.saConfig, date);
            if (this.compile) {
                this.compileScript = new FileWriter(new File(new File(this.saxonDir), "compile.cmd"));
                this.os = System.getProperty("os.name").toLowerCase();
                if (this.os.indexOf("nux") >= 0 || this.os.indexOf("nix") >= 0) {
                    this.compileScript.write("export JAVA=" + this.javaPath + "\n");
                    this.compileScript.write("export CLASSPATH=" + this.jarPath + "\n");
                    this.javacomp = "javac ";
                } else if (this.os.indexOf("win") >= 0) {
                    this.compileScript.write("set JAVA=\"" + this.javaPath + "\"\n");
                    this.compileScript.write("set CLASSPATH=" + this.jarPath + "\n");
                    this.javacomp = "%JAVA%\\bin\\javac -classpath %CLASSPATH% ";
                }
            }
            Properties outputProps = new Properties();
            outputProps.setProperty("method", "xml");
            outputProps.setProperty("indent", this.indent);
            outputProps.setProperty("omit-xml-declaration", "yes");
            AxisIterator schemas = catalog.iterateAxis((byte)4, schemaNT);
            while ((schemaElement = (NodeInfo)schemas.next()) != null) {
                String fileName = schemaElement.getAttributeValue(fileNameAtt);
                this.monitor.println("Loading schema " + fileName);
                FileInputStream ssIStream = new FileInputStream(new File(new File(this.testSuiteDir), fileName));
                StreamSource ss = new StreamSource(ssIStream);
                try {
                    this.saConfig.addSchemaSource(ss);
                }
                catch (SchemaException e) {
                    this.monitor.println("** Failed to load schema " + fileName + ": " + e.getMessage());
                }
                ss.getInputStream().close();
            }
            if (!this.compile) {
                NodeInfo sourceElement;
                AxisIterator sources = catalog.iterateAxis((byte)4, sourceNT);
                while ((sourceElement = (NodeInfo)sources.next()) != null) {
                    String schema = sourceElement.getAttributeValue(schemaAtt);
                    String id = sourceElement.getAttributeValue(idAtt);
                    String fileName = sourceElement.getAttributeValue(fileNameAtt);
                    this.monitor.println("Loading source " + fileName);
                    File sFile = new File(new File(this.testSuiteDir), fileName);
                    FileInputStream inStream = new FileInputStream(sFile.getCanonicalPath());
                    StreamSource ss = new StreamSource(inStream);
                    ss.setSystemId(sFile.toURI().toString());
                    ParseOptions options = new ParseOptions();
                    if (schema != null) {
                        options.setSchemaValidationMode(1);
                    }
                    try {
                        DocumentInfo doc = this.saConfig.buildDocument(ss, options);
                        this.documentCache.put(id, doc);
                    }
                    catch (XPathException e) {
                        this.monitor.println("** invalid source document: " + e.getMessage());
                    }
                    inStream.close();
                }
            }
            AxisIterator testCases = catalog.iterateAxis((byte)4, testCaseNT);
            int groupsize = 0;
            String prevGroup = null;
            while ((testCase = (NodeInfo)testCases.next()) != null) {
                NodeInfo e;
                NodeInfo outputFileElement;
                String outputFile;
                String queryName;
                String filePath;
                boolean optimizationOK;
                String testName;
                block84: {
                    String outputDir;
                    XQueryExpression xqe;
                    DecimalValue vn;
                    File dir;
                    String groupName;
                    testName = testCase.getAttributeValue(nameAtt);
                    optimizationOK = true;
                    if (this.testPattern != null && !this.testPattern.matcher(testName).matches()) continue;
                    if (this.onwards) {
                        this.testPattern = null;
                    }
                    if (exceptions.contains(testName) || this.isExcluded(testName)) continue;
                    this.monitor.println("Test " + testName);
                    this.log.println("Test " + testName);
                    filePath = testCase.getAttributeValue(filePathAtt);
                    if (filePath.startsWith("StaticTyping")) continue;
                    NodeInfo query = this.getChildElement(testCase, queryNT);
                    queryName = query.getAttributeValue(nameAtt);
                    String languageVersion = query.getAttributeValue(versionAtt);
                    if (languageVersion == null) {
                        languageVersion = this.specVersion;
                    }
                    String absQueryName = this.unfolded ? this.testSuiteDir + "/Queries/XQUnfolded/" + filePath + queryName + ".xq" : this.testSuiteDir + "/Queries/XQuery/" + filePath + queryName + ".xq";
                    if (this.compile) {
                        if ("parse-error".equals(testCase.getAttributeValue(scenarioAtt))) continue;
                        QueryCompiler qc = new QueryCompiler((Configuration)this.saConfig);
                        qc.setConvertUntypedAtomicParameters(true);
                        qc.setBaseURI(new File(absQueryName).toURI().toString());
                        groupName = testCase.getParent().getAttributeValue(nameAtt);
                        groupName = this.lowercase(groupName);
                        if (groupName.equals(prevGroup)) {
                            int tome;
                            if ((tome = ++groupsize / 500) != 0) {
                                groupName = groupName + tome;
                            }
                        } else {
                            groupsize = 0;
                            prevGroup = groupName;
                        }
                        queryName = this.lowercase(queryName);
                        qc.setClassName(this.makeClassName(groupName, queryName));
                        dir = new File(new File(this.saxonDir), "java");
                        dir.mkdir();
                        qc.setOutputDirectory(dir);
                        try {
                            FileInputStream absQueryStream = new FileInputStream(absQueryName);
                            qc.compileQueryToJava((InputStream)absQueryStream, "utf8");
                            absQueryStream.close();
                            this.log.println("Java source code written ");
                            String finaldir = "java/" + groupName;
                            if (this.directories.contains(finaldir)) continue;
                            this.compileScript.write(this.javacomp + " " + finaldir + "/*.java\n");
                            this.directories.add(finaldir);
                        }
                        catch (XPathException err) {
                            this.log.println("Query compilation failed");
                        }
                        catch (FileNotFoundException err) {
                            this.log.println("Query file not found");
                        }
                        catch (Exception err2) {
                            err2.printStackTrace();
                        }
                        continue;
                    }
                    if (this.runCompiled) {
                        if ("parse-error".equals(testCase.getAttributeValue(scenarioAtt))) continue;
                        QueryCompiler qc = new QueryCompiler((Configuration)this.saConfig);
                        qc.setBaseURI(new File(absQueryName).toURI().toString());
                        groupName = testCase.getParent().getAttributeValue(nameAtt);
                        groupName = this.lowercase(groupName);
                        if (groupName.equals(prevGroup)) {
                            int tome;
                            if ((tome = ++groupsize / 500) != 0) {
                                groupName = groupName + tome;
                            }
                        } else {
                            groupsize = 0;
                            prevGroup = groupName;
                        }
                        queryName = this.lowercase(queryName);
                        qc.setClassName(this.makeClassName(groupName, queryName));
                        dir = new File(new File(this.saxonDir), "java");
                        dir.mkdir();
                        qc.setOutputDirectory(dir);
                        DynamicQueryContext dqc = new DynamicQueryContext(this.saConfig);
                        dqc.setParameterValue("zlsJJ", StringValue.EMPTY_STRING);
                        NodeInfo contextItemElement = this.getChildElement(testCase, contextItemNT);
                        if (contextItemElement != null) {
                            DocumentInfo contextNode = this.loadDocument(contextItemElement.getStringValue());
                            dqc.setContextItem(contextNode);
                        }
                        this.processInputDocuments(testCase, inputFileNT, variableAtt, dqc);
                        this.setQueryParameters(catalog, testCase, dqc, inputUriNT, variableAtt, collectionNT, idAtt);
                        NodeInfo defaultCollection = this.getChildElement(testCase, defaultCollectionNT);
                        if (defaultCollection != null) {
                            String docName = defaultCollection.getStringValue();
                            NodeInfo collectionElement = this.getCollectionElement(catalog, docName, collectionNT, idAtt);
                            XQTSCollectionURIResolver r = new XQTSCollectionURIResolver(catalog, collectionElement, true);
                            this.saConfig.setCollectionURIResolver(r);
                        }
                        this.processInputQueries(testCase, inputQueryNT, variableAtt, nameAtt, filePath, dqc);
                        String outputDir2 = this.saxonDir + "/results/" + filePath;
                        new File(outputDir2).mkdirs();
                        outputFile = outputDir2 + "/" + testName + ".out";
                        File outputFileF = new File(outputFile);
                        outputFileF.createNewFile();
                        StreamResult result = new StreamResult(outputFileF);
                        try {
                            qc.runQuery(dqc, (Result)result, outputProps);
                            result.getOutputStream().close();
                            break block84;
                        }
                        catch (XPathException err) {
                            if (!err.hasBeenReported()) {
                                this.log.println(err.getMessage());
                            }
                            this.processError(err, testCase, testName, filePath + queryName + ".xq", expectedErrorNT, specVersionAtt);
                            continue;
                        }
                        catch (ClassNotFoundException err) {
                            continue;
                        }
                        catch (Exception err2) {
                            err2.printStackTrace();
                            continue;
                        }
                    }
                    StaticQueryContext env = this.saConfig.newStaticQueryContext();
                    env.setModuleURIResolver(new XQTSModuleURIResolver(testCase));
                    File file1 = new File(absQueryName);
                    FileInputStream fileInput1 = new FileInputStream(file1.getCanonicalPath());
                    env.setBaseURI(file1.toURI().toString());
                    fileInput1.close();
                    try {
                        vn = (DecimalValue)DecimalValue.makeDecimalValue(languageVersion, true).asAtomic();
                    }
                    catch (ValidationException ve) {
                        this.log.println("Unknown XQuery language version");
                        vn = DecimalValue.ONE;
                    }
                    env.setLanguageVersion(vn);
                    FileInputStream stream = new FileInputStream(absQueryName);
                    try {
                        xqe = env.compileQuery(stream, "UTF-8");
                        stream.close();
                    }
                    catch (XPathException err) {
                        this.processError(err, testCase, testName, filePath + queryName + ".xq", expectedErrorNT, specVersionAtt);
                        stream.close();
                        continue;
                    }
                    NodeInfo optElement = this.getChildElement(testCase, optimizationNT);
                    if (optElement != null) {
                        String assertion;
                        String explain = optElement.getAttributeValue(explainAtt);
                        if ("true".equals(explain) || "1".equals(explain)) {
                            ExpressionPresenter presenter = new ExpressionPresenter(this.saConfig);
                            xqe.explain(presenter);
                            presenter.close();
                        }
                        if ((assertion = optElement.getAttributeValue(assertAtt)) != null) {
                            TinyBuilder builder = new TinyBuilder();
                            builder.setPipelineConfiguration(this.saConfig.makePipelineConfiguration());
                            ExpressionPresenter presenter = new ExpressionPresenter((Configuration)this.saConfig, builder);
                            xqe.explain(presenter);
                            presenter.close();
                            NodeInfo expressionTree = builder.getCurrentRoot();
                            XPathEvaluator xpe = new XPathEvaluator(this.saConfig);
                            XPathExpression exp = xpe.createExpression(assertion);
                            try {
                                Boolean bv = (Boolean)exp.evaluateSingle(expressionTree);
                                if (bv == null || !bv.booleanValue()) {
                                    this.log.println("** Optimization assertion failed");
                                    optimizationOK = false;
                                }
                            }
                            catch (Exception e2) {
                                this.log.println("** Optimization assertion result is not a boolean: " + assertion + "(" + e2.getMessage() + ")");
                            }
                        }
                    }
                    DynamicQueryContext dqc = new DynamicQueryContext(this.saConfig);
                    NodeInfo contextItemElement = this.getChildElement(testCase, contextItemNT);
                    if (contextItemElement != null) {
                        DocumentInfo contextNode = this.loadDocument(contextItemElement.getStringValue());
                        dqc.setContextItem(contextNode);
                    }
                    this.processInputQueries(testCase, inputQueryNT, variableAtt, nameAtt, filePath, dqc);
                    this.processInputDocuments(testCase, inputFileNT, variableAtt, dqc);
                    this.setQueryParameters(catalog, testCase, dqc, inputUriNT, variableAtt, collectionNT, idAtt);
                    NodeInfo defaultCollection = this.getChildElement(testCase, defaultCollectionNT);
                    if (defaultCollection != null) {
                        String docName = defaultCollection.getStringValue();
                        NodeInfo collectionElement = this.getCollectionElement(catalog, docName, collectionNT, idAtt);
                        XQTSCollectionURIResolver r = new XQTSCollectionURIResolver(catalog, collectionElement, true);
                        this.saConfig.setCollectionURIResolver(r);
                    }
                    if ((outputDir = this.saxonDir + "/results/" + filePath).endsWith("/")) {
                        outputDir = outputDir.substring(0, outputDir.length() - 1);
                    }
                    new File(outputDir).mkdirs();
                    outputFile = outputDir + "/" + testName + ".out";
                    File outputFileF = new File(outputFile);
                    outputFileF.createNewFile();
                    StreamResult result = new StreamResult(outputFileF);
                    try {
                        if (this.usePull) {
                            xqe.pull(dqc, result, outputProps);
                        } else {
                            xqe.run(dqc, result, outputProps);
                        }
                    }
                    catch (XPathException err) {
                        this.processError(err, testCase, testName, filePath + queryName + ".xq", expectedErrorNT, specVersionAtt);
                        continue;
                    }
                }
                boolean resultsMatched = false;
                String possibleMatch = null;
                AxisIterator expectedResults = testCase.iterateAxis((byte)3, outputFileNT);
                boolean multipleResults = false;
                SequenceIterator ccc = expectedResults.getAnother();
                ccc.next();
                if (ccc.next() != null) {
                    multipleResults = true;
                }
                while ((outputFileElement = (NodeInfo)expectedResults.next()) != null) {
                    String appliesTo = outputFileElement.getAttributeValue(specVersionAtt);
                    if (appliesTo != null && !appliesTo.contains(this.specVersion)) continue;
                    String resultsDir = this.testSuiteDir + "/ExpectedTestResults/" + filePath;
                    String resultsPath = resultsDir + outputFileElement.getStringValue();
                    String comparisonMethod = outputFileElement.getAttributeValue(compareAtt);
                    String comparisonResult = comparisonMethod.equals("Ignore") ? "true" : this.compare(outputFile, resultsPath, comparisonMethod, multipleResults);
                    if (comparisonResult.equals("true")) {
                        this.results.writeEmptyElement("test-case");
                        this.results.writeAttribute("name", testName);
                        this.results.writeAttribute("result", "pass");
                        if (!optimizationOK) {
                            this.results.writeAttribute("comment", "check optimization");
                        }
                        resultsMatched = true;
                        break;
                    }
                    if (comparisonResult.equals("false")) continue;
                    possibleMatch = comparisonResult;
                }
                if (resultsMatched) continue;
                if (multipleResults) {
                    this.log.println("*** Failed to match any of the permitted results");
                }
                NodeInfo expectedError = null;
                AxisIterator eit = testCase.iterateAxis((byte)3, expectedErrorNT);
                while ((e = (NodeInfo)eit.next()) != null) {
                    String appliesTo = e.getAttributeValue(specVersionAtt);
                    if (appliesTo != null && !appliesTo.contains(this.specVersion)) continue;
                    expectedError = e;
                    break;
                }
                this.results.writeEmptyElement("test-case");
                this.results.writeAttribute("name", testName);
                if (possibleMatch != null) {
                    this.results.writeAttribute("result", "pass");
                    this.results.writeAttribute("comment", possibleMatch);
                } else if (expectedError != null) {
                    this.results.writeAttribute("result", "fail");
                    this.results.writeAttribute("comment", "expected " + expectedError.getStringValue() + ", got success");
                } else {
                    this.results.writeAttribute("result", "fail");
                }
                this.results.writeProcessingInstruction("file", filePath + queryName + ".xq");
            }
            this.results.writeEndElement();
            this.results.close();
            if (this.compile) {
                this.compileScript.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setQueryParameters(DocumentInfo catalog, NodeInfo testCase, DynamicQueryContext dqc, NameTest inputUriNT, int variableAtt, NameTest collectionNT, int idAtt) throws XPathException {
        NodeInfo inputURI;
        AxisIterator inputURIs = testCase.iterateAxis((byte)3, inputUriNT);
        while ((inputURI = (NodeInfo)inputURIs.next()) != null) {
            String variableName = inputURI.getAttributeValue(variableAtt);
            if ((variableName = XQueryTestSuiteDriver.toClarkName(variableName)) == null) continue;
            String docName = inputURI.getStringValue();
            if (docName.startsWith("collection")) {
                NodeInfo collectionElement = this.getCollectionElement(catalog, docName, collectionNT, idAtt);
                XQTSCollectionURIResolver r = new XQTSCollectionURIResolver(catalog, collectionElement, false);
                this.saConfig.setCollectionURIResolver(r);
                dqc.setParameterValue(variableName, new AnyURIValue(docName));
                continue;
            }
            DocumentInfo doc = this.loadDocument(docName);
            if (doc == null) {
                dqc.setParameterValue(variableName, new AnyURIValue("error-document" + docName));
                continue;
            }
            String uri = doc.getSystemId();
            dqc.setParameterValue(variableName, new AnyURIValue(uri));
        }
    }

    private void processInputDocuments(NodeInfo testCase, NameTest inputFileNT, int variableAtt, DynamicQueryContext dqc) throws XPathException {
        NodeInfo inputFile;
        AxisIterator inputFiles = testCase.iterateAxis((byte)3, inputFileNT);
        while ((inputFile = (NodeInfo)inputFiles.next()) != null) {
            String variableName = inputFile.getAttributeValue(variableAtt);
            if ((variableName = XQueryTestSuiteDriver.toClarkName(variableName)) == null) continue;
            DocumentInfo inputDoc = this.loadDocument(inputFile.getStringValue());
            dqc.setParameterValue(variableName, inputDoc);
        }
    }

    private void processInputQueries(NodeInfo testCase, NameTest inputQueryNT, int variableAtt, int nameAtt, String filePath, DynamicQueryContext dqc) throws XPathException, IOException {
        NodeInfo inputQuery;
        AxisIterator inputQueries = testCase.iterateAxis((byte)3, inputQueryNT);
        while ((inputQuery = (NodeInfo)inputQueries.next()) != null) {
            String variableName = inputQuery.getAttributeValue(variableAtt);
            if ((variableName = XQueryTestSuiteDriver.toClarkName(variableName)) == null) continue;
            String preQueryName = inputQuery.getAttributeValue(nameAtt);
            String subQueryFile = this.testSuiteDir + "/Queries/XQuery/" + filePath + preQueryName + ".xq";
            StaticQueryContext sqc2 = this.saConfig.newStaticQueryContext();
            FileReader subQueryFileReader = new FileReader(subQueryFile);
            XQueryExpression subQuery = sqc2.compileQuery(subQueryFileReader);
            subQueryFileReader.close();
            SequenceIterator subQueryResult = subQuery.iterator(new DynamicQueryContext(this.saConfig));
            dqc.setParameterValue(variableName, SequenceExtent.makeSequenceExtent(subQueryResult));
        }
    }

    private NodeInfo getCollectionElement(DocumentInfo catalog, String docName, NameTest collectionNT, int idAtt) {
        NodeInfo coll;
        NodeInfo collectionElement = null;
        AxisIterator colls = catalog.iterateAxis((byte)4, collectionNT);
        while ((coll = (NodeInfo)colls.next()) != null) {
            if (!docName.equals(coll.getAttributeValue(idAtt))) continue;
            collectionElement = coll;
        }
        return collectionElement;
    }

    protected boolean isExcluded(String testName) {
        return testName.startsWith("dotnet");
    }

    private static String toClarkName(String variableName) {
        if (variableName == null) {
            return null;
        }
        if (variableName.startsWith("local:")) {
            return "{http://www.w3.org/2005/xquery-local-functions}" + variableName.substring(6);
        }
        return variableName;
    }

    private DocumentInfo loadDocument(String xml) {
        return (DocumentInfo)this.documentCache.get(xml);
    }

    private void processError(XPathException err, NodeInfo testCase, String testName, String queryPath, NameTest expectedErrorNT, int specVersionAtt) throws IOException, XMLStreamException {
        NodeInfo expectedError;
        String actualError = err.getErrorCodeLocalPart();
        AxisIterator expectedErrors = testCase.iterateAxis((byte)3, expectedErrorNT);
        FastStringBuffer expected = new FastStringBuffer(20);
        while ((expectedError = (NodeInfo)expectedErrors.next()) != null) {
            String appliesTo = expectedError.getAttributeValue(specVersionAtt);
            if (appliesTo != null && !appliesTo.contains(this.specVersion)) continue;
            if (expectedError.getStringValue().equals(actualError) || expectedError.getStringValue().equals("*")) {
                this.results.writeEmptyElement("test-case");
                this.results.writeAttribute("name", testName);
                this.results.writeAttribute("result", "pass");
                return;
            }
            expected.append(expectedError.getStringValue());
            expected.append(" ");
        }
        if (expected.length() > 0) {
            this.results.writeEmptyElement("test-case");
            this.results.writeAttribute("name", testName);
            this.results.writeAttribute("result", "pass");
            this.results.writeAttribute("comment", "expected " + expected + ", got " + actualError);
        } else {
            this.results.writeEmptyElement("test-case");
            this.results.writeAttribute("name", testName);
            this.results.writeAttribute("result", "fail");
            this.results.writeAttribute("comment", "expected success, got " + actualError);
        }
        this.results.writeProcessingInstruction("file", queryPath);
    }

    private String compare(String outfile, String reffile, String comparator, boolean silent) {
        if (reffile == null) {
            this.log.println("*** No reference results available");
            return "false";
        }
        File outfileFile = new File(outfile);
        File reffileFile = new File(reffile);
        if (!reffileFile.exists()) {
            this.log.println("*** No reference results available");
            return "false";
        }
        String refResult = null;
        String actResult = null;
        try {
            FileReader reader1 = new FileReader(outfileFile);
            FileReader reader2 = new FileReader(reffileFile);
            char[] contents1 = new char[(int)outfileFile.length()];
            char[] contents2 = new char[(int)reffileFile.length()];
            int size1 = reader1.read(contents1, 0, (int)outfileFile.length());
            int size2 = reader2.read(contents2, 0, (int)reffileFile.length());
            reader1.close();
            reader2.close();
            int offset1 = 0;
            int offset2 = 0;
            if (contents1[0] == '\u00ef' && contents1[1] == '\u00bb' && contents1[2] == '\u00bf') {
                offset1 += 3;
            }
            if (contents2[0] == '\u00ef' && contents2[1] == '\u00bb' && contents2[2] == '\u00bf') {
                offset2 += 3;
            }
            actResult = size1 == -1 ? "" : new String(contents1, offset1, size1 - offset1);
            refResult = size2 == -1 ? "" : new String(contents2, offset2, size2 - offset2);
            if ((actResult = this.normalizeNewlines(actResult)).equals(refResult = this.normalizeNewlines(refResult))) {
                return "true";
            }
            if (size1 == 0) {
                if (!silent) {
                    this.log.println("** ACTUAL RESULTS EMPTY; REFERENCE RESULTS LENGTH " + size2);
                }
                return "false";
            }
            if (size2 == 0) {
                if (!silent) {
                    this.log.println("** REFERENCED RESULTS EMPTY; ACTUAL RESULTS LENGTH " + size2);
                }
                return "false";
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (comparator.equals("html-output")) {
            try {
                Tidy tidy = new Tidy();
                tidy.setXmlOut(true);
                tidy.setQuiet(true);
                tidy.setShowWarnings(false);
                tidy.setCharEncoding(3);
                FileInputStream in1 = new FileInputStream(outfile);
                File xml1 = new File(outfile + ".xml");
                xml1.createNewFile();
                FileOutputStream out1 = new FileOutputStream(xml1);
                tidy.parse((InputStream)in1, (OutputStream)out1);
                FileInputStream in2 = new FileInputStream(reffile);
                File xml2 = new File(reffile + ".xml");
                xml2.createNewFile();
                FileOutputStream out2 = new FileOutputStream(xml2);
                tidy.parse((InputStream)in2, (OutputStream)out2);
                ((InputStream)in1).close();
                ((InputStream)in2).close();
                ((OutputStream)out2).close();
                return this.compare(xml1.toString(), xml2.toString(), "xml", silent);
            }
            catch (IOException e) {
                e.printStackTrace();
                return "false";
            }
        }
        if (comparator.equals("xhtml-output")) {
            refResult = this.canonizeXhtml(refResult);
            actResult = this.canonizeXhtml(actResult);
            return Boolean.toString(actResult.equals(refResult));
        }
        if (comparator.equals("Fragment") || comparator.equals("Text")) {
            try {
                boolean b = false;
                try {
                    b = this.compareFragments2(actResult, refResult, outfile, silent);
                }
                catch (Exception err1) {
                    this.log.println("XQTS: First comparison attempt failed " + err1.getMessage() + ", trying again");
                }
                if (!b) {
                    this.log.println("XQTS: First comparison attempt failed, trying again");
                    b = this.compareFragments(outfileFile, reffileFile, outfile, silent);
                }
                return Boolean.toString(b);
            }
            catch (Exception err2) {
                this.log.println("Failed to compare results for: " + outfile);
                err2.printStackTrace();
                return "false";
            }
        }
        if (comparator.equals("Inspect")) {
            this.log.println("** Inspect results by hand");
            return "true";
        }
        try {
            InputSource out = new InputSource(outfileFile.toURL().toString());
            InputSource ref = new InputSource(reffileFile.toURL().toString());
            String outxml = canon.toCanonicalXML2(this.resultParser, out, false);
            String refxml = canon.toCanonicalXML2(this.resultParser, ref, false);
            if (!outxml.equals(refxml)) {
                outxml = canon.toCanonicalXML2(this.resultParser, out, true);
                if (outxml.equals(refxml = canon.toCanonicalXML2(this.resultParser, ref, true))) {
                    this.log.println("*** Match after stripping whitespace nodes: " + outfile);
                    return "*** Match after stripping whitespace nodes";
                }
                if (!silent) {
                    this.log.println("Mismatch with reference results: " + outfile);
                    this.log.println("REFERENCE RESULTS:");
                    this.log.println(XQueryTestSuiteDriver.truncate(refxml));
                    this.log.println("ACTUAL RESULTS:");
                    this.log.println(XQueryTestSuiteDriver.truncate(outxml));
                    this.findDiff(refxml, outxml);
                }
                return "false";
            }
            return "true";
        }
        catch (Exception err) {
            try {
                this.log.println("Failed to compare results for: " + outfile + ": " + err.getMessage());
                this.log.println("** Attempting XML Fragment comparison");
                boolean b = this.compareFragments2(actResult, refResult, outfile, silent);
                this.log.println("** " + (b ? "Success" : "Still different"));
                return Boolean.toString(b);
            }
            catch (Exception err2) {
                this.log.println("Again failed to compare results for: " + outfile);
                err2.printStackTrace();
                return "false";
            }
        }
    }

    private String canonizeXhtml(String input) {
        try {
            Templates canonizer = this.getXhtmlCanonizer();
            Transformer t = canonizer.newTransformer();
            StringWriter sw = new StringWriter();
            StreamResult r = new StreamResult(sw);
            InputSource is = new InputSource(new StringReader(input));
            SAXSource ss = new SAXSource(this.resultParser, is);
            t.transform(ss, r);
            return sw.toString();
        }
        catch (TransformerConfigurationException err) {
            this.log.println("*** Failed to compile XHTML canonicalizer stylesheet");
        }
        catch (TransformerException err) {
            this.log.println("*** Failed while running XHTML canonicalizer stylesheet");
        }
        return "";
    }

    private Templates getXhtmlCanonizer() throws TransformerConfigurationException {
        if (this.xhtmlCanonizer == null) {
            StreamSource source = new StreamSource(new File(this.saxonDir + "/canonizeXhtml.xsl"));
            this.xhtmlCanonizer = this.tfactory.newTemplates(source);
        }
        return this.xhtmlCanonizer;
    }

    private boolean compareFragments(File outfileFile, File reffileFile, String outfile, boolean silent) {
        String outurl = outfileFile.toURI().toString();
        String refurl = reffileFile.toURI().toString();
        String outdoc = "<?xml version='1.1'?><!DOCTYPE doc [ <!ENTITY e SYSTEM '" + outurl + "'>]><doc>&e;</doc>";
        String refdoc = "<?xml version='1.1'?><!DOCTYPE doc [ <!ENTITY e SYSTEM '" + refurl + "'>]><doc>&e;</doc>";
        InputSource out2 = new InputSource(new StringReader(outdoc));
        InputSource ref2 = new InputSource(new StringReader(refdoc));
        String outxml2 = canon.toCanonicalXML(this.fragmentParser, out2, true);
        String refxml2 = canon.toCanonicalXML(this.fragmentParser, ref2, true);
        try {
            out2.getByteStream().close();
            ref2.getByteStream().close();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (outxml2 != null && refxml2 != null && !outxml2.equals(refxml2)) {
            if (!silent) {
                this.log.println("Mismatch with reference results: " + outfile);
                this.log.println("REFERENCE RESULTS:");
                this.log.println(XQueryTestSuiteDriver.truncate(refxml2));
                this.log.println("ACTUAL RESULTS:");
                this.log.println(XQueryTestSuiteDriver.truncate(outxml2));
                this.findDiff(refxml2, outxml2);
            }
            return false;
        }
        if (outxml2 == null) {
            this.log.println("Cannot canonicalize actual results");
            return false;
        }
        if (refxml2 == null) {
            this.log.println("Cannot canonicalize reference results");
            return false;
        }
        return true;
    }

    private boolean compareFragments2(String outFragment, String refFragment, String outfile, boolean silent) {
        int x;
        if (outFragment == null) {
            outFragment = "";
        }
        if (outFragment.startsWith("<?xml")) {
            x = outFragment.indexOf("?>");
            outFragment = outFragment.substring(x + 2);
        }
        if (refFragment == null) {
            refFragment = "";
        }
        if (refFragment.startsWith("<?xml")) {
            x = refFragment.indexOf("?>");
            refFragment = refFragment.substring(x + 2);
        }
        String outdoc = "<?xml version='1.1'?><doc>" + outFragment.trim() + "</doc>";
        String refdoc = "<?xml version='1.1'?><doc>" + refFragment.trim() + "</doc>";
        InputSource out2 = new InputSource(new StringReader(outdoc));
        InputSource ref2 = new InputSource(new StringReader(refdoc));
        String outxml2 = canon.toCanonicalXML(this.fragmentParser, out2, false);
        String refxml2 = canon.toCanonicalXML(this.fragmentParser, ref2, false);
        try {
            out2.getByteStream().close();
            ref2.getByteStream().close();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (outxml2 != null && refxml2 != null && !outxml2.equals(refxml2)) {
            InputSource out3 = new InputSource(new StringReader(outdoc));
            InputSource ref3 = new InputSource(new StringReader(refdoc));
            String outxml3 = canon.toCanonicalXML(this.fragmentParser, out3, true);
            String refxml3 = canon.toCanonicalXML(this.fragmentParser, ref3, true);
            if (outxml3 != null && refxml3 != null && !outxml3.equals(refxml3)) {
                if (!silent) {
                    this.log.println("Mismatch with reference results: " + outfile);
                    this.log.println("REFERENCE RESULTS:");
                    this.log.println(XQueryTestSuiteDriver.truncate(refxml2));
                    this.log.println("ACTUAL RESULTS:");
                    this.log.println(XQueryTestSuiteDriver.truncate(outxml2));
                    this.findDiff(refxml2, outxml2);
                }
                return false;
            }
            this.log.println("Matches after stripping whitespace");
            return true;
        }
        if (outxml2 == null) {
            this.log.println("Cannot canonicalize actual results");
            return false;
        }
        if (refxml2 == null) {
            this.log.println("Cannot canonicalize reference results");
            return false;
        }
        return true;
    }

    private static String truncate(String s) {
        if (s.length() > 200) {
            return s.substring(0, 200);
        }
        return s;
    }

    private void findDiff(String s1, String s2) {
        FastStringBuffer sb1 = new FastStringBuffer(s1.length());
        sb1.append(s1);
        FastStringBuffer sb2 = new FastStringBuffer(s2.length());
        sb2.append(s2);
        int i = 0;
        while (true) {
            if (s1.charAt(i) != s2.charAt(i)) {
                int j = i < 50 ? 0 : i - 50;
                int k = i + 50 > s1.length() || i + 50 > s2.length() ? i + 1 : i + 50;
                this.log.println("Different at char " + i + "\n+" + s1.substring(j, k) + "\n+" + s2.substring(j, k));
                break;
            }
            if (i >= s1.length() || i >= s2.length()) break;
            ++i;
        }
    }

    private void writeResultFilePreamble(Configuration config, String date) throws IOException, XPathException, XMLStreamException {
        BufferedWriter resultWriter = new BufferedWriter(new FileWriter(new File(this.saxonDir, "/results" + Version.getProductVersion() + ".xml")));
        Properties resultProperties = new Properties();
        resultProperties.setProperty("method", "xml");
        resultProperties.setProperty("indent", "yes");
        resultProperties.setProperty("{http://saxon.sf.net/}line-length", "120");
        this.results = config.getSerializerFactory().getXMLStreamWriter(new StreamResult(resultWriter), resultProperties);
        this.results.writeStartElement("test-suite-result");
        this.results.writeDefaultNamespace("http://www.w3.org/2005/02/query-test-XQTSResult");
        this.outputImplementationDetails();
        this.results.writeStartElement("syntax");
        this.results.writeCharacters("XQuery");
        this.results.writeEndElement();
        this.outputRunDetails(date);
    }

    private void outputImplementationDetails() throws IOException, XMLStreamException {
        this.results.writeStartElement("implementation");
        this.results.writeAttribute("name", "Saxon-EE");
        this.results.writeAttribute("version", Version.getProductVersion());
        this.results.writeAttribute("anonymous-result-column", "false");
        this.results.writeEmptyElement("organization");
        this.results.writeAttribute("name", "Saxonica");
        this.results.writeAttribute("website", "http://www.saxonica.com/");
        this.results.writeAttribute("anonymous", "false");
        this.results.writeEmptyElement("submittor");
        this.results.writeAttribute("name", "Michael Kay");
        this.results.writeAttribute("title", "Director");
        this.results.writeAttribute("email", "mike@saxonica.com");
        this.results.writeEmptyElement("description");
        this.outputImplementationDefinedItems();
        this.outputFeatures();
        this.results.writeEndElement();
    }

    private void outputImplementationDefinedItems() throws XMLStreamException {
        this.results.writeStartElement("implementation-defined-items");
        this.outputIDI("expressionUnicode", "Whatever is supported by the Java JDK in use");
        this.outputIDI("collations", "URIs corresponding to RuleBasedCollators that can be constructed by the Java VM, plus any user-defined collations whose implementation is on the Java classpath");
        this.outputIDI("implicitTimezone", "Taken from the system clock. For this test run, +01:00");
        this.outputIDI("warningsMethod", "Controlled using the JAXP-defined ErrorListener interface.");
        this.outputIDI("errorsMethod", "Errors are reported using the JAXP ErrorListener interface.");
        this.outputIDI("XMLVersion", "XML 1.0 or 1.1 can be selected under user control.");
        this.outputIDI("overwrittenContextComponents", "None");
        this.outputIDI("axes", "All the axes are supported.");
        this.outputIDI("defaultOrderEmpty", "By default, empty collates least.");
        this.outputIDI("pragmas", "The saxon:validate-type pragma validates an expression against a named simple or complex type");
        this.outputIDI("optionDeclarations", "saxon:default declares default values for external variables. saxon:memo-function declares functions that are to be implemented as memo-functions.  saxon:output declares serialization parameters. For detailed semantics, see the user documentation.");
        this.outputIDI("externalFunctionProtocols", "Saxon supports calls on external Java methods. There is a plug-in architecture allowing additional external function libraries and binding mechanisms to be supported by third parties.");
        this.outputIDI("moduleLocationHints", "An actual URI for the location of the module source code must be provided in the import declaration, or via a ModuleURIResolver nominated using the Java API");
        this.outputIDI("staticTypingExtensions", "Saxon does not support strict static typing, although it does report type errors at compile time if they can be detected at compile time.");
        this.outputIDI("serializationInvocation", "Saxon supports a Java API that gives full access to serialization, reusing parts of the JAXP API where appropriate.");
        this.outputIDI("serializationDefaults", "As described in the XQuery specification (but if running from the command line, indent=yes is set by default)");
        this.outputIDI("externalFunctionCall", "An unsuccessful call to an external function results in a dynamic error");
        this.outputIDI("limits", "Documented in the detailed conformance documentation");
        this.outputIDI("traceDestination", "If a TraceListener is registered, the trace output is sent to the TraceListener. Otherwise it is sent as text to System.err.");
        this.outputIDI("integerOperations", "Saxon supports unlimited-precision integer arithmetic");
        this.outputIDI("decimalDigits", "Saxon implements arbitrary-precision decimal arithmetic. The default precision for division is 18 digits, but this is configurable.");
        this.outputIDI("roundOrTruncate", "Not applicable, since Saxon supports indefinite precision.");
        this.outputIDI("Unicode", "Saxon validates that characters in strings and names are as permitted by XML 1.0 (or XML 1.1 at user option), unless the value thas already been validated by an XML parser, in which case it depends on the user's choice of parser");
        this.outputIDI("normalizationForms", "Saxon supports NFC, NFD, NFKC, and NFKD.");
        this.outputIDI("collationUnits", "All collations based on Java's RuleBasedCollator have this property. User-defined collations may or may non have this property.");
        this.outputIDI("secondsDigits", "Saxon supports 4 digits for the year and 6 digits for fractional seconds on dateTimes and durations.");
        this.outputIDI("stringToDecimal", "Not applicable, since Saxon supports arbitrary-precision decimal numbers");
        this.outputIDI("weakenStable", "Saxon provides an extension function saxon:discard-document() that removes a document from the stable set. It also allows a user-defined collection URI resolver to return an unstable collection.");
        this.outputIDI("additionalTypes", "Saxon allows any Java object to be wrapped as an XPath item, and defines a mapping of Java class names to XPath type names so that such objects carry full dynamic type information with them.");
        this.outputIDI("undefinedProperties", "Access to undefined values is an error.");
        this.outputIDI("sequenceNormalization", "Sequences are always normalized to documents before the serializer is invoked. However, the Java application may change the way in which a result sequence is converted to a document before invoking the serializer.");
        this.outputIDI("outputMethods", "Saxon allows a user-specified serialization class to be nominated using this mechanism. The class may be a SAX ContentHandler or a Saxon Receiver.");
        this.outputIDI("normalizationFormBehavior", "Any normalization form other than NFC, NFD, NFKC, or NFKD is treated as an error.");
        this.outputIDI("additionalParams", "Saxon supports a number of additional serialization parameters in the namespace http://saxon.sf.net/.  These include saxon:indent-spaces, saxon:character-representation, saxon:require-well-formed, and saxon:next-in-chain");
        this.outputIDI("encodingPhase", "Saxon allows the serialization destination to be a Java Writer (a character stream) rather than a byte  stream.");
        this.outputIDI("CDATASerialization", "Saxon provides the standard cdata-section-elements mechanism only.");
        this.results.writeEndElement();
    }

    private void outputIDI(String name, String value) throws XMLStreamException {
        this.results.writeEmptyElement("implementation-defined-item");
        this.results.writeAttribute("name", name);
        this.results.writeAttribute("value", value);
    }

    private void outputFeatures() throws XMLStreamException {
        this.results.writeStartElement("features");
        this.outputFeature("MinimalConformance", true);
        this.outputFeature("Schema Import", true);
        this.outputFeature("Schema Validation", true);
        this.outputFeature("Static Typing", false);
        this.outputFeature("Static Typing Extensions", false);
        this.outputFeature("Full Axis", true);
        this.outputFeature("Module", true);
        this.results.writeEndElement();
    }

    private void outputFeature(String name, boolean supported) throws XMLStreamException {
        this.results.writeEmptyElement("feature");
        this.results.writeAttribute("name", name);
        this.results.writeAttribute("supported", supported ? "true" : "false");
    }

    private void outputRunDetails(String date) throws XMLStreamException {
        this.results.writeStartElement("test-run");
        this.results.writeAttribute("dateRun", date);
        this.results.writeEmptyElement("test-suite");
        this.results.writeAttribute("version", this.catalogVersion);
        this.results.writeEmptyElement("transformation");
        this.results.writeEmptyElement("comparison");
        this.results.writeEmptyElement("otherComments");
        this.results.writeEndElement();
    }

    private String lowercase(String name) {
        FastStringBuffer sb = new FastStringBuffer(name.length());
        name = name.toLowerCase();
        for (int p = 0; p < name.length(); ++p) {
            char c = name.charAt(p);
            if ((c < 'a' || c > 'z') && (c < '0' || c > '9')) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private String makeClassName(String groupName, String mainName) {
        FastStringBuffer sb = new FastStringBuffer(mainName.length());
        sb.append(groupName);
        sb.append(".");
        mainName = mainName.substring(0, 1).toUpperCase() + mainName.substring(1).toLowerCase();
        sb.append(mainName);
        return sb.toString();
    }

    private String normalizeNewlines(String in) {
        return in.replace("\r\n", "\n");
    }

    static {
        noCacheTests.add("schemainline20_005_01");
        canon = new CanonicalXML();
    }

    private class MyErrorListener
    extends StandardErrorListener {
        public String errorCode;

        public MyErrorListener(PrintStream log) {
            this.setErrorOutput(log);
        }

        public void error(TransformerException exception) throws TransformerException {
            if (exception instanceof XPathException) {
                String code = ((XPathException)exception).getErrorCodeLocalPart();
                if (code != null) {
                    this.errorCode = code;
                }
                if ("FODC0005".equals(this.errorCode)) {
                    this.fatalError(exception);
                }
            }
            super.error(exception);
        }

        public void fatalError(TransformerException exception) throws TransformerException {
            String code;
            if (exception instanceof XPathException && (code = ((XPathException)exception).getErrorCodeLocalPart()) != null) {
                this.errorCode = code;
            }
            super.fatalError(exception);
        }

        public void warning(TransformerException exception) throws TransformerException {
            if (XQueryTestSuiteDriver.this.showWarnings) {
                super.warning(exception);
            }
        }

        public StandardErrorListener makeAnother(int hostLanguage) {
            return new MyErrorListener(XQueryTestSuiteDriver.this.log);
        }
    }
}

