/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.testdriver;

import java.util.ArrayList;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.lib.ModuleURIResolver;
import net.sf.saxon.lib.StandardModuleURIResolver;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;

public class XQTSModuleURIResolver
implements ModuleURIResolver {
    public NodeInfo testCase;
    public NodeInfo catalogTop;

    public XQTSModuleURIResolver(NodeInfo testCase) {
        NodeInfo p;
        this.testCase = testCase;
        this.catalogTop = testCase;
        while ((p = this.catalogTop.getParent()).getNodeKind() == 1) {
            this.catalogTop = p;
        }
    }

    public StreamSource[] resolve(String moduleURI, String baseURI, String[] locations) throws XPathException {
        NodeInfo m;
        NamePool pool = this.testCase.getNamePool();
        int moduleNC = pool.allocate("", "http://www.w3.org/2005/02/query-test-XQTSCatalog", "module");
        int namespaceNC = pool.allocate("", "", "namespace");
        AxisIterator iter = this.testCase.iterateAxis((byte)3, new NameTest(1, moduleNC, pool));
        ArrayList<String> catalogLocations = new ArrayList<String>(5);
        while ((m = (NodeInfo)iter.next()) != null) {
            if (!moduleURI.equals(m.getAttributeValue(namespaceNC))) continue;
            String moduleRef = m.getStringValue();
            if (moduleRef.equals("module-defs")) {
                moduleRef = "moduleDefs-lib";
            }
            moduleRef = "TestSources/" + moduleRef + ".xq";
            catalogLocations.add(moduleRef);
        }
        if (catalogLocations.isEmpty()) {
            StandardModuleURIResolver r = StandardModuleURIResolver.getInstance();
            return r.resolve(moduleURI, baseURI, locations);
        }
        String[] locs = new String[catalogLocations.size()];
        for (int i = 0; i < locs.length; ++i) {
            locs[i] = (String)catalogLocations.get(i);
        }
        StandardModuleURIResolver r = StandardModuleURIResolver.getInstance();
        return r.resolve(moduleURI, this.catalogTop.getBaseURI(), locs);
    }
}

