/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.testdriver;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.testdriver.CanonicalXML;
import com.saxonica.testdriver.XQTSCollectionURIResolver;
import com.saxonica.testdriver.XQTSModuleURIResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.Version;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.SequenceExtent;
import org.w3c.tidy.Tidy;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class UpdateTestSuiteDriver {
    private String testSuiteDir;
    private String saxonDir;
    private EnterpriseConfiguration saConfig;
    private XMLReader resultParser;
    private XMLReader fragmentParser;
    private boolean usePull = false;
    private Pattern testPattern = null;
    private boolean showWarnings = false;
    private boolean compile = false;
    private boolean onwards = false;
    private boolean unfolded = false;
    private boolean runCompiled = false;
    private HashMap sourceIndex = new HashMap(50);
    private HashMap uriMap = new HashMap(50);
    private TransformerFactory tfactory = new TransformerFactoryImpl();
    private Writer results;
    private Writer compileScript = null;
    private HashSet directories = new HashSet(200);
    private PrintStream monitor = System.err;
    private PrintStream log;
    static HashSet noCacheTests = new HashSet(30);
    static CanonicalXML canon;
    Templates xhtmlCanonizer;

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args[0].equals("-?")) {
            System.err.println("UpdateTestSuiteDriver testsuiteDir saxonDir [testNamePattern] [-compile] [-runcomp] [-w] [-onwards] [-unfold] [-pull]");
        }
        System.err.println("Testing Saxon " + Version.getProductVersion());
        new UpdateTestSuiteDriver().go(args);
    }

    private NameTest elementNameTest(NamePool pool, String local) {
        int nameFP = pool.allocate("", "http://www.w3.org/2005/02/query-test-update", local) & 0xFFFFF;
        return new NameTest(1, nameFP, pool);
    }

    private NodeInfo getChildElement(NodeInfo parent, NameTest child) {
        return (NodeInfo)parent.iterateAxis((byte)3, child).next();
    }

    public void go(String[] args) throws SAXException, ParserConfigurationException {
        this.testSuiteDir = args[0];
        this.saxonDir = args[1];
        HashSet<Object> exceptions = new HashSet<Object>();
        for (int i = 2; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if (args[i].equals("-w")) {
                    this.showWarnings = true;
                    continue;
                }
                if (args[i].equals("-compile")) {
                    this.compile = true;
                    continue;
                }
                if (args[i].equals("-onwards")) {
                    this.onwards = true;
                    continue;
                }
                if (args[i].equals("-runcomp")) {
                    this.runCompiled = true;
                    continue;
                }
                if (args[i].equals("-unfold")) {
                    this.unfolded = true;
                    continue;
                }
                if (!args[i].equals("-pull")) continue;
                this.usePull = true;
                continue;
            }
            this.testPattern = Pattern.compile(args[i]);
        }
        try {
            NodeInfo testCase;
            NodeInfo schemaElement;
            NodeInfo testCase2;
            NamePool pool = new NamePool();
            this.saConfig = new EnterpriseConfiguration();
            this.saConfig.setNamePool(pool);
            this.saConfig.setHostLanguage(51);
            this.saConfig.setTreeModel(0);
            this.saConfig.setConfigurationProperty("http://saxon.sf.net/feature/xquerySchemaAware", true);
            XMLReader parser = this.saConfig.getSourceParser();
            boolean supports11 = false;
            try {
                supports11 = parser.getFeature("http://xml.org/sax/features/xml-1.1");
            }
            catch (Exception err) {
                // empty catch block
            }
            if (!supports11) {
                this.monitor.println("Warning: XML parser does not support XML 1.1 - " + parser.getClass());
            }
            this.resultParser = this.saConfig.getSourceParser();
            this.resultParser.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) {
                    return new InputSource(new StringReader(""));
                }
            });
            this.fragmentParser = this.saConfig.getSourceParser();
            this.results = new FileWriter(new File(this.saxonDir + "/results" + Version.getProductVersion() + ".xml"));
            this.log = new PrintStream(new FileOutputStream(new File(this.saxonDir + "/results" + Version.getProductVersion() + ".log")));
            MyErrorListener errorListener = new MyErrorListener(this.log);
            this.saConfig.setErrorListener(errorListener);
            NameTest testCaseNT = this.elementNameTest(pool, "test-case");
            NameTest inputUriNT = this.elementNameTest(pool, "input-URI");
            NameTest inputFileNT = this.elementNameTest(pool, "input-file");
            NameTest queryNT = this.elementNameTest(pool, "query");
            NameTest stateNT = this.elementNameTest(pool, "state");
            NameTest inputQueryNT = this.elementNameTest(pool, "input-query");
            NameTest contextItemNT = this.elementNameTest(pool, "contextItem");
            NameTest outputFileNT = this.elementNameTest(pool, "output-file");
            NameTest sourceNT = this.elementNameTest(pool, "source");
            NameTest schemaNT = this.elementNameTest(pool, "schema");
            NameTest expectedErrorNT = this.elementNameTest(pool, "expected-error");
            NameTest collectionNT = this.elementNameTest(pool, "collection");
            NameTest defaultCollectionNT = this.elementNameTest(pool, "defaultCollection");
            NameTest optimizationNT = this.elementNameTest(pool, "optimization");
            int schemaAtt = pool.allocate("", "", "schema") & 0xFFFFF;
            int nameAtt = pool.allocate("", "", "name") & 0xFFFFF;
            int filePathAtt = pool.allocate("", "", "FilePath") & 0xFFFFF;
            int fileNameAtt = pool.allocate("", "", "FileName") & 0xFFFFF;
            int idAtt = pool.allocate("", "", "ID") & 0xFFFFF;
            int compareAtt = pool.allocate("", "", "compare") & 0xFFFFF;
            int variableAtt = pool.allocate("", "", "variable") & 0xFFFFF;
            int scenarioAtt = pool.allocate("", "", "scenario") & 0xFFFFF;
            int explainAtt = pool.allocate("", "", "explain") & 0xFFFFF;
            int assertAtt = pool.allocate("", "", "assert") & 0xFFFFF;
            DocumentInfo exceptionsDoc = this.saConfig.buildDocument(new StreamSource(new File(this.saxonDir + "/exceptions.xml")));
            NameTest exceptionTestsNT = new NameTest(1, pool.allocate("", "", "tests"), pool);
            AxisIterator exceptionTestCases = exceptionsDoc.iterateAxis((byte)4, exceptionTestsNT);
            while ((testCase2 = (NodeInfo)exceptionTestCases.next()) != null) {
                String name = testCase2.getStringValue();
                StringTokenizer tok = new StringTokenizer(name);
                while (tok.hasMoreElements()) {
                    exceptions.add(tok.nextElement());
                }
            }
            DocumentInfo catalog = this.saConfig.buildDocument(new StreamSource(new File(this.testSuiteDir + "/XQUTSCatalog.xml")));
            Properties outputProps = new Properties();
            outputProps.setProperty("method", "xml");
            outputProps.setProperty("indent", "no");
            outputProps.setProperty("omit-xml-declaration", "yes");
            this.results.write("<test-suite-result xmlns='http://www.w3.org/2005/02/query-test-XQTSResult'>\n");
            this.results.write(" <implementation name='Saxon-EE' version='" + Version.getProductVersion() + "' anonymous-result-column='false'>\n");
            this.results.write("  <organization name='Saxonica' website='http://www.saxonica.com/' anonymous='false'/>\n");
            this.results.write("  <submittor name='Michael Kay' title='Director' email='mike@saxonica.com'/>\n");
            this.results.write("  <description><p>Saxon-EE implements XQuery Update from release 9.1 onwards</p></description>\n");
            this.outputDiscretionaryItems();
            this.results.write(" </implementation>\n");
            this.results.write(" <syntax>XQuery</syntax>");
            this.results.write(" <test-run dateRun='" + this.currentDate() + "'>\n");
            this.results.write("   <test-suite version='CVS'/>\n");
            this.results.write("   <transformation><p>Standard</p></transformation>\n");
            this.results.write("   <comparison><p>Standard</p></comparison>\n");
            this.results.write("   <otherComments><p>None</p></otherComments>\n");
            this.results.write(" </test-run>\n");
            AxisIterator schemas = catalog.iterateAxis((byte)4, schemaNT);
            while ((schemaElement = (NodeInfo)schemas.next()) != null) {
                String fileName = schemaElement.getAttributeValue(fileNameAtt);
                this.monitor.println("Loading schema " + fileName);
                StreamSource ss = new StreamSource(new File(this.testSuiteDir + "/" + fileName));
                this.saConfig.addSchemaSource(ss);
            }
            if (!this.compile) {
                NodeInfo sourceElement;
                AxisIterator sources = catalog.iterateAxis((byte)4, sourceNT);
                while ((sourceElement = (NodeInfo)sources.next()) != null) {
                    String schema = sourceElement.getAttributeValue(schemaAtt);
                    String id = sourceElement.getAttributeValue(idAtt);
                    this.sourceIndex.put(id, sourceElement);
                }
            }
            AxisIterator testCases = catalog.iterateAxis((byte)4, testCaseNT);
            boolean groupsize = false;
            Object prevGroup = null;
            while ((testCase = (NodeInfo)testCases.next()) != null) {
                NodeInfo state;
                NodeInfo state2;
                File putOutput2;
                String testName = testCase.getAttributeValue(nameAtt);
                boolean optimizationOK = true;
                if (this.testPattern != null && !this.testPattern.matcher(testName).matches()) continue;
                if (this.onwards) {
                    this.testPattern = null;
                }
                if (exceptions.contains(testName) || this.isExcluded(testName)) continue;
                this.monitor.println("Test " + testName);
                this.log.println("Test " + testName);
                String filePath = testCase.getAttributeValue(filePathAtt);
                File putOutput = new File(this.testSuiteDir + "/TestSources/putOutput.xml");
                if (putOutput.exists() && !putOutput.delete()) {
                    System.err.println("Failed to delete file " + putOutput.getAbsolutePath());
                }
                if ((putOutput2 = new File(this.testSuiteDir + "/TestSources/putOutput2.xml")).exists() && !putOutput2.delete()) {
                    System.err.println("Failed to delete file " + putOutput2.getAbsolutePath());
                }
                AxisIterator states = testCase.iterateAxis((byte)3, stateNT);
                HashMap<String, NodeInfo> updatedDocuments = new HashMap<String, NodeInfo>();
                int numberOfStates = 0;
                while ((state2 = (NodeInfo)states.next()) != null) {
                    ++numberOfStates;
                }
                states = (AxisIterator)states.getAnother();
                int stateNumber = 0;
                while ((state = (NodeInfo)states.next()) != null) {
                    Set affected;
                    String docName;
                    XQueryExpression xqe;
                    ++stateNumber;
                    NodeInfo query = this.getChildElement(state, queryNT);
                    String queryName = query.getAttributeValue(nameAtt);
                    String absQueryName = this.testSuiteDir + "/Queries/" + (this.unfolded ? "XQUnfolded/" : "XQuery/") + filePath + queryName + ".xq";
                    String outputFile = null;
                    StaticQueryContext env = this.saConfig.newStaticQueryContext();
                    env.setUpdatingEnabled(true);
                    env.setModuleURIResolver(new XQTSModuleURIResolver(testCase));
                    env.setBaseURI(new File(absQueryName).toURI().toString());
                    try {
                        xqe = env.compileQuery(new FileInputStream(absQueryName), "UTF-8");
                    }
                    catch (XPathException err) {
                        this.processError(err, state, testName, expectedErrorNT, stateNumber == numberOfStates);
                        continue;
                    }
                    NodeInfo optElement = this.getChildElement(state, optimizationNT);
                    if (optElement != null) {
                        String assertion;
                        String explain = optElement.getAttributeValue(explainAtt);
                        if ("true".equals(explain) || "1".equals(explain)) {
                            ExpressionPresenter presenter = new ExpressionPresenter(this.saConfig);
                            xqe.explain(presenter);
                            presenter.close();
                        }
                        if ((assertion = optElement.getAttributeValue(assertAtt)) != null) {
                            TinyBuilder builder = new TinyBuilder();
                            builder.setPipelineConfiguration(this.saConfig.makePipelineConfiguration());
                            ExpressionPresenter presenter = new ExpressionPresenter((Configuration)this.saConfig, builder);
                            xqe.explain(presenter);
                            presenter.close();
                            NodeInfo expressionTree = builder.getCurrentRoot();
                            XPathEvaluator xpe = new XPathEvaluator(this.saConfig);
                            XPathExpression exp = xpe.createExpression(assertion);
                            Boolean bv = (Boolean)exp.evaluateSingle(expressionTree);
                            if (!bv.booleanValue()) {
                                this.log.println("** Optimization assertion failed");
                                optimizationOK = false;
                            }
                        }
                    }
                    DynamicQueryContext dqc = new DynamicQueryContext(this.saConfig);
                    NodeInfo contextItemElement = this.getChildElement(state, contextItemNT);
                    if (contextItemElement != null && !(docName = contextItemElement.getStringValue()).startsWith("putOutput")) {
                        DocumentInfo contextNode = this.loadDocument(docName);
                        dqc.setContextItem(contextNode);
                    }
                    this.processInputQueries(state, inputQueryNT, variableAtt, nameAtt, filePath, dqc);
                    this.processInputDocuments(state, inputFileNT, variableAtt, dqc, updatedDocuments);
                    this.setQueryParameters(catalog, state, dqc, inputUriNT, variableAtt, collectionNT, idAtt);
                    NodeInfo defaultCollection = this.getChildElement(state, defaultCollectionNT);
                    if (defaultCollection != null) {
                        String docName2 = defaultCollection.getStringValue();
                        NodeInfo collectionElement = this.getCollectionElement(catalog, docName2, collectionNT, idAtt);
                        XQTSCollectionURIResolver r = new XQTSCollectionURIResolver(catalog, collectionElement, true);
                        this.saConfig.setCollectionURIResolver(r);
                    }
                    String suffix = null;
                    AxisIterator expectedResults = state.iterateAxis((byte)3, outputFileNT);
                    NodeInfo outputFileElement = (NodeInfo)expectedResults.next();
                    if (outputFileElement != null) {
                        String outputFileName = outputFileElement.getStringValue();
                        int lastDot = outputFileName.lastIndexOf(46);
                        suffix = outputFileName.substring(lastDot);
                    }
                    if (suffix == null) {
                        suffix = ".out";
                    }
                    String localOutputFile = testName + suffix;
                    String outputDir = this.saxonDir + "/results/" + filePath;
                    if (outputDir.endsWith("/")) {
                        outputDir = outputDir.substring(0, outputDir.length() - 1);
                    }
                    new File(outputDir).mkdirs();
                    outputFile = outputDir + '/' + localOutputFile;
                    File outputFileF = new File(outputFile);
                    outputFileF.createNewFile();
                    StreamResult result = new StreamResult(outputFileF);
                    try {
                        if (xqe.isUpdateQuery()) {
                            affected = xqe.runUpdate(dqc);
                        } else {
                            xqe.run(dqc, result, outputProps);
                            affected = Collections.EMPTY_SET;
                        }
                    }
                    catch (XPathException err) {
                        this.processError(err, state, testName, expectedErrorNT, stateNumber == numberOfStates);
                        continue;
                    }
                    for (NodeInfo affectedDoc : affected) {
                        String uri = affectedDoc.getSystemId();
                        if (uri == null) continue;
                        updatedDocuments.put(uri, affectedDoc);
                    }
                    boolean resultsMatched = false;
                    String possibleMatch = null;
                    expectedResults = state.iterateAxis((byte)3, outputFileNT);
                    boolean multipleResults = false;
                    SequenceIterator ccc = expectedResults.getAnother();
                    ccc.next();
                    if (ccc.next() != null) {
                        multipleResults = true;
                    }
                    boolean foundExpectedResults = false;
                    while ((outputFileElement = (NodeInfo)expectedResults.next()) != null) {
                        foundExpectedResults = true;
                        String resultsDir = this.testSuiteDir + "/ExpectedTestResults/" + filePath;
                        String resultsPath = resultsDir + outputFileElement.getStringValue();
                        String comparisonMethod = outputFileElement.getAttributeValue(compareAtt);
                        String comparisonResult = comparisonMethod.equals("Ignore") ? "true" : this.compare(outputFile, resultsPath, comparisonMethod, multipleResults);
                        if (comparisonResult.equals("true")) {
                            resultsMatched = true;
                            break;
                        }
                        if (comparisonResult.equals("false")) continue;
                        possibleMatch = comparisonResult;
                    }
                    if (stateNumber != numberOfStates) continue;
                    if (resultsMatched) {
                        this.results.write("  <test-case name='" + testName + "' result='pass'" + (optimizationOK ? "" : " comment='check optimization'") + "/>\n");
                        continue;
                    }
                    if (multipleResults) {
                        this.log.println("*** Failed to match any of the permitted results");
                    }
                    NodeInfo expectedError = this.getChildElement(state, expectedErrorNT);
                    if (possibleMatch != null) {
                        this.results.write("  <test-case name='" + testName + "' result='pass' comment='" + possibleMatch + "'/>\n");
                        continue;
                    }
                    if (expectedError != null) {
                        this.results.write("  <test-case name='" + testName + "' result='fail' comment='" + "expected " + expectedError.getStringValue() + ", got success'/>\n");
                        continue;
                    }
                    if (!foundExpectedResults) continue;
                    this.results.write("  <test-case name='" + testName + "' result='fail'/>\n");
                }
            }
            this.results.write("</test-suite-result>");
            this.results.close();
            if (this.compile) {
                this.compileScript.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String currentDate() {
        return DateTimeValue.getCurrentDateTime(null).getStringValue().substring(0, 10);
    }

    private void setQueryParameters(DocumentInfo catalog, NodeInfo testCase, DynamicQueryContext dqc, NameTest inputUriNT, int variableAtt, NameTest collectionNT, int idAtt) throws XPathException {
        NodeInfo inputURI;
        AxisIterator inputURIs = testCase.iterateAxis((byte)3, inputUriNT);
        while ((inputURI = (NodeInfo)inputURIs.next()) != null) {
            String uri;
            String variableName = inputURI.getAttributeValue(variableAtt);
            if ((variableName = UpdateTestSuiteDriver.toClarkName(variableName)) == null) continue;
            String docName = inputURI.getStringValue();
            if (docName.startsWith("putOutput")) {
                uri = new File(this.testSuiteDir + "/TestSources/" + docName + ".xml").toURI().toString();
                dqc.setParameterValue(variableName, new AnyURIValue(uri));
                continue;
            }
            if (docName.startsWith("collection")) {
                NodeInfo collectionElement = this.getCollectionElement(catalog, docName, collectionNT, idAtt);
                XQTSCollectionURIResolver r = new XQTSCollectionURIResolver(catalog, collectionElement, false);
                this.saConfig.setCollectionURIResolver(r);
                dqc.setParameterValue(variableName, new AnyURIValue(docName));
                continue;
            }
            uri = this.loadDocument(docName).getSystemId();
            dqc.setParameterValue(variableName, new AnyURIValue(uri));
        }
    }

    private void processInputDocuments(NodeInfo state, NameTest inputFileNT, int variableAtt, DynamicQueryContext dqc, HashMap updatedDocuments) throws XPathException {
        NodeInfo inputFile;
        AxisIterator inputFiles = state.iterateAxis((byte)3, inputFileNT);
        while ((inputFile = (NodeInfo)inputFiles.next()) != null) {
            String fileId = inputFile.getStringValue();
            String variableName = inputFile.getAttributeValue(variableAtt);
            if ((variableName = UpdateTestSuiteDriver.toClarkName(variableName)) == null) continue;
            DocumentInfo inputDoc = null;
            String uri = (String)this.uriMap.get(fileId);
            if (uri != null) {
                inputDoc = (DocumentInfo)updatedDocuments.get(uri);
            }
            if (inputDoc == null) {
                inputDoc = this.loadDocument(fileId);
            }
            dqc.setParameterValue(variableName, inputDoc);
        }
    }

    private void processInputQueries(NodeInfo testCase, NameTest inputQueryNT, int variableAtt, int nameAtt, String filePath, DynamicQueryContext dqc) throws XPathException, IOException {
        NodeInfo inputQuery;
        AxisIterator inputQueries = testCase.iterateAxis((byte)3, inputQueryNT);
        while ((inputQuery = (NodeInfo)inputQueries.next()) != null) {
            String variableName = inputQuery.getAttributeValue(variableAtt);
            if ((variableName = UpdateTestSuiteDriver.toClarkName(variableName)) == null) continue;
            String preQueryName = inputQuery.getAttributeValue(nameAtt);
            String subQueryFile = this.testSuiteDir + "/Queries/XQuery/" + filePath + preQueryName + ".xq";
            StaticQueryContext sqc2 = this.saConfig.newStaticQueryContext();
            XQueryExpression subQuery = sqc2.compileQuery(new FileReader(subQueryFile));
            SequenceIterator subQueryResult = subQuery.iterator(new DynamicQueryContext(this.saConfig));
            dqc.setParameterValue(variableName, SequenceExtent.makeSequenceExtent(subQueryResult));
        }
    }

    private NodeInfo getCollectionElement(DocumentInfo catalog, String docName, NameTest collectionNT, int idAtt) {
        NodeInfo coll;
        NodeInfo collectionElement = null;
        AxisIterator colls = catalog.iterateAxis((byte)4, collectionNT);
        while ((coll = (NodeInfo)colls.next()) != null) {
            if (!docName.equals(coll.getAttributeValue(idAtt))) continue;
            collectionElement = coll;
        }
        return collectionElement;
    }

    protected boolean isExcluded(String testName) {
        return testName.startsWith("dotnet") || testName.startsWith("stf-");
    }

    private static String toClarkName(String variableName) {
        if (variableName == null) {
            return null;
        }
        if (variableName.startsWith("local:")) {
            return "{http://www.w3.org/2005/xquery-local-functions}" + variableName.substring(6);
        }
        return variableName;
    }

    private DocumentInfo loadDocument(String id) throws XPathException {
        NodeInfo sourceElement = (NodeInfo)this.sourceIndex.get(id);
        String schema = Navigator.getAttributeValue(sourceElement, "", "schema");
        String fileName = Navigator.getAttributeValue(sourceElement, "", "FileName");
        StreamSource ss = new StreamSource(new File(this.testSuiteDir + "/" + fileName));
        ParseOptions options = new ParseOptions();
        if (schema != null) {
            options.setSchemaValidationMode(1);
        }
        DocumentInfo doc = this.saConfig.buildDocument(ss, options);
        this.uriMap.put(id, doc.getSystemId());
        return doc;
    }

    private void processError(XPathException err, NodeInfo state, String testName, NameTest expectedErrorNT, boolean reportResult) throws IOException {
        NodeInfo expectedError;
        String actualError = err.getErrorCodeLocalPart();
        AxisIterator expectedErrors = state.iterateAxis((byte)3, expectedErrorNT);
        FastStringBuffer expected = new FastStringBuffer(20);
        while ((expectedError = (NodeInfo)expectedErrors.next()) != null) {
            if (expectedError.getStringValue().equals(actualError)) {
                if (reportResult) {
                    this.results.write("  <test-case name='" + testName + "' result='pass'/>\n");
                }
                return;
            }
            expected.append(expectedError.getStringValue());
            expected.append(" ");
        }
        if (!reportResult) {
            FastStringBuffer fsb = new FastStringBuffer(20);
            fsb.append("-");
            state.generateId(fsb);
            testName = testName + fsb.toString();
        }
        if (expected.length() > 0) {
            this.results.write("  <test-case name='" + testName + "' result='pass'" + " comment='expected " + expected + ", got " + actualError + "'/>\n");
        } else {
            this.results.write("  <test-case name='" + testName + "' result='fail'" + " comment='expected success, got " + actualError + "'/>\n");
        }
    }

    private String compare(String outfile, String reffile, String comparator, boolean silent) {
        if (reffile == null) {
            this.log.println("*** No reference results available");
            return "false";
        }
        File outfileFile = new File(outfile);
        File reffileFile = new File(reffile);
        if (!reffileFile.exists()) {
            this.log.println("*** No reference results available");
            return "false";
        }
        String refResult = null;
        String actResult = null;
        try {
            FileReader reader1 = new FileReader(outfileFile);
            FileReader reader2 = new FileReader(reffileFile);
            char[] contents1 = new char[(int)outfileFile.length()];
            char[] contents2 = new char[(int)reffileFile.length()];
            int size1 = reader1.read(contents1, 0, (int)outfileFile.length());
            int size2 = reader2.read(contents2, 0, (int)reffileFile.length());
            int offset1 = 0;
            int offset2 = 0;
            if (contents1[0] == '\u00ef' && contents1[1] == '\u00bb' && contents1[2] == '\u00bf') {
                offset1 += 3;
            }
            if (contents2[0] == '\u00ef' && contents2[1] == '\u00bb' && contents2[2] == '\u00bf') {
                offset2 += 3;
            }
            actResult = size1 == -1 ? "" : new String(contents1, offset1, size1 - offset1);
            refResult = size2 == -1 ? "" : new String(contents2, offset2, size2 - offset2);
            if ((actResult = this.normalizeNewlines(actResult)).equals(refResult = this.normalizeNewlines(refResult))) {
                return "true";
            }
            if (size1 == 0) {
                if (!silent) {
                    this.log.println("** ACTUAL RESULTS EMPTY; REFERENCE RESULTS LENGTH " + size2);
                }
                return "false";
            }
            if (size2 == 0) {
                if (!silent) {
                    this.log.println("** REFERENCED RESULTS EMPTY; ACTUAL RESULTS LENGTH " + size2);
                }
                return "false";
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (comparator.equals("html-output")) {
            try {
                Tidy tidy = new Tidy();
                tidy.setXmlOut(true);
                tidy.setQuiet(true);
                tidy.setShowWarnings(false);
                tidy.setCharEncoding(3);
                FileInputStream in1 = new FileInputStream(outfile);
                File xml1 = new File(outfile + ".xml");
                xml1.createNewFile();
                FileOutputStream out1 = new FileOutputStream(xml1);
                tidy.parse((InputStream)in1, (OutputStream)out1);
                FileInputStream in2 = new FileInputStream(reffile);
                File xml2 = new File(reffile + ".xml");
                xml2.createNewFile();
                FileOutputStream out2 = new FileOutputStream(xml2);
                tidy.parse((InputStream)in2, (OutputStream)out2);
                return this.compare(xml1.toString(), xml2.toString(), "xml", silent);
            }
            catch (IOException e) {
                e.printStackTrace();
                return "false";
            }
        }
        if (comparator.equals("xhtml-output")) {
            refResult = this.canonizeXhtml(refResult);
            actResult = this.canonizeXhtml(actResult);
            return Boolean.toString(actResult.equals(refResult));
        }
        if (comparator.equals("Fragment") || comparator.equals("Text")) {
            try {
                boolean b = false;
                try {
                    b = this.compareFragments2(actResult, refResult, outfile, silent);
                }
                catch (Exception err1) {
                    this.log.println("XQTS: First comparison attempt failed, trying again");
                }
                if (!b) {
                    b = this.compareFragments(outfileFile, reffileFile, outfile, silent);
                }
                return Boolean.toString(b);
            }
            catch (Exception err2) {
                this.log.println("Failed to compare results for: " + outfile);
                err2.printStackTrace();
                return "false";
            }
        }
        if (comparator.equals("Inspect")) {
            this.log.println("** Inspect results by hand");
            return "true";
        }
        try {
            InputSource out = new InputSource(outfileFile.toURL().toString());
            InputSource ref = new InputSource(reffileFile.toURL().toString());
            String outxml = canon.toCanonicalXML2(this.resultParser, out, false);
            String refxml = canon.toCanonicalXML2(this.resultParser, ref, false);
            if (!outxml.equals(refxml)) {
                outxml = canon.toCanonicalXML2(this.resultParser, out, true);
                if (outxml.equals(refxml = canon.toCanonicalXML2(this.resultParser, ref, true))) {
                    this.log.println("*** Match after stripping whitespace nodes: " + outfile);
                    return "*** Match after stripping whitespace nodes";
                }
                if (!silent) {
                    this.log.println("Mismatch with reference results: " + outfile);
                    this.log.println("REFERENCE RESULTS:");
                    this.log.println(UpdateTestSuiteDriver.truncate(refxml));
                    this.log.println("ACTUAL RESULTS:");
                    this.log.println(UpdateTestSuiteDriver.truncate(outxml));
                    this.findDiff(refxml, outxml);
                }
                return "false";
            }
            return "true";
        }
        catch (Exception err) {
            try {
                this.log.println("Failed to compare results for: " + outfile + ": " + err.getMessage());
                this.log.println("** Attempting XML Fragment comparison");
                boolean b = this.compareFragments2(actResult, refResult, outfile, silent);
                this.log.println("** " + (b ? "Success" : "Still different"));
                return Boolean.toString(b);
            }
            catch (Exception err2) {
                this.log.println("Again failed to compare results for: " + outfile);
                err2.printStackTrace();
                return "false";
            }
        }
    }

    private String canonizeXhtml(String input) {
        try {
            Templates canonizer = this.getXhtmlCanonizer();
            Transformer t = canonizer.newTransformer();
            StringWriter sw = new StringWriter();
            StreamResult r = new StreamResult(sw);
            InputSource is = new InputSource(new StringReader(input));
            SAXSource ss = new SAXSource(this.resultParser, is);
            t.transform(ss, r);
            return sw.toString();
        }
        catch (TransformerConfigurationException err) {
            this.log.println("*** Failed to compile XHTML canonicalizer stylesheet");
        }
        catch (TransformerException err) {
            this.log.println("*** Failed while running XHTML canonicalizer stylesheet");
        }
        return "";
    }

    private Templates getXhtmlCanonizer() throws TransformerConfigurationException {
        if (this.xhtmlCanonizer == null) {
            StreamSource source = new StreamSource(new File(this.saxonDir + "/canonizeXhtml.xsl"));
            this.xhtmlCanonizer = this.tfactory.newTemplates(source);
        }
        return this.xhtmlCanonizer;
    }

    private boolean compareFragments(File outfileFile, File reffileFile, String outfile, boolean silent) {
        String outurl = outfileFile.toURI().toString();
        String refurl = reffileFile.toURI().toString();
        String outdoc = "<?xml version='1.1'?><!DOCTYPE doc [ <!ENTITY e SYSTEM '" + outurl + "'>]><doc>&e;</doc>";
        String refdoc = "<?xml version='1.1'?><!DOCTYPE doc [ <!ENTITY e SYSTEM '" + refurl + "'>]><doc>&e;</doc>";
        InputSource out2 = new InputSource(new StringReader(outdoc));
        InputSource ref2 = new InputSource(new StringReader(refdoc));
        String outxml2 = canon.toCanonicalXML(this.fragmentParser, out2, true);
        String refxml2 = canon.toCanonicalXML(this.fragmentParser, ref2, true);
        if (outxml2 != null && refxml2 != null && !outxml2.equals(refxml2)) {
            if (!silent) {
                this.log.println("Mismatch with reference results: " + outfile);
                this.log.println("REFERENCE RESULTS:");
                this.log.println(UpdateTestSuiteDriver.truncate(refxml2));
                this.log.println("ACTUAL RESULTS:");
                this.log.println(UpdateTestSuiteDriver.truncate(outxml2));
                this.findDiff(refxml2, outxml2);
            }
            return false;
        }
        if (outxml2 == null) {
            this.log.println("Cannot canonicalize actual results");
            return false;
        }
        if (refxml2 == null) {
            this.log.println("Cannot canonicalize reference results");
            return false;
        }
        return true;
    }

    private boolean compareFragments2(String outFragment, String refFragment, String outfile, boolean silent) {
        int x;
        if (outFragment == null) {
            outFragment = "";
        }
        if (outFragment.startsWith("<?xml")) {
            x = outFragment.indexOf("?>");
            outFragment = outFragment.substring(x + 2);
        }
        if (refFragment == null) {
            refFragment = "";
        }
        if (refFragment.startsWith("<?xml")) {
            x = refFragment.indexOf("?>");
            refFragment = refFragment.substring(x + 2);
        }
        String outdoc = "<?xml version='1.1'?><doc>" + outFragment.trim() + "</doc>";
        String refdoc = "<?xml version='1.1'?><doc>" + refFragment.trim() + "</doc>";
        InputSource out2 = new InputSource(new StringReader(outdoc));
        InputSource ref2 = new InputSource(new StringReader(refdoc));
        String outxml2 = canon.toCanonicalXML(this.fragmentParser, out2, true);
        String refxml2 = canon.toCanonicalXML(this.fragmentParser, ref2, true);
        if (outxml2 != null && refxml2 != null && !outxml2.equals(refxml2)) {
            if (!silent) {
                this.log.println("Mismatch with reference results: " + outfile);
                this.log.println("REFERENCE RESULTS:");
                this.log.println(UpdateTestSuiteDriver.truncate(refxml2));
                this.log.println("ACTUAL RESULTS:");
                this.log.println(UpdateTestSuiteDriver.truncate(outxml2));
                this.findDiff(refxml2, outxml2);
            }
            return false;
        }
        if (outxml2 == null) {
            this.log.println("Cannot canonicalize actual results");
            return false;
        }
        if (refxml2 == null) {
            this.log.println("Cannot canonicalize reference results");
            return false;
        }
        return true;
    }

    private static String truncate(String s) {
        if (s.length() > 200) {
            return s.substring(0, 200);
        }
        return s;
    }

    private void findDiff(String s1, String s2) {
        FastStringBuffer sb1 = new FastStringBuffer(s1.length());
        sb1.append(s1);
        FastStringBuffer sb2 = new FastStringBuffer(s2.length());
        sb2.append(s2);
        int i = 0;
        while (true) {
            if (s1.charAt(i) != s2.charAt(i)) {
                int j = i < 50 ? 0 : i - 50;
                int k = i + 50 > s1.length() || i + 50 > s2.length() ? i + 1 : i + 50;
                this.log.println("Different at char " + i + "\n+" + s1.substring(j, k) + "\n+" + s2.substring(j, k));
                break;
            }
            if (i >= s1.length() || i >= s2.length()) break;
            ++i;
        }
    }

    private void outputDiscretionaryItems() throws IOException {
        this.results.write("  <implementation-defined-items>\n");
        this.results.write("    <implementation-defined-item name='supportedRevalidationModes' value='strict lax skip'/>\n");
        this.results.write("    <implementation-defined-item name='defaultRevalidationMode' value='skip'/>\n");
        this.results.write("    <implementation-defined-item name='externalFunctionXDMPUL' value='external functions cannot return a PUL'/>\n");
        this.results.write("    <implementation-defined-item name='fnPutSemantics' value='supported for file URIs; node kinds element and document only'/>\n");
        this.results.write("  </implementation-defined-items>\n");
        this.results.write("  <features>\n");
        this.results.write("    <feature name='Minimal Conformance' supported='true'/>\n");
        this.results.write("    <feature name='Update Facility Static Typing Feature' supported='false'/>\n");
        this.results.write("  </features>\n");
        this.results.write("  <context-properties>\n");
        this.results.write("    <context-property  context-type=\"static\" name=\"Revalidation mode\" value='defaulted'/>\n");
        this.results.write("  </context-properties>\n");
    }

    private String normalizeNewlines(String in) {
        int cr = in.indexOf(13);
        if (cr >= 0 && in.indexOf(cr + 1) == 10) {
            return in.substring(0, cr) + this.normalizeNewlines(in.substring(cr + 1));
        }
        return in;
    }

    static {
        noCacheTests.add("schemainline20_005_01");
        canon = new CanonicalXML();
    }

    private class MyErrorListener
    extends StandardErrorListener {
        public String errorCode;

        public MyErrorListener(PrintStream log) {
            this.setErrorOutput(log);
        }

        public void error(TransformerException exception) throws TransformerException {
            if (exception instanceof XPathException) {
                String code = ((XPathException)exception).getErrorCodeLocalPart();
                if (code != null) {
                    this.errorCode = code;
                }
                if ("FODC0005".equals(this.errorCode) || "FODC0002".equals(this.errorCode)) {
                    this.fatalError(exception);
                }
            }
            super.error(exception);
        }

        public void fatalError(TransformerException exception) throws TransformerException {
            String code;
            if (exception instanceof XPathException && (code = ((XPathException)exception).getErrorCodeLocalPart()) != null) {
                this.errorCode = code;
            }
            super.fatalError(exception);
        }

        public void warning(TransformerException exception) throws TransformerException {
            if (UpdateTestSuiteDriver.this.showWarnings) {
                super.warning(exception);
            }
        }

        public StandardErrorListener makeAnother(int hostLanguage) {
            return new MyErrorListener(UpdateTestSuiteDriver.this.log);
        }
    }
}

