/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.testdriver;

import com.saxonica.config.EnterpriseConfiguration;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.Version;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SchemaManager;
import net.sf.saxon.s9api.SchemaValidator;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltTransformer;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SchemaTestSuiteDriver {
    public static final String testNS = "http://www.w3.org/XML/2004/xml-schema-test-suite/";
    public static final String SCM_SCHEMA_LOCATION = "c:/MyJava/samples/scm/scmschema.scm";
    public static final QName QN_bugzilla = new QName("bugzilla");
    public static final QName QN_contributor = new QName("contributor");
    public static final QName QN_group = new QName("group");
    public static final QName QN_name = new QName("name");
    public static final QName QN_set = new QName("set");
    public static final QName QN_status = new QName("status");
    public static final QName QN_targetNamespace = new QName("targetNamespace");
    public static final QName QN_validity = new QName("validity");
    public static final QName QN_version = new QName("version");
    public static final QName QN_xlink_href = new QName("http://www.w3.org/1999/xlink", "href");
    String testSuiteDir;
    EnterpriseConfiguration catalogConfig;
    Processor catalogProcessor;
    SchemaValidator scmValidator;
    XMLReader parser;
    boolean showWarnings = true;
    boolean onwards = false;
    boolean useSCM = false;
    String versionUnderTest = "1.1";
    XMLStreamWriter results;
    int xlinkHref;

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args[0].equals("-?")) {
            System.err.println("SchemaTestSuiteDriver testDir [-w] [-onwards] [-scm] -v:1.0|1.1 -c:contributor? -s:setName? -g:groupName?");
        }
        System.err.println("Testing Saxon " + Version.getProductVersion());
        new SchemaTestSuiteDriver().go(args);
    }

    private XdmNode getLinkedDocument(XdmNode element, Processor processor, boolean validate) throws URISyntaxException, SaxonApiException {
        String href = element.getAttributeValue(QN_xlink_href);
        URI target = element.getBaseURI().resolve(href);
        StreamSource ss = new StreamSource(target.toString());
        if (validate) {
            SchemaValidator validator = processor.getSchemaManager().newSchemaValidator();
            validator.validate(ss);
            return null;
        }
        DocumentBuilder builder = processor.newDocumentBuilder();
        builder.setLineNumbering(true);
        return processor.newDocumentBuilder().build(ss);
    }

    public void go(String[] args) throws SAXException, ParserConfigurationException, XPathException, IOException, URISyntaxException {
        this.testSuiteDir = args[0];
        Pattern testSetPattern = null;
        Pattern testGroupPattern = null;
        String contributor = null;
        HashMap<String, String> exceptions = new HashMap<String, String>();
        for (int i = 1; i < args.length; ++i) {
            if (args[i].equals("-w")) {
                this.showWarnings = true;
                continue;
            }
            if (args[i].equals("-onwards")) {
                this.onwards = true;
                continue;
            }
            if (args[i].equals("-scm")) {
                this.useSCM = true;
                try {
                    Processor scmProcessor = new Processor(true);
                    scmProcessor.setConfigurationProperty("http://saxon.sf.net/feature/xsd-version", "1.1");
                    scmProcessor.setConfigurationProperty("http://saxon.sf.net/feature/xml-version", "1.1");
                    SchemaManager sm = scmProcessor.getSchemaManager();
                    sm.importComponents(new StreamSource(new File(SCM_SCHEMA_LOCATION)));
                    this.scmValidator = sm.newSchemaValidator();
                }
                catch (SaxonApiException e) {
                    e.printStackTrace();
                    this.useSCM = false;
                }
                continue;
            }
            if (args[i].startsWith("-c:")) {
                contributor = args[i].substring(3);
                continue;
            }
            if (args[i].startsWith("-s:")) {
                testSetPattern = Pattern.compile(args[i].substring(3));
                continue;
            }
            if (args[i].startsWith("-g:")) {
                testGroupPattern = Pattern.compile(args[i].substring(3));
                continue;
            }
            if (args[i].startsWith("-v:")) {
                this.versionUnderTest = args[i].substring(3);
                continue;
            }
            System.err.println("Usage: SchemaTestSuiteDriver testDir [-v:1.0|1.1] [-w] [-s:testSetPattern] [-g:testGroupPattern]");
        }
        try {
            NamePool pool = new NamePool();
            this.catalogConfig = new EnterpriseConfiguration();
            this.catalogConfig.setNamePool(pool);
            this.catalogConfig.setHostLanguage(52);
            this.parser = this.catalogConfig.getSourceParser();
            this.catalogProcessor = new Processor(this.catalogConfig);
            this.xlinkHref = pool.allocate("", "http://www.w3.org/1999/xlink", "href");
            XdmNode catalog = this.catalogProcessor.newDocumentBuilder().build(new File(this.testSuiteDir + "/suite.xml"));
            this.writeResultFilePreamble(this.catalogConfig);
            XdmNode exceptionsDoc = this.catalogProcessor.newDocumentBuilder().build(new File(this.testSuiteDir + "/saxon/exceptions" + (this.versionUnderTest.equals("1.0") ? "" : "11") + ".xml"));
            XPathCompiler xpath = this.catalogProcessor.newXPathCompiler();
            for (XdmItem testCaseItem : xpath.evaluate("//testcase", exceptionsDoc)) {
                XdmNode testCase = (XdmNode)testCaseItem;
                String set = testCase.getAttributeValue(QN_set);
                String group = testCase.getAttributeValue(QN_group);
                String comment = xpath.evaluateSingle("string(comment)", testCase).getStringValue();
                exceptions.put(set + "#" + group, comment);
            }
            xpath.setCaching(true);
            xpath.declareNamespace("", testNS);
            long startTime = new Date().getTime();
            for (XdmItem testCaseRefItem : xpath.evaluate("//testSetRef", catalog)) {
                XdmNode testSetRef = (XdmNode)testCaseRefItem;
                XdmNode testSetDoc = this.getLinkedDocument(testSetRef, this.catalogProcessor, false);
                XdmNode testSetElement = (XdmNode)xpath.evaluateSingle("testSet", testSetDoc);
                if (testSetElement == null) {
                    System.err.println("test set doc has no TestSet child: " + testSetDoc.getBaseURI());
                    continue;
                }
                String testSetName = testSetElement.getAttributeValue(QN_name);
                System.err.println("Test set " + testSetName);
                if (testSetPattern != null && !testSetPattern.matcher(testSetName).matches() || contributor != null && !contributor.equals(testSetElement.getAttributeValue(QN_contributor))) continue;
                String testSetVn = testSetElement.getAttributeValue(QN_version);
                if (testSetVn == null) {
                    testSetVn = "";
                }
                if (!testSetVn.isEmpty() && !testSetVn.contains(this.versionUnderTest)) continue;
                boolean xml11TestSet = testSetVn.contains("XML-1.1");
                for (XdmItem testGroupItem : xpath.evaluate("testGroup", testSetElement)) {
                    XdmNode statusElement;
                    boolean queried;
                    String testName;
                    XdmNode testGroup = (XdmNode)testGroupItem;
                    String testGroupVn = testGroup.getAttributeValue(QN_version);
                    if (testGroupVn == null) {
                        testGroupVn = "";
                    }
                    if (!testGroupVn.isEmpty() && !testGroupVn.contains(this.versionUnderTest)) continue;
                    boolean xml11TestGroup = testGroupVn.contains("XML-1.1");
                    String testGroupName = testGroup.getAttributeValue(QN_name);
                    String exception = (String)exceptions.get(testSetName + "#" + testGroupName);
                    if (testGroupPattern != null && !testGroupPattern.matcher(testGroupName).matches()) continue;
                    System.err.println("TEST SET " + testSetName + " GROUP " + testGroupName);
                    if (this.onwards) {
                        testGroupPattern = null;
                        testSetPattern = null;
                    }
                    EnterpriseConfiguration testConfig = new EnterpriseConfiguration();
                    testConfig.setHostLanguage(52);
                    testConfig.setValidationWarnings(true);
                    testConfig.setConfigurationProperty("http://saxon.sf.net/feature/xsd-version", this.versionUnderTest);
                    if (xml11TestSet || xml11TestGroup) {
                        testConfig.setConfigurationProperty("http://saxon.sf.net/feature/xml-version", "1.1");
                    }
                    Processor testProcessor = new Processor(testConfig);
                    boolean schemaQueried = false;
                    String bugzillaRef = null;
                    for (XdmItem schemaTestItem : xpath.evaluate("schemaTest", testGroup)) {
                        XdmNode schemaTest = (XdmNode)schemaTestItem;
                        bugzillaRef = null;
                        testName = schemaTest.getAttributeValue(QN_name);
                        if (exception != null) {
                            this.results.writeEmptyElement("testResult");
                            this.results.writeAttribute("set", testSetName);
                            this.results.writeAttribute("group", testGroupName);
                            this.results.writeAttribute("test", testName);
                            this.results.writeAttribute("actualValidity", "notKnown");
                            this.results.writeAttribute("saxon:outcome", "notRun");
                            this.results.writeAttribute("saxon:comment", exception);
                            continue;
                        }
                        String schemaTestVn = schemaTest.getAttributeValue(QN_version);
                        if (schemaTestVn != null && !schemaTestVn.contains(this.versionUnderTest)) continue;
                        queried = false;
                        statusElement = (XdmNode)xpath.evaluateSingle("current", schemaTest);
                        if (statusElement != null) {
                            String status = statusElement.getAttributeValue(QN_status);
                            queried = "queried".equals(status) || "disputed-test".equals(status);
                            bugzillaRef = statusElement.getAttributeValue(QN_bugzilla);
                        }
                        if (queried) {
                            schemaQueried = true;
                        }
                        System.err.println("TEST SCHEMA " + testName + (queried ? " (queried)" : ""));
                        boolean success = true;
                        success = this.loadSchemas(xpath, testProcessor, schemaTest, success);
                        XdmNode expected = (XdmNode)xpath.evaluateSingle("expected[not(@version) or contains(@version, '" + this.versionUnderTest + "')]", schemaTest);
                        String expectedOutcome = expected == null ? "indeterminate" : expected.getAttributeValue(QN_validity);
                        boolean ok = "indeterminate".equals(expectedOutcome) || "implementation-defined".equals(expectedOutcome) || "implementation-dependent".equals(expectedOutcome) || success == "valid".equals(expectedOutcome);
                        this.results.writeEmptyElement("testResult");
                        this.results.writeAttribute("set", testSetName);
                        this.results.writeAttribute("group", testGroupName);
                        this.results.writeAttribute("test", testName);
                        this.results.writeAttribute("expectedValidity", expectedOutcome);
                        this.results.writeAttribute("actualValidity", success ? "valid" : "invalid");
                        if (queried) {
                            this.results.writeAttribute("saxon:queried", "true");
                            this.results.writeAttribute("saxon:bugzilla", bugzillaRef);
                            continue;
                        }
                        this.results.writeAttribute("saxon:outcome", ok ? "same" : "different");
                    }
                    for (XdmItem instanceTestItem : xpath.evaluate("instanceTest", testGroup)) {
                        XdmNode instanceTest = (XdmNode)instanceTestItem;
                        testName = instanceTest.getAttributeValue(QN_name);
                        if (exception != null) {
                            this.results.writeEmptyElement("testResult");
                            this.results.writeAttribute("set", testSetName);
                            this.results.writeAttribute("group", testGroupName);
                            this.results.writeAttribute("test", testName);
                            this.results.writeAttribute("actualValidity", "notKnown");
                            this.results.writeAttribute("saxon:outcome", "notRun");
                            this.results.writeAttribute("saxon:comment", exception);
                            continue;
                        }
                        String instanceTestVn = instanceTest.getAttributeValue(QN_version);
                        if (instanceTestVn != null && !instanceTestVn.contains(this.versionUnderTest)) continue;
                        queried = false;
                        statusElement = (XdmNode)xpath.evaluateSingle("current", instanceTest);
                        if (statusElement != null) {
                            String status = statusElement.getAttributeValue(QN_status);
                            queried = "queried".equals(status);
                            String instanceBug = statusElement.getAttributeValue(QN_bugzilla);
                            if (instanceBug != null) {
                                bugzillaRef = instanceBug;
                            }
                        }
                        System.err.println("TEST INSTANCE " + testName + ((queried |= schemaQueried) ? " (queried)" : ""));
                        XdmNode instanceDocument = (XdmNode)xpath.evaluateSingle("instanceDocument", instanceTest);
                        boolean success = true;
                        try {
                            this.getLinkedDocument(instanceDocument, testProcessor, true);
                        }
                        catch (SaxonApiException err) {
                            System.err.println(err.getMessage());
                            success = false;
                        }
                        XdmNode expected = (XdmNode)xpath.evaluateSingle("expected[not(@version) or contains(@version, '" + this.versionUnderTest + "')]", instanceTest);
                        String expectedOutcome = expected == null ? "indeterminate" : expected.getAttributeValue(QN_validity);
                        boolean ok = "indeterminate".equals(expectedOutcome) || "implementation-defined".equals(expectedOutcome) || "implementation-dependent".equals(expectedOutcome) || success == "valid".equals(expectedOutcome);
                        this.results.writeEmptyElement("testResult");
                        this.results.writeAttribute("set", testSetName);
                        this.results.writeAttribute("group", testGroupName);
                        this.results.writeAttribute("test", testName);
                        this.results.writeAttribute("expectedValidity", expectedOutcome);
                        this.results.writeAttribute("actualValidity", success ? "valid" : "invalid");
                        if (queried) {
                            this.results.writeAttribute("saxon:queried", "true");
                            this.results.writeAttribute("saxon:bugzilla", bugzillaRef);
                            continue;
                        }
                        this.results.writeAttribute("saxon:outcome", ok ? "same" : "different");
                    }
                }
            }
            this.writeResultFilePostamble();
            System.err.println("Time: " + (new Date().getTime() - startTime) + " ms");
            this.generateFailureReport();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean loadSchemas(XPathCompiler xpath, Processor testProcessor, XdmNode schemaTest, boolean success) throws URISyntaxException, SaxonApiException {
        if (this.useSCM) {
            return this.loadSchemasViaSCM(xpath, testProcessor, schemaTest, success);
        }
        return this.loadSchemasDirect(xpath, testProcessor, schemaTest, success);
    }

    private boolean loadSchemasDirect(XPathCompiler xpath, Processor processor, XdmNode schemaTest, boolean success) throws SaxonApiException, URISyntaxException {
        for (XdmItem schemaDocRefItem : xpath.evaluate("schemaDocument", schemaTest)) {
            XdmNode schemaDocumentRef = (XdmNode)schemaDocRefItem;
            System.err.println("Loading schema at " + schemaDocumentRef.getAttributeValue(QN_xlink_href));
            XdmNode schemaDoc = this.getLinkedDocument(schemaDocumentRef, processor, false);
            XdmSequenceIterator si = schemaDoc.axisIterator(Axis.CHILD);
            XdmNode schemaElement = si.hasNext() ? (XdmNode)si.next() : null;
            String targetNamespace = schemaElement.getAttributeValue(QN_targetNamespace);
            if (targetNamespace != null && processor.getUnderlyingConfiguration().isSchemaAvailable(targetNamespace)) continue;
            try {
                processor.getSchemaManager().load(schemaDoc.asSource());
            }
            catch (SaxonApiException err) {
                success = false;
            }
        }
        return success;
    }

    private boolean loadSchemasViaSCM(XPathCompiler xpath, Processor testProcessor, XdmNode schemaTest, boolean success) throws SaxonApiException, URISyntaxException {
        Processor tempProcessor = new Processor(true);
        tempProcessor.setConfigurationProperty("http://saxon.sf.net/feature/xsd-version", this.versionUnderTest);
        tempProcessor.setConfigurationProperty("http://saxon.sf.net/feature/xml-version", testProcessor.getConfigurationProperty("http://saxon.sf.net/feature/xml-version"));
        EnterpriseConfiguration tempConfig = (EnterpriseConfiguration)tempProcessor.getUnderlyingConfiguration();
        XPathCompiler tempXPath = tempProcessor.newXPathCompiler();
        for (XdmItem schemaDocRefItem : xpath.evaluate("schemaDocument", schemaTest)) {
            XdmNode schemaDocumentRef = (XdmNode)schemaDocRefItem;
            System.err.println("Loading schema at " + schemaDocumentRef.getAttributeValue(QN_xlink_href));
            XdmNode schemaDoc = this.getLinkedDocument(schemaDocumentRef, tempProcessor, false);
            XdmNode schemaElement = (XdmNode)tempXPath.evaluateSingle("*", schemaDoc);
            String targetNamespace = schemaElement.getAttributeValue(QN_targetNamespace);
            if (targetNamespace != null && tempConfig.isSchemaAvailable(targetNamespace)) continue;
            try {
                tempProcessor.getSchemaManager().load(schemaDoc.asSource());
            }
            catch (SaxonApiException err) {
                return false;
            }
        }
        try {
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            Properties props = new Properties();
            props.setProperty("method", "xml");
            props.setProperty("indent", "yes");
            Receiver serializer = tempConfig.getSerializerFactory().getReceiver(result, tempConfig.makePipelineConfiguration(), props);
            tempConfig.exportComponents(serializer);
            String scm = sw.toString();
            try {
                this.scmValidator.validate(new StreamSource(new StringReader(scm)));
            }
            catch (SaxonApiException e) {
                System.err.println("*** SCM does not validate against schema for SCM ***");
                System.err.println(scm);
                System.exit(2);
            }
            try {
                testProcessor.getSchemaManager().importComponents(new StreamSource(new StringReader(scm)));
            }
            catch (SaxonApiException e) {
                e.printStackTrace();
                System.exit(2);
            }
        }
        catch (XPathException e) {
            if (!e.hasBeenReported()) {
                System.err.println(e.getMessage());
            }
            return false;
        }
        return success;
    }

    protected boolean isExcluded(String testName) {
        return false;
    }

    private void writeResultFilePreamble(Configuration config) throws IOException, XPathException, XMLStreamException {
        BufferedWriter resultWriter = new BufferedWriter(new FileWriter(new File(this.testSuiteDir + "/saxon/SaxonResults" + Version.getProductVersion() + ".xml")));
        Properties resultProperties = new Properties();
        resultProperties.setProperty("method", "xml");
        resultProperties.setProperty("indent", "yes");
        resultProperties.setProperty("{http://saxon.sf.net/}line-length", "120");
        this.results = config.getSerializerFactory().getXMLStreamWriter(new StreamResult(resultWriter), resultProperties);
        this.results.writeStartElement("testSuiteResults");
        this.results.writeDefaultNamespace(testNS);
        this.results.writeNamespace("saxon", "http://saxon.sf.net/");
        this.results.writeAttribute("suite", "XS_2006");
        this.results.writeAttribute("processor", "Saxon " + Version.getProductVariantAndVersion(config) + " with xsdVersion=" + this.versionUnderTest);
        this.results.writeAttribute("submitDate", new Controller(config).getCurrentDateTime().getStringValue().substring(0, 10));
        this.results.writeAttribute("publicationPermission", "public");
    }

    private void writeResultFilePostamble() throws IOException, XMLStreamException {
        this.results.writeEndElement();
        this.results.close();
    }

    private void generateFailureReport() throws SaxonApiException, FileNotFoundException {
        Processor processor = new Processor(true);
        XsltCompiler c = processor.newXsltCompiler();
        XsltTransformer t = c.compile(new StreamSource(new File(this.testSuiteDir + "/saxon/summarize-results.xsl"))).load();
        Serializer ser = new Serializer(new FileOutputStream(this.testSuiteDir + "/saxon/SaxonFailures" + Version.getProductVersion() + ".xml"));
        XdmNode resultDoc = processor.newDocumentBuilder().build(new File(this.testSuiteDir + "/saxon/SaxonResults" + Version.getProductVersion() + ".xml"));
        t.setParameter(new QName("in"), resultDoc);
        t.setInitialTemplate(new QName("all-diffs"));
        t.setDestination(ser);
        t.transform();
    }
}

